/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.dawnoftime.armoroftheages.client.ArmorModelProvider;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;
import org.dawnoftime.armoroftheages.item.HumanoidArmorItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidArmorLayer.class})
public abstract class MixinHumanoidArmorLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    public MixinHumanoidArmorLayer(RenderLayerParent<T, M> parentLayer) {
        super(parentLayer);
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"}, at={@At(value="HEAD")})
    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        this.armorOfTheAges$renderCustomArmor(poseStack, buffer, livingEntity, EquipmentSlot.HEAD, packedLight, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.armorOfTheAges$renderCustomArmor(poseStack, buffer, livingEntity, EquipmentSlot.CHEST, packedLight, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.armorOfTheAges$renderCustomArmor(poseStack, buffer, livingEntity, EquipmentSlot.LEGS, packedLight, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.armorOfTheAges$renderCustomArmor(poseStack, buffer, livingEntity, EquipmentSlot.FEET, packedLight, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    @Unique
    private void armorOfTheAges$renderCustomArmor(PoseStack stack, MultiBufferSource buffer, T entity, EquipmentSlot slot, int packedLight, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ArmorModelProvider provider;
        HumanoidArmorItem armorItem;
        ItemStack itemStack = entity.m_6844_(slot);
        Item item = itemStack.m_41720_();
        if (item instanceof HumanoidArmorItem && (armorItem = (HumanoidArmorItem)item).m_40402_() == slot && (provider = armorItem.getModelProvider()) != null) {
            ArmorModel<?> model = provider.getArmorModel((Entity)entity);
            model.copyEntityModelPosition((HumanoidModel)this.m_117386_());
            model.f_102610_ = entity.m_6162_();
            model.f_102817_ = entity.m_6144_();
            model.f_102609_ = ((HumanoidModel)this.m_117386_()).f_102609_;
            model.m_6973_((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110431_((ResourceLocation)provider.getTexture((Entity)entity)));
            model.m_7695_(stack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            if (itemStack.m_41790_()) {
                model.m_7695_(stack, buffer.m_6299_(RenderType.m_110484_()), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    @Inject(method={"renderArmorPiece"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderArmorPiece(PoseStack stack, MultiBufferSource buffer, T entity, EquipmentSlot slot, int packedLight, A defaultModel, CallbackInfo ci) {
        ItemStack itemStack = entity.m_6844_(slot);
        if (itemStack.m_41720_() instanceof HumanoidArmorItem) {
            ci.cancel();
        }
    }
}

