/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_2960;
import net.minecraft.class_5607;
import org.dawnoftime.armoroftheages.client.ArmorModelProvider;
import org.dawnoftime.armoroftheages.client.ArmorModelSupplier;
import org.jetbrains.annotations.NotNull;

public class AnimatedArmorModelProvider
extends ArmorModelProvider {
    private final class_2960[] resourceLocations;
    private final int ticksPerFrame;

    public static ArmorModelProvider create(String armorName, class_1304 slot, ArmorModelSupplier modelSupplier, Supplier<class_5607> layerDefinitionSupplier, int numberOfFrames, int ticksPerFrame) {
        return new AnimatedArmorModelProvider(armorName, slot, modelSupplier, layerDefinitionSupplier, numberOfFrames, ticksPerFrame);
    }

    public static ArmorModelProvider create(String armorName, class_1304 slot, ArmorModelSupplier modelSupplier, Supplier<class_5607> layerDefinitionSupplier, Supplier<class_5607> slimLayerDefinitionSupplier, int numberOfFrames, int ticksPerFrame) {
        return new AnimatedMixedArmorModelProvider(armorName, slot, modelSupplier, layerDefinitionSupplier, slimLayerDefinitionSupplier, numberOfFrames, ticksPerFrame);
    }

    private AnimatedArmorModelProvider(String armorName, class_1304 slot, ArmorModelSupplier modelSupplier, Supplier<class_5607> layerDefinitionSupplier, int numberOfFrames, int ticksPerFrame) {
        super(armorName, slot, modelSupplier, layerDefinitionSupplier);
        this.resourceLocations = (class_2960[])IntStream.range(0, numberOfFrames).mapToObj(n -> new class_2960("armoroftheages", "textures/models/armor/" + armorName + "_" + (n + 1) + ".png")).toArray(class_2960[]::new);
        this.ticksPerFrame = ticksPerFrame;
    }

    @Override
    @NotNull
    public class_2960 getTexture(class_1297 entity) {
        return this.resourceLocations[entity.field_6012 / this.ticksPerFrame % this.resourceLocations.length];
    }

    public static class AnimatedMixedArmorModelProvider
    extends ArmorModelProvider.MixedArmorModelProvider {
        private final class_2960[] resourceLocations;
        private final class_2960[] slimResourceLocations;
        private final int ticksPerFrame;

        private AnimatedMixedArmorModelProvider(String armorName, class_1304 slot, ArmorModelSupplier modelSupplier, Supplier<class_5607> layerDefinitionSupplier, Supplier<class_5607> slimLayerDefinitionSupplier, int numberOfFrames, int ticksPerFrame) {
            super(armorName, slot, modelSupplier, layerDefinitionSupplier, slimLayerDefinitionSupplier);
            this.resourceLocations = (class_2960[])IntStream.range(0, numberOfFrames).mapToObj(n -> new class_2960("armoroftheages", "textures/models/armor/" + armorName + "_" + (n + 1) + ".png")).toArray(class_2960[]::new);
            this.slimResourceLocations = (class_2960[])IntStream.range(0, numberOfFrames).mapToObj(n -> new class_2960("armoroftheages", "textures/models/armor/" + armorName + "_slim_" + (n + 1) + ".png")).toArray(class_2960[]::new);
            this.ticksPerFrame = ticksPerFrame;
        }

        @Override
        @NotNull
        public class_2960 getTexture(class_1297 entity) {
            if (AnimatedMixedArmorModelProvider.isSlim(entity)) {
                return this.slimResourceLocations[entity.field_6012 / this.ticksPerFrame % this.slimResourceLocations.length];
            }
            return this.resourceLocations[entity.field_6012 / this.ticksPerFrame % this.resourceLocations.length];
        }
    }
}

