/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client;

import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_742;
import org.dawnoftime.armoroftheages.CommonClass;
import org.dawnoftime.armoroftheages.client.ArmorModelSupplier;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;
import org.dawnoftime.armoroftheages.config.AOTAConfig;
import org.dawnoftime.armoroftheages.config.PreferredModel;
import org.jetbrains.annotations.NotNull;

public class ArmorModelProvider {
    protected static final class_2960 PLAYER_RESOURCE_LOCATION = new class_2960("minecraft:player");
    private final Supplier<class_5607> layerDefinitionSupplier;
    protected final ArmorModelSupplier modelSupplier;
    private ArmorModel<?> armorModel;
    private final class_5601 modelLayerLocation;
    private final class_2960 resourceLocation;

    public static ArmorModelProvider create(String armorName, class_1304 slot, ArmorModelSupplier modelSupplier, Supplier<class_5607> layerDefinitionSupplier) {
        return new ArmorModelProvider(armorName, slot, modelSupplier, layerDefinitionSupplier);
    }

    public static ArmorModelProvider create(String armorName, class_1304 slot, ArmorModelSupplier modelSupplier, Supplier<class_5607> layerDefinitionSupplier, Supplier<class_5607> slimLayerDefinitionSupplier) {
        return new MixedArmorModelProvider(armorName, slot, modelSupplier, layerDefinitionSupplier, slimLayerDefinitionSupplier);
    }

    protected ArmorModelProvider(String armorName, class_1304 slot, ArmorModelSupplier modelSupplier, Supplier<class_5607> layerDefinitionSupplier) {
        this.layerDefinitionSupplier = layerDefinitionSupplier;
        this.modelSupplier = modelSupplier;
        this.modelLayerLocation = new class_5601(PLAYER_RESOURCE_LOCATION, armorName + "_" + slot.name().toLowerCase());
        this.resourceLocation = new class_2960("armoroftheages", "textures/models/armor/" + armorName + ".png");
    }

    @NotNull
    public class_2960 getTexture(class_1297 entity) {
        return this.resourceLocation;
    }

    @NotNull
    public class_5601 getLayerLocation() {
        return this.modelLayerLocation;
    }

    public class_5607 createLayer() {
        return this.layerDefinitionSupplier.get();
    }

    public static boolean isSlim(class_1297 entity) {
        class_742 player;
        if (entity == class_310.method_1551().field_1724 && AOTAConfig.get().usePreferredModel) {
            return AOTAConfig.get().preferredModel == PreferredModel.FEMALE;
        }
        if (!AOTAConfig.get().ignoredSynchronizedPreferredModel && CommonClass.CURRENT_PREFERRED_MODEL_MAP.containsKey(entity.method_5667())) {
            return CommonClass.CURRENT_PREFERRED_MODEL_MAP.get(entity.method_5667()) == PreferredModel.FEMALE;
        }
        return entity instanceof class_742 && "slim".equals((player = (class_742)entity).method_3121());
    }

    public ArmorModel<?> getArmorModel(class_1297 entity) {
        if (this.armorModel == null) {
            this.armorModel = this.modelSupplier.create(class_310.method_1551().method_31974().method_32072(this.modelLayerLocation), false);
        }
        return this.armorModel;
    }

    public static class MixedArmorModelProvider
    extends ArmorModelProvider {
        private final Supplier<class_5607> slimLayerDefinitionSupplier;
        private final class_5601 slimModelLayerLocation;
        private final class_2960 slimResourceLocation;
        private ArmorModel<?> slimArmorModel;

        protected MixedArmorModelProvider(String armorName, class_1304 slot, ArmorModelSupplier modelSupplier, Supplier<class_5607> layerDefinitionSupplier, Supplier<class_5607> slimLayerDefinitionSupplier) {
            super(armorName, slot, modelSupplier, layerDefinitionSupplier);
            this.slimLayerDefinitionSupplier = slimLayerDefinitionSupplier;
            this.slimModelLayerLocation = new class_5601(PLAYER_RESOURCE_LOCATION, armorName + "_" + slot.name().toLowerCase() + "_slim");
            this.slimResourceLocation = new class_2960("armoroftheages", "textures/models/armor/" + armorName + "_slim.png");
        }

        @NotNull
        public class_5601 getSlimLayerLocation() {
            return this.slimModelLayerLocation;
        }

        public class_5607 createSlimLayer() {
            return this.slimLayerDefinitionSupplier.get();
        }

        @Override
        @NotNull
        public class_2960 getTexture(class_1297 entity) {
            return MixedArmorModelProvider.isSlim(entity) ? this.slimResourceLocation : super.getTexture(entity);
        }

        @Override
        public ArmorModel<?> getArmorModel(class_1297 entity) {
            if (ArmorModelProvider.isSlim(entity)) {
                if (this.slimArmorModel == null) {
                    this.slimArmorModel = this.modelSupplier.create(class_310.method_1551().method_31974().method_32072(this.slimModelLayerLocation), true);
                }
                return this.slimArmorModel;
            }
            return super.getArmorModel(entity);
        }
    }
}

