/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys;

import com.google.common.base.Suppliers;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.advancements.ModAdvancements;
import online.kingdomkeys.kingdomkeys.api.event.client.CommandMenuEvent;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.CommandMenuGui;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.command.ConvertOldForgeDataCommand;
import online.kingdomkeys.kingdomkeys.command.ModCommands;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.ModData;
import online.kingdomkeys.kingdomkeys.driveform.DriveFormDataLoader;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.handler.EntityEvents;
import online.kingdomkeys.kingdomkeys.integration.epicfight.init.EpicFightIntegration;
import online.kingdomkeys.kingdomkeys.item.KKAccessoryItem;
import online.kingdomkeys.kingdomkeys.item.KKArmorItem;
import online.kingdomkeys.kingdomkeys.item.KKPotionItem;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.item.ModArmorMaterials;
import online.kingdomkeys.kingdomkeys.item.ModComponents;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.item.organization.OrganizationDataLoader;
import online.kingdomkeys.kingdomkeys.leveling.LevelingDataLoader;
import online.kingdomkeys.kingdomkeys.leveling.ModLevels;
import online.kingdomkeys.kingdomkeys.limit.LimitDataLoader;
import online.kingdomkeys.kingdomkeys.limit.ModLimits;
import online.kingdomkeys.kingdomkeys.loot.ModLootModifier;
import online.kingdomkeys.kingdomkeys.magic.MagicDataLoader;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.menu.ModMenus;
import online.kingdomkeys.kingdomkeys.reactioncommands.ModReactionCommands;
import online.kingdomkeys.kingdomkeys.shotlock.ModShotlocks;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeDataLoader;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeDataLoader;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopListDataLoader;
import online.kingdomkeys.kingdomkeys.synthesis.shop.names.NamesListLoader;
import online.kingdomkeys.kingdomkeys.world.SavePointStorage;
import online.kingdomkeys.kingdomkeys.world.dimension.ModDimensions;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.CastleOblivionHandler;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModJsonRegistries;
import online.kingdomkeys.kingdomkeys.world.features.ModFeatures;
import online.kingdomkeys.kingdomkeys.world.structure.ModStructures;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="kingdomkeys")
public class KingdomKeys {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "kingdomkeys";
    public static boolean efmLoaded = false;
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"kingdomkeys");
    private static final Supplier<List<ItemStack>> kkItems = Suppliers.memoize(() -> ModItems.ITEMS.getEntries().stream().map(Supplier::get).map(ItemStack::new).toList());
    private static final Supplier<List<ItemStack>> orgWeapons = Suppliers.memoize(() -> kkItems.get().stream().filter(item -> item.getItem() instanceof IOrgWeapon).toList());
    private static final Supplier<List<ItemStack>> keyblades = Suppliers.memoize(() -> kkItems.get().stream().filter(item -> item.getItem() instanceof KeybladeItem).toList());
    private static final Supplier<List<ItemStack>> keychains = Suppliers.memoize(() -> kkItems.get().stream().filter(item -> item.getItem() instanceof KeychainItem).toList());
    private static final Supplier<List<ItemStack>> equipables = Suppliers.memoize(() -> kkItems.get().stream().filter(item -> item.getItem() instanceof KKPotionItem || item.getItem() instanceof KKArmorItem || item.getItem() instanceof KKAccessoryItem).toList());
    private static final Supplier<List<ItemStack>> misc = Suppliers.memoize(() -> kkItems.get().stream().filter(item -> !(item.getItem() instanceof KeybladeItem) && !(item.getItem() instanceof KeychainItem) && !(item.getItem() instanceof IOrgWeapon) && !(item.getItem() instanceof KKPotionItem) && !(item.getItem() instanceof KKArmorItem) && !(item.getItem() instanceof KKAccessoryItem)).toList());
    public static final Supplier<CreativeModeTab> keyblades_tab = TABS.register("kingdomkeys_keyblades", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.kingdomkeys_keyblades")).icon(() -> {
        List<ItemStack> keybladesList = keyblades.get();
        return keybladesList.get((int)(System.currentTimeMillis() / 1500L) % keybladesList.size());
    }).displayItems((params, output) -> {
        keyblades.get().forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
        keychains.get().forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
    }).withSearchBar(71).backgroundTexture(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"textures/gui/container/tab_kk.png")).hideTitle().build());
    public static final Supplier<CreativeModeTab> organization_tab = TABS.register("kingdomkeys_org_weapons", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.kingdomkeys_org_weapons")).icon(() -> {
        List<ItemStack> orgWeaponsList = orgWeapons.get();
        return orgWeaponsList.get((int)(System.currentTimeMillis() / 1500L) % orgWeaponsList.size());
    }).displayItems((params, output) -> orgWeapons.get().forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).withSearchBar(71).backgroundTexture(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"textures/gui/container/tab_kk.png")).hideTitle().build());
    public static final Supplier<CreativeModeTab> equipables_tab = TABS.register("kingdomkeys_equipables", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.kingdomkeys_equipables")).icon(() -> {
        List<ItemStack> equipablesList = equipables.get();
        return equipablesList.get((int)(System.currentTimeMillis() / 1500L) % equipablesList.size());
    }).displayItems((params, output) -> equipables.get().forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).withSearchBar(71).backgroundTexture(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"textures/gui/container/tab_kk.png")).hideTitle().build());
    public static final Supplier<CreativeModeTab> misc_tab = TABS.register("kingdomkeys_misc", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.kingdomkeys_misc")).icon(() -> new ItemStack((ItemLike)ModBlocks.normalBlox.get())).displayItems((params, output) -> {
        misc.get().forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
        ItemStack linkedSavePoint = new ItemStack((ItemLike)ModBlocks.savepoint.get());
        linkedSavePoint.set(ModComponents.SAVE_POINT_TIER, (Object)SavePointStorage.SavePointType.LINKED.getSerializedName().toUpperCase());
        ItemStack warpPoint = new ItemStack((ItemLike)ModBlocks.savepoint.get());
        warpPoint.set(ModComponents.SAVE_POINT_TIER, (Object)SavePointStorage.SavePointType.WARP.getSerializedName().toUpperCase());
        output.accept(linkedSavePoint);
        output.accept(warpPoint);
    }).withSearchBar(71).backgroundTexture(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"textures/gui/container/tab_kk.png")).hideTitle().build());

    public KingdomKeys(IEventBus modEventBus, ModContainer modContainer) {
        ModMagic.MAGIC.register(modEventBus);
        ModDriveForms.DRIVE_FORMS.register(modEventBus);
        ModAbilities.ABILITIES.register(modEventBus);
        ModLevels.LEVELS.register(modEventBus);
        ModLimits.LIMITS.register(modEventBus);
        ModShotlocks.SHOTLOCKS.register(modEventBus);
        ModReactionCommands.REACTION_COMMANDS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModSounds.SOUNDS.register(modEventBus);
        ModEntities.TILE_ENTITIES.register(modEventBus);
        ModMenus.MENUS.register(modEventBus);
        ModLootModifier.LOOT_MODIFIERS.register(modEventBus);
        ModMobEffects.MOB_EFFECTS.register(modEventBus);
        TABS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModFeatures.RULE_TESTS.register(modEventBus);
        ModFeatures.FEATURES.register(modEventBus);
        ModDimensions.CHUNK_GENERATORS.register(modEventBus);
        ModStructures.STRUCTURES.register(modEventBus);
        ModJsonRegistries.JSON_REGISTRIES.register(modEventBus);
        ModData.ATTACHMENT_TYPES.register(modEventBus);
        ModComponents.COMPONENTS.register(modEventBus);
        ModArmorMaterials.ARMOR_MATERIALS.register(modEventBus);
        ModAdvancements.TRIGGERS.register(modEventBus);
        modEventBus.addListener(this::modLoaded);
        modEventBus.addListener(ModMenus::registerCapabilities);
        if (FMLEnvironment.dist.isClient()) {
            modEventBus.addListener(ModMenus::registerGUIFactories);
        }
        if (ModList.get().isLoaded("epicfight")) {
            efmLoaded = true;
            EpicFightIntegration.initIntegration(modEventBus);
        }
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register((Object)new CastleOblivionHandler());
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModConfigs.CLIENT_SPEC);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfigs.COMMON_SPEC);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ModConfigs.SERVER_SPEC);
        NeoForge.EVENT_BUS.register((Object)new EntityEvents());
    }

    private void modLoaded(FMLLoadCompleteEvent event) {
        if (FMLEnvironment.dist.isClient()) {
            if (ModList.get().isLoaded("epicfight")) {
                // empty if block
            }
            NeoForge.EVENT_BUS.post((Event)new CommandMenuEvent.Construct(CommandMenuGui.INSTANCE));
        }
    }

    @SubscribeEvent
    public void addMoogleHouse(ServerAboutToStartEvent event) {
        ConvertOldForgeDataCommand.run = false;
        this.addPieceToPattern((RegistryAccess)event.getServer().registryAccess(), ResourceLocation.withDefaultNamespace((String)"village/plains/houses"), ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"village/moogle_house_plains"), 2);
        this.addPieceToPattern((RegistryAccess)event.getServer().registryAccess(), ResourceLocation.withDefaultNamespace((String)"village/desert/houses"), ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"village/moogle_house_desert"), 2);
        this.addPieceToPattern((RegistryAccess)event.getServer().registryAccess(), ResourceLocation.withDefaultNamespace((String)"village/savanna/houses"), ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"village/moogle_house_savanna"), 2);
        this.addPieceToPattern((RegistryAccess)event.getServer().registryAccess(), ResourceLocation.withDefaultNamespace((String)"village/snowy/houses"), ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"village/moogle_house_snowy"), 2);
        this.addPieceToPattern((RegistryAccess)event.getServer().registryAccess(), ResourceLocation.withDefaultNamespace((String)"village/taiga/houses"), ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"village/moogle_house_taiga"), 2);
    }

    public void addPieceToPattern(RegistryAccess registryAccess, ResourceLocation pattern, ResourceLocation structure, int weight) {
        Registry registry = registryAccess.registryOrThrow(Registries.TEMPLATE_POOL);
        StructureTemplatePool pat = Objects.requireNonNull((StructureTemplatePool)registry.get(pattern));
        SinglePoolElement piece = (SinglePoolElement)StructurePoolElement.legacy((String)structure.toString()).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pat.templates.add((Object)piece);
        }
        pat.rawTemplates = List.of(Pair.of((Object)piece, (Object)weight));
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        ModCommands.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    @SubscribeEvent
    public void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new KeybladeDataLoader());
        event.addListener((PreparableReloadListener)new OrganizationDataLoader());
        event.addListener((PreparableReloadListener)new RecipeDataLoader());
        event.addListener((PreparableReloadListener)new DriveFormDataLoader());
        event.addListener((PreparableReloadListener)new MagicDataLoader());
        event.addListener((PreparableReloadListener)new LevelingDataLoader());
        event.addListener((PreparableReloadListener)new NamesListLoader.Loader());
        event.addListener((PreparableReloadListener)new ShopListDataLoader());
        event.addListener((PreparableReloadListener)new LimitDataLoader());
        ModJsonRegistries.registry.forEach(arg_0 -> ((AddReloadListenerEvent)event).addListener(arg_0));
    }
}

