/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.ability;

import net.minecraft.resources.ResourceLocation;

public class Ability {
    ResourceLocation name;
    int apCost;
    AbilityType type;
    int order;
    String translationKey;

    public Ability(ResourceLocation registryName, int apCost, AbilityType type, int order) {
        this.name = registryName;
        this.apCost = apCost;
        this.type = type;
        this.order = order;
        this.translationKey = "ability." + registryName.getPath() + ".name";
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public String getTranslationKey(int level) {
        if (level > 0) {
            return this.translationKey.replace(".name", "_" + level + ".name");
        }
        return this.getTranslationKey();
    }

    public String getDescTranslationKey() {
        return this.translationKey.replace(".name", ".desc");
    }

    public int getAPCost() {
        return this.apCost;
    }

    public int getOrder() {
        return this.order;
    }

    public AbilityType getType() {
        return this.type;
    }

    public String toString() {
        return this.name.toString();
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public int compareTo(Ability other) {
        int typeOrder = this.type.compareTo(other.getType());
        return typeOrder == 0 ? Integer.compare(this.order, other.getOrder()) : typeOrder;
    }

    public static enum AbilityType {
        ACTION,
        GROWTH,
        SUPPORT,
        WEAPON,
        ACCESSORY;

    }
}

