/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.api.event;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import online.kingdomkeys.kingdomkeys.shotlock.ModShotlocks;

public abstract class EquipmentEvent
extends Event {
    private final Player player;
    private final ItemStack newStack;
    private final ItemStack previousStack;
    private final int slotFrom;

    private EquipmentEvent(Player player, ItemStack previousStack, ItemStack newStack, int slotFrom) {
        this.player = player;
        this.previousStack = previousStack;
        this.newStack = newStack;
        this.slotFrom = slotFrom;
    }

    public Player getPlayer() {
        return this.player;
    }

    @Nullable
    public ItemStack getNewStack() {
        return this.newStack;
    }

    @Nullable
    public ItemStack getPreviousStack() {
        return this.previousStack;
    }

    public int getSlotFrom() {
        return this.slotFrom;
    }

    public static class Pauldron
    extends BaseEquipment {
        public Pauldron(Player player, ItemStack previousStack, ItemStack newStack, int slotFrom, int slotTo) {
            super(player, previousStack, newStack, slotFrom, slotTo);
        }
    }

    public static class Armour
    extends BaseEquipment {
        public Armour(Player player, ItemStack previousStack, ItemStack newStack, int slotFrom, int slotTo) {
            super(player, previousStack, newStack, slotFrom, slotTo);
        }
    }

    public static class Accessory
    extends BaseEquipment {
        public Accessory(Player player, ItemStack previousStack, ItemStack newStack, int slotFrom, int slotTo) {
            super(player, previousStack, newStack, slotFrom, slotTo);
        }
    }

    public static class Item
    extends BaseEquipment {
        public Item(Player player, ItemStack previousStack, ItemStack newStack, int slotFrom, int slotTo) {
            super(player, previousStack, newStack, slotFrom, slotTo);
        }
    }

    private static class BaseEquipment
    extends EquipmentEvent
    implements ICancellableEvent {
        private final int slotTo;

        private BaseEquipment(Player player, ItemStack previousStack, ItemStack newStack, int slotFrom, int slotTo) {
            super(player, previousStack, newStack, slotFrom);
            this.slotTo = slotTo;
        }

        public int getSlotTo() {
            return this.slotTo;
        }
    }

    public static class Shotlock
    extends EquipmentEvent
    implements ICancellableEvent {
        private final online.kingdomkeys.kingdomkeys.shotlock.Shotlock previousShotlock;
        private final online.kingdomkeys.kingdomkeys.shotlock.Shotlock newShotlock;

        public Shotlock(Player player, ResourceLocation previousShotlock, ResourceLocation newShotlock) {
            super(player, null, null, -1);
            this.newShotlock = (online.kingdomkeys.kingdomkeys.shotlock.Shotlock)ModShotlocks.registry.get(newShotlock);
            this.previousShotlock = (online.kingdomkeys.kingdomkeys.shotlock.Shotlock)ModShotlocks.registry.get(previousShotlock);
        }

        public online.kingdomkeys.kingdomkeys.shotlock.Shotlock getPreviousShotlock() {
            return this.previousShotlock;
        }

        public online.kingdomkeys.kingdomkeys.shotlock.Shotlock getNewShotlock() {
            return this.newShotlock;
        }
    }

    public static class OrgWeapon
    extends EquipmentEvent
    implements ICancellableEvent {
        public OrgWeapon(Player player, ItemStack previousStack, ItemStack newStack) {
            super(player, previousStack, newStack, -1);
        }
    }

    public static class Keychain
    extends EquipmentEvent
    implements ICancellableEvent {
        private final ResourceLocation keychainSlot;

        public Keychain(Player player, ItemStack previousStack, ItemStack newStack, int slotFrom, ResourceLocation keychainSlot) {
            super(player, previousStack, newStack, slotFrom);
            this.keychainSlot = keychainSlot;
        }

        public ResourceLocation getKeychainSlot() {
            return this.keychainSlot;
        }
    }
}

