/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.api.item;

import java.util.HashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;

public class ItemCategoryRegistry {
    public static HashMap<String, ItemCategory> categories = new HashMap();

    public static void register(Item item, ItemCategory category) {
        categories.put(BuiltInRegistries.ITEM.getKey((Object)item).toString(), category);
    }

    public static void register(Block block, ItemCategory category) {
        categories.put(BuiltInRegistries.BLOCK.getKey((Object)block).toString(), category);
    }

    public static boolean hasCategory(Item item) {
        return categories.containsKey(BuiltInRegistries.ITEM.getKey((Object)item).toString());
    }

    public static ItemCategory getCategory(Item item) {
        return categories.get(BuiltInRegistries.ITEM.getKey((Object)item).toString());
    }

    static {
        BuiltInRegistries.BLOCK.forEach(block -> ItemCategoryRegistry.register(block, ItemCategory.BUILDING));
        BuiltInRegistries.ITEM.forEach(item -> {
            if (item instanceof SwordItem || item instanceof ShieldItem || item instanceof PickaxeItem || item instanceof ShovelItem || item instanceof HoeItem || item instanceof AxeItem || item instanceof CrossbowItem || item instanceof BowItem) {
                ItemCategoryRegistry.register(item, ItemCategory.TOOL);
            } else if (item.getDefaultInstance().getFoodProperties(null) != null || item instanceof PotionItem) {
                ItemCategoryRegistry.register(item, ItemCategory.CONSUMABLE);
            } else if (item instanceof ArmorItem || item instanceof ElytraItem) {
                ItemCategoryRegistry.register(item, ItemCategory.EQUIPMENT);
            }
        });
        ItemCategoryRegistry.register(Items.FLINT_AND_STEEL, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.SHEARS, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.COMPASS, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.CLOCK, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.FISHING_ROD, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.LEAD, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.MAP, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.FILLED_MAP, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Blocks.TNT, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Blocks.TORCH, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.BUCKET, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.WATER_BUCKET, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.LAVA_BUCKET, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.TRIDENT, ItemCategory.TOOL);
    }
}

