/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import online.kingdomkeys.kingdomkeys.block.BaseBlock;

public class BounceBloxBlock
extends BaseBlock {
    private static final VoxelShape collisionShape = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public BounceBloxBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void fallOn(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        if (entityIn.isShiftKeyDown()) {
            super.fallOn(worldIn, state, pos, entityIn, fallDistance);
        } else {
            entityIn.causeFallDamage(fallDistance, 0.0f, entityIn.damageSources().fall());
        }
    }

    private void bounce(Entity entity) {
        double bounceFactor = 1.0;
        entity.setDeltaMovement(new Vec3(entity.getDeltaMovement().x(), bounceFactor, entity.getDeltaMovement().z()));
        entity.move(MoverType.SELF, entity.getDeltaMovement());
        entity.fallDistance = 0.0f;
    }

    public void updateEntityAfterFallOn(BlockGetter worldIn, Entity entityIn) {
        if (Math.abs(entityIn.getDeltaMovement().y()) < 0.1 && !entityIn.isCrouching()) {
            this.bounce(entityIn);
        } else {
            super.updateEntityAfterFallOn(worldIn, entityIn);
        }
    }

    public void stepOn(Level worldIn, BlockPos pos, BlockState state, Entity entityIn) {
        if (Math.abs(entityIn.getDeltaMovement().y()) < 0.1 && !entityIn.isCrouching()) {
            this.bounce(entityIn);
        }
        super.stepOn(worldIn, pos, state, entityIn);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return collisionShape;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        double x = entity.getDeltaMovement().x;
        double z = entity.getDeltaMovement().z;
        float force = 1.0f;
        if (entity instanceof LivingEntity && entity.onGround()) {
            force = 3.0f;
        }
        if (pos.south().equals((Object)entity.blockPosition()) || pos.south().below().equals((Object)entity.blockPosition())) {
            z = force;
        } else if (pos.north().equals((Object)entity.blockPosition()) || pos.north().below().equals((Object)entity.blockPosition())) {
            z = -force;
        }
        if (pos.east().equals((Object)entity.blockPosition()) || pos.east().below().equals((Object)entity.blockPosition())) {
            x = force;
        } else if (pos.west().equals((Object)entity.blockPosition()) || pos.west().below().equals((Object)entity.blockPosition())) {
            x = -force;
        }
        if (!entity.isShiftKeyDown()) {
            entity.setDeltaMovement(new Vec3(x, entity.getDeltaMovement().y(), z));
        }
        super.entityInside(state, world, pos, entity);
    }
}

