/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.block.BaseBlock;
import online.kingdomkeys.kingdomkeys.block.INoDataGen;
import online.kingdomkeys.kingdomkeys.data.CastleOblivionData;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.block.CardDoorTileEntity;
import online.kingdomkeys.kingdomkeys.item.card.WorldCardItem;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCOpenCODoorGui;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCastleOblivionInteriorData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.CastleOblivionHandler;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.CastleOblivionEvent;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.Floor;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.DoorData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.Room;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomDirection;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomGenerator;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomPos;

public class CardDoorBlock
extends BaseBlock
implements EntityBlock,
INoDataGen {
    private static final VoxelShape collisionShapeE = Block.box((double)0.0, (double)0.0, (double)-8.0, (double)6.0, (double)32.0, (double)24.0);
    private static final VoxelShape collisionShapeN = Block.box((double)-8.0, (double)0.0, (double)10.0, (double)24.0, (double)32.0, (double)16.0);
    private static final VoxelShape collisionShapeW = Block.box((double)10.0, (double)0.0, (double)-8.0, (double)16.0, (double)32.0, (double)24.0);
    private static final VoxelShape collisionShapeS = Block.box((double)-8.0, (double)0.0, (double)0.0, (double)24.0, (double)32.0, (double)6.0);
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty GENERATED = BooleanProperty.create((String)"generated");
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");

    public CardDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)GENERATED, (Comparable)Boolean.valueOf(false))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)GENERATED, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{GENERATED});
        builder.add(new Property[]{OPEN});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        CardDoorTileEntity te;
        CastleOblivionData.InteriorData cap;
        if (!level.isClientSide && ((Boolean)state.getValue((Property)GENERATED)).booleanValue() && (cap = CastleOblivionData.InteriorData.get((ServerLevel)level)) != null && (te = (CardDoorTileEntity)level.getBlockEntity(pos)) != null && te.getParentRoom() != null) {
            switch (te.getData().getType()) {
                case NORMAL: {
                    if (te.getDestinationRoom() == null) break;
                    KingdomKeys.LOGGER.debug("Size: {}", (Object)te.getParentRoom().getParentFloor((ServerLevel)level).getRooms().size());
                    KingdomKeys.LOGGER.debug("{}: Num:{} Open? {}", (Object)(level.isClientSide ? "Client" : "Server"), (Object)te.getDestinationRoom().getCardCost(), (Object)te.isOpen());
                    PacketHandler.sendTo(new SCOpenCODoorGui(te.getBlockPos()), (ServerPlayer)player);
                    break;
                }
                case FIXED: {
                    if (te.isOpen()) break;
                    break;
                }
                case HALL: {
                    Item item;
                    if (te.isOpen() || !((item = player.getItemInHand(hand).getItem()) instanceof WorldCardItem)) break;
                    WorldCardItem item2 = (WorldCardItem)item;
                    te.getParentRoom().getParentFloor((ServerLevel)level).setWorldCard(item2);
                    te.openDoor(true);
                    CastleOblivionHandler.createFirstRoom(player, te);
                }
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return ModEntities.TYPE_CARD_DOOR.get().create(pPos, pState);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.isClientSide && ((Boolean)state.getValue((Property)GENERATED)).booleanValue() && entity instanceof Player) {
            CardDoorTileEntity te;
            Player player = (Player)entity;
            CastleOblivionData.InteriorData cap = CastleOblivionData.InteriorData.get((ServerLevel)level);
            if (cap != null && (te = (CardDoorTileEntity)level.getBlockEntity(pos)) != null && te.getParentRoom() != null && te.isOpen()) {
                if (te.getDestinationRoom() != null) {
                    RoomData data = te.getDestinationRoom();
                    Room newRoom = data.getGenerated();
                    if (newRoom != null && !((CastleOblivionEvent.PlayerChangeRoomEvent)NeoForge.EVENT_BUS.post((Event)new CastleOblivionEvent.PlayerChangeRoomEvent(cap.getRoomAtPos(te.getBlockPos()), newRoom, player))).isCanceled()) {
                        BlockPos destination = newRoom.doors.get((Object)te.getDirection().opposite()).pos();
                        destination = destination.offset(te.getDirection().toMCDirection().getNormal().multiply(2));
                        player.teleportTo((double)destination.getX(), (double)destination.getY(), (double)destination.getZ());
                        PacketHandler.sendTo(new SCSyncCastleOblivionInteriorData(cap, level), (ServerPlayer)player);
                    }
                } else if (te.getData().getType() != DoorData.Type.EXIT && te.getData().getType() != DoorData.Type.ENTRANCE) {
                    KingdomKeys.LOGGER.error("Door [{}] missing destination room of type {}, something has gone wrong", (Object)te.getBlockPos().toShortString(), (Object)te.getData().getType());
                } else {
                    Floor currFloor = cap.getFloorByID(te.getParentRoom().getParentID());
                    if (te.getData().getType() == DoorData.Type.ENTRANCE) {
                        if (te.getParentRoom().getParentID() == 0) {
                            CastleOblivionHandler.exitCastleOblivion(currFloor, te.getParentRoom().getGenerated(), player);
                            currFloor.floorExited(player);
                        } else {
                            Floor prevFloor = cap.getFloorByID(te.getParentRoom().getParentID() - 1);
                            Room destRoom = prevFloor.getExitRoom().getGenerated();
                            BlockPos destination = destRoom.getExitDoor();
                            destination = destination.offset(((Direction)level.getBlockState(destination).getValue((Property)FACING)).getNormal().multiply(2));
                            player.teleportTo((double)destination.getX(), (double)destination.getY(), (double)destination.getZ());
                            NeoForge.EVENT_BUS.post((Event)new CastleOblivionEvent.PlayerChangeRoomEvent(te.getParentRoom().getGenerated(), destRoom, player));
                            NeoForge.EVENT_BUS.post((Event)new CastleOblivionEvent.PlayerChangeFloorEvent(currFloor, prevFloor, player));
                            currFloor.floorExited(player);
                            prevFloor.floorEntered(player);
                            PacketHandler.sendTo(new SCSyncCastleOblivionInteriorData(cap, level), (ServerPlayer)player);
                        }
                    } else if (te.getData().getType() == DoorData.Type.EXIT) {
                        Floor nextFloor;
                        Room destRoom;
                        if (cap.getFloors().size() == currFloor.getFloorID() + 1) {
                            destRoom = RoomGenerator.INSTANCE.generateNewFloor((ServerLevel)level);
                            nextFloor = cap.getFloorByID(destRoom.parentFloor);
                        } else {
                            nextFloor = cap.getFloorByID(te.getParentRoom().getParentID() + 1);
                            destRoom = nextFloor.getRoom(RoomPos.ZERO).getGenerated();
                        }
                        BlockPos entranceDoor = destRoom.doors.get((Object)RoomDirection.SOUTH).pos();
                        entranceDoor = entranceDoor.offset(((Direction)level.getBlockState(entranceDoor).getValue((Property)FACING)).getNormal().multiply(2));
                        player.teleportTo((double)entranceDoor.getX(), (double)entranceDoor.getY(), (double)entranceDoor.getZ());
                        NeoForge.EVENT_BUS.post((Event)new CastleOblivionEvent.PlayerChangeRoomEvent(te.getParentRoom().getGenerated(), destRoom, player));
                        NeoForge.EVENT_BUS.post((Event)new CastleOblivionEvent.PlayerChangeFloorEvent(currFloor, nextFloor, player));
                        currFloor.floorExited(player);
                        nextFloor.floorEntered(player);
                        PacketHandler.sendTo(new SCSyncCastleOblivionInteriorData(cap, level), (ServerPlayer)player);
                    }
                }
            }
        }
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getShape(state, world, pos, context);
    }

    @Deprecated
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return collisionShapeN;
            }
            case EAST: {
                return collisionShapeE;
            }
            case SOUTH: {
                return collisionShapeS;
            }
            case WEST: {
                return collisionShapeW;
            }
        }
        return collisionShapeS;
    }
}

