/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import online.kingdomkeys.kingdomkeys.block.BaseBlock;

public class DangerBloxBlock
extends BaseBlock {
    private static final VoxelShape collisionShape = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    private final float damage = 3.0f;

    public DangerBloxBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return collisionShape;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity entityLiving = (LivingEntity)entity;
            if (ItemStack.matches((ItemStack)entityLiving.getItemBySlot(EquipmentSlot.FEET), (ItemStack)ItemStack.EMPTY)) {
                entity.hurt(entity.damageSources().magic(), 3.0f);
            }
        } else {
            entity.hurt(entity.damageSources().magic(), 3.0f);
        }
    }

    public void attack(BlockState state, Level world, BlockPos pos, Player player) {
        player.hurt(player.damageSources().magic(), 3.0f);
    }
}

