/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import online.kingdomkeys.kingdomkeys.block.BaseBlock;
import online.kingdomkeys.kingdomkeys.block.INoDataGen;
import online.kingdomkeys.kingdomkeys.command.DimensionCommand;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.entity.mob.MarluxiaEntity;
import online.kingdomkeys.kingdomkeys.world.dimension.ModDimensions;

public class DataPortalBlock
extends BaseBlock
implements INoDataGen {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    private static final VoxelShape collisionShapeEW = Block.box((double)0.0, (double)0.0, (double)-5.0, (double)16.0, (double)48.0, (double)21.0);
    private static final VoxelShape collisionShapeNS = Block.box((double)-5.0, (double)0.0, (double)0.0, (double)21.0, (double)48.0, (double)16.0);

    public DataPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.getShape(pState, pLevel, pPos, pContext);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        PlayerData playerData = PlayerData.get(player);
        if (playerData != null) {
            playerData.setReturnDimension(player);
            playerData.setReturnLocation(player);
        }
        if (!worldIn.isClientSide) {
            ResourceKey<Level> dimension = ModDimensions.STATION_OF_SORROW;
            BlockPos coords = DimensionCommand.getWorldCoords(player, dimension);
            player.changeDimension(new DimensionTransition(player.getServer().getLevel(dimension), new Vec3((double)coords.getX(), (double)coords.getY(), (double)coords.getZ()), Vec3.ZERO, player.getYRot(), player.getXRot(), entity -> {}));
            player.sendSystemMessage((Component)Component.translatable((String)("You have been teleported to " + String.valueOf(dimension.location()))));
            MarluxiaEntity marluxia = new MarluxiaEntity(player.level());
            marluxia.finalizeSpawn((ServerLevelAccessor)((ServerLevel)player.level()), player.level().getCurrentDifficultyAt(marluxia.blockPosition()), MobSpawnType.COMMAND, null);
            player.level().addFreshEntity((Entity)marluxia);
            marluxia.setPos(player.getX(), player.getY(), player.getZ() - 6.0);
        }
        return super.useItemOn(stack, state, worldIn, pos, player, handIn, hit);
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (state.getValue((Property)FACING) == Direction.NORTH || state.getValue((Property)FACING) == Direction.SOUTH) {
            return collisionShapeNS;
        }
        return collisionShapeEW;
    }
}

