/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import online.kingdomkeys.kingdomkeys.block.BaseBlock;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import org.jetbrains.annotations.Nullable;

public class GhostBloxBlock
extends BaseBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty VISIBLE = BooleanProperty.create((String)"visible");

    public GhostBloxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{VISIBLE});
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    @Nonnull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false && (Boolean)state.getValue((Property)VISIBLE) == false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.getValue((Property)VISIBLE) == false && (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false && fluid == Fluids.WATER;
    }

    public boolean placeLiquid(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.getValue((Property)VISIBLE)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && fluidStateIn.getType() == Fluids.WATER) {
            if (!worldIn.isClientSide()) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            }
            return true;
        }
        return false;
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean b) {
        if (worldIn.getBlockState(fromPos).getBlock() == ModBlocks.ghostBlox.get()) {
            worldIn.setBlockAndUpdate(pos, worldIn.getBlockState(fromPos));
            if (worldIn.hasNeighborSignal(pos)) {
                worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(false)));
            }
        } else {
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(!worldIn.hasNeighborSignal(pos))));
        }
        if (((Boolean)worldIn.getBlockState(pos).getValue((Property)VISIBLE)).booleanValue()) {
            worldIn.setBlockAndUpdate(pos, (BlockState)worldIn.getBlockState(pos).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return (Boolean)state.getValue((Property)VISIBLE) != false ? super.getLightBlock(state, worldIn, pos) : 0;
    }

    public boolean isSignalSource(BlockState state) {
        return false;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @javax.annotation.Nullable Direction side) {
        return false;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)VISIBLE) != false ? super.getCollisionShape(state, worldIn, pos, context) : Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)VISIBLE) != false ? super.getShape(state, worldIn, pos, context) : Shapes.empty();
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean b) {
        if (oldState.getBlock() != state.getBlock()) {
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(!worldIn.hasNeighborSignal(pos))));
        }
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity placer, ItemStack stack) {
        if (!worldIn.isClientSide && worldIn.getBlockEntity(pos) == null) {
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(!worldIn.hasNeighborSignal(pos))));
        }
    }

    @javax.annotation.Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }
}

