/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.items.IItemHandler;
import online.kingdomkeys.kingdomkeys.block.INoDataGen;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.block.MagicalChestTileEntity;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MagicalChestBlock
extends BaseEntityBlock
implements INoDataGen {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty BIG = BooleanProperty.create((String)"big");
    private static final VoxelShape collisionShapeEW = Block.box((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)12.0, (double)15.0);
    private static final VoxelShape collisionShapeNS = Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)12.0, (double)14.0);

    public MagicalChestBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BIG, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return MagicalChestBlock.simpleCodec(MagicalChestBlock::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"message.chest.can_be_locked"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)BIG, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, BIG});
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getShape(state, world, pos, context);
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        MagicalChestTileEntity te;
        BlockEntity blockEntity;
        if (state.hasBlockEntity() && (blockEntity = worldIn.getBlockEntity(pos)) instanceof MagicalChestTileEntity && (te = (MagicalChestTileEntity)blockEntity) != null) {
            Player player = (Player)placer;
            te.setOwner(player.getGameProfile().getId());
            player.displayClientMessage((Component)Component.translatable((String)"message.chest.lock"), true);
        }
        super.setPlacedBy(worldIn, pos, state, placer, stack);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        MenuProvider namedContainerProvider = this.getMenuProvider(state, level, pos);
        if (namedContainerProvider != null) {
            MagicalChestTileEntity te;
            BlockEntity blockEntity;
            if (!(player instanceof ServerPlayer)) {
                return ItemInteractionResult.FAIL;
            }
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            if (state.hasBlockEntity() && (blockEntity = level.getBlockEntity(pos)) instanceof MagicalChestTileEntity && (te = (MagicalChestTileEntity)blockEntity) != null) {
                UUID keyblade = te.getKeyblade();
                ItemStack held = player.getItemInHand(hand);
                if (held.getItem() instanceof KeybladeItem) {
                    UUID heldID = Utils.getKeybladeID(held);
                    if (heldID != null) {
                        if (keyblade != null) {
                            if (heldID.equals(keyblade)) {
                                serverPlayerEntity.openMenu(namedContainerProvider, buf -> buf.writeBlockPos(pos));
                            } else {
                                player.displayClientMessage((Component)Component.translatable((String)"message.chest.locked"), true);
                            }
                        } else {
                            te.setKeyblade(heldID);
                            player.displayClientMessage((Component)Component.translatable((String)"message.chest.keyblade_set"), true);
                        }
                    } else if (keyblade == null) {
                        serverPlayerEntity.openMenu(namedContainerProvider, buf -> buf.writeBlockPos(pos));
                    }
                } else {
                    if (keyblade == null) {
                        serverPlayerEntity.openMenu(namedContainerProvider, buf -> buf.writeBlockPos(pos));
                        return ItemInteractionResult.SUCCESS;
                    }
                    player.displayClientMessage((Component)Component.translatable((String)"message.chest.locked"), true);
                }
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Deprecated
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.getValue((Property)FACING) == Direction.NORTH || state.getValue((Property)FACING) == Direction.SOUTH) {
            return collisionShapeNS;
        }
        return collisionShapeEW;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasBlockEntity() && state.getBlock() != newState.getBlock()) {
            IItemHandler itemHandler;
            MagicalChestTileEntity TE = (MagicalChestTileEntity)world.getBlockEntity(pos);
            if (TE != null && (itemHandler = (IItemHandler)TE.inventory.get()) != null) {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    MagicalChestBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)itemHandler.getStackInSlot(i));
                }
            }
            world.removeBlockEntity(pos);
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return ModEntities.TYPE_MAGICAL_CHEST.get().create(pPos, pState);
    }

    @EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            MagicalChestTileEntity te;
            if (event.getState().getBlock() == ModBlocks.magicalChest.get() && event.getState().hasBlockEntity() && (te = (MagicalChestTileEntity)event.getLevel().getBlockEntity(event.getPos())) != null && te.getOwner() != null && !te.getOwner().equals(event.getPlayer().getGameProfile().getId()) && te.getKeyblade() != null && event.getPlayer() != null && !event.getPlayer().isCreative()) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
            ItemStack held;
            Player player = event.getEntity();
            if (player.isCrouching() && (held = player.getItemInHand(event.getHand())).getItem() instanceof KeybladeItem) {
                UUID heldID;
                MagicalChestTileEntity te;
                BlockPos pos = event.getPos();
                Level world = event.getLevel();
                BlockState state = world.getBlockState(pos);
                if (state.getBlock() == ModBlocks.magicalChest.get() && (te = (MagicalChestTileEntity)world.getBlockEntity(pos)) != null && te.getKeyblade() != null && (heldID = Utils.getKeybladeID(held)).equals(te.getKeyblade())) {
                    te.setKeyblade(null);
                    player.displayClientMessage((Component)Component.translatable((String)"message.chest.unlocked"), true);
                }
            }
        }
    }
}

