/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import online.kingdomkeys.kingdomkeys.block.BaseBlock;
import online.kingdomkeys.kingdomkeys.block.INoDataGen;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.block.MagnetBloxTileEntity;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MagnetBloxBlock
extends BaseBlock
implements EntityBlock,
INoDataGen {
    private static final int min = 1;
    private static final int max = 10;
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final IntegerProperty RANGE = IntegerProperty.create((String)"range", (int)1, (int)10);
    public static final BooleanProperty ATTRACT = BooleanProperty.create((String)"attract");
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public MagnetBloxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)RANGE, (Comparable)Integer.valueOf(1))).setValue((Property)ATTRACT, (Comparable)Boolean.valueOf(true))).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, RANGE, ATTRACT, ACTIVE});
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return side != state.getValue((Property)FACING);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(worldIn.hasNeighborSignal(pos))));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite())).setValue((Property)ATTRACT, (Comparable)Boolean.valueOf(true))).setValue((Property)RANGE, (Comparable)Integer.valueOf(1))).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return super.shouldCheckWeakPower(state, level, pos, side);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.isCrouching()) {
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ATTRACT, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)ATTRACT) == false)));
            Object message = (Boolean)state.getValue((Property)ATTRACT) != false ? "message.magnet_blox.repel" : "message.magnet_blox.attract";
            message = Utils.translateToLocal((String)message, new Object[0]);
            ChatFormatting formatting = (Boolean)state.getValue((Property)ATTRACT) != false ? ChatFormatting.BLUE : ChatFormatting.RED;
            message = String.valueOf(formatting) + (String)message;
            player.displayClientMessage((Component)Component.translatable((String)message), true);
        } else {
            int newRange = (Integer)state.getValue((Property)RANGE) + 1;
            if ((Integer)state.getValue((Property)RANGE) == 10) {
                newRange = 1;
            }
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)RANGE, (Comparable)Integer.valueOf(newRange)));
            player.displayClientMessage((Component)Component.translatable((String)"message.magnet_blox.range", (Object[])new Object[]{newRange}), true);
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return ModEntities.TYPE_MAGNET_BLOX.get().create(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModEntities.TYPE_MAGNET_BLOX.get() ? MagnetBloxTileEntity::tick : null;
    }
}

