/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import online.kingdomkeys.kingdomkeys.block.AirStepBlock;
import online.kingdomkeys.kingdomkeys.block.BlastBloxBlock;
import online.kingdomkeys.kingdomkeys.block.BounceBloxBlock;
import online.kingdomkeys.kingdomkeys.block.CardDoorBlock;
import online.kingdomkeys.kingdomkeys.block.CastleOblivionPillarBlock;
import online.kingdomkeys.kingdomkeys.block.CastleOblivionSlabBlock;
import online.kingdomkeys.kingdomkeys.block.CastleOblivionStairBlock;
import online.kingdomkeys.kingdomkeys.block.CastleOblivionWallBlock;
import online.kingdomkeys.kingdomkeys.block.DangerBloxBlock;
import online.kingdomkeys.kingdomkeys.block.DataPortalBlock;
import online.kingdomkeys.kingdomkeys.block.GhostBloxBlock;
import online.kingdomkeys.kingdomkeys.block.GummiEditorBlock;
import online.kingdomkeys.kingdomkeys.block.KKOreBlock;
import online.kingdomkeys.kingdomkeys.block.MagicalChestBlock;
import online.kingdomkeys.kingdomkeys.block.MagnetBloxBlock;
import online.kingdomkeys.kingdomkeys.block.MoogleProjectorBlock;
import online.kingdomkeys.kingdomkeys.block.MosaicStainedGlassBlock;
import online.kingdomkeys.kingdomkeys.block.OrgPortalBlock;
import online.kingdomkeys.kingdomkeys.block.PairBloxBlock;
import online.kingdomkeys.kingdomkeys.block.PedestalBlock;
import online.kingdomkeys.kingdomkeys.block.SavePointBlock;
import online.kingdomkeys.kingdomkeys.block.SoADoorBlock;
import online.kingdomkeys.kingdomkeys.block.SoAPlatformCoreBlock;
import online.kingdomkeys.kingdomkeys.block.SoRCore;
import online.kingdomkeys.kingdomkeys.block.StructureWallBlock;
import online.kingdomkeys.kingdomkeys.item.ModItems;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"kingdomkeys");
    public static final Supplier<Block> normalBlox = ModBlocks.createNewBlock("normal_blox", BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.0f, 10.0f));
    public static final Supplier<Block> hardBlox = ModBlocks.createNewBlock("hard_blox", BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 20.0f).requiresCorrectToolForDrops());
    public static final Supplier<Block> metalBlox = ModBlocks.createNewBlock("metal_blox", BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(10.0f, 60.0f).requiresCorrectToolForDrops());
    public static final Supplier<Block> dangerBlox = ModBlocks.createNewBlock("danger_blox", () -> new DangerBloxBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.0f)));
    public static final Supplier<Block> bounceBlox = ModBlocks.createNewBlock("bounce_blox", () -> new BounceBloxBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.0f, 10.0f)));
    public static final Supplier<Block> blastBlox = ModBlocks.createNewBlock("blast_blox", () -> new BlastBloxBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.0f, 10.0f)));
    public static final Supplier<Block> ghostBlox = ModBlocks.createNewBlock("ghost_blox", () -> new GhostBloxBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.0f, 10.0f)));
    public static final Supplier<Block> prizeBlox = ModBlocks.createNewBlock("prize_blox", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.0f, 10.0f)));
    public static final Supplier<Block> rarePrizeBlox = ModBlocks.createNewBlock("rare_prize_blox", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.0f, 10.0f)));
    public static final Supplier<Block> magnetBlox = ModBlocks.createNewBlock("magnet_blox", () -> new MagnetBloxBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.0f, 1.0f)));
    public static final Supplier<Block> pairBlox = ModBlocks.createNewBlock("pair_blox", () -> new PairBloxBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.0f, 10.0f)));
    public static final Supplier<Block> blazingOre = ModBlocks.createNewBlock("blazing_ore", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f).lightLevel(state -> 4)));
    public static final Supplier<Block> blazingOreN = ModBlocks.createNewBlock("blazing_ore_n", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f).lightLevel(state -> 4)));
    public static final Supplier<Block> blazingOreD = ModBlocks.createNewBlock("blazing_ore_d", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f).lightLevel(state -> 4)));
    public static final Supplier<Block> soothingOre = ModBlocks.createNewBlock("soothing_ore", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> soothingOreD = ModBlocks.createNewBlock("soothing_ore_d", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> writhingOre = ModBlocks.createNewBlock("writhing_ore", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> writhingOreN = ModBlocks.createNewBlock("writhing_ore_n", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> writhingOreE = ModBlocks.createNewBlock("writhing_ore_e", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> writhingOreD = ModBlocks.createNewBlock("writhing_ore_d", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> betwixtOre = ModBlocks.createNewBlock("betwixt_ore", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> betwixtOreD = ModBlocks.createNewBlock("betwixt_ore_d", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> betwixtOreE = ModBlocks.createNewBlock("betwixt_ore_e", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> wellspringOre = ModBlocks.createNewBlock("wellspring_ore", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> wellspringOreN = ModBlocks.createNewBlock("wellspring_ore_n", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> frostOre = ModBlocks.createNewBlock("frost_ore", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> frostOreD = ModBlocks.createNewBlock("frost_ore_d", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> lucidOre = ModBlocks.createNewBlock("lucid_ore", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> lightningOre = ModBlocks.createNewBlock("lightning_ore", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f).lightLevel(state -> 4)));
    public static final Supplier<Block> pulsingOre = ModBlocks.createNewBlock("pulsing_ore", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> pulsingOreE = ModBlocks.createNewBlock("pulsing_ore_e", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> pulsingOreD = ModBlocks.createNewBlock("pulsing_ore_d", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> remembranceOre = ModBlocks.createNewBlock("remembrance_ore", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> hungryOre = ModBlocks.createNewBlock("hungry_ore", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> sinisterOre = ModBlocks.createNewBlock("sinister_ore", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> sinisterOreD = ModBlocks.createNewBlock("sinister_ore_d", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> stormyOre = ModBlocks.createNewBlock("stormy_ore", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> stormyOreD = ModBlocks.createNewBlock("stormy_ore_d", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> tranquilityOre = ModBlocks.createNewBlock("tranquility_ore", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> twilightOre = ModBlocks.createNewBlock("twilight_ore", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> twilightOreN = ModBlocks.createNewBlock("twilight_ore_n", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> twilightOreD = ModBlocks.createNewBlock("twilight_ore_d", () -> new KKOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(2.0f, 1.0f)));
    public static final Supplier<Block> savepoint = ModBlocks.createNewBlock("savepoint", () -> new SavePointBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(2.0f, 1.0f)));
    public static final Supplier<Block> magicalChest = ModBlocks.createNewBlock("magical_chest", () -> new MagicalChestBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(2.0f, 1.0f)));
    public static final Supplier<Block> soADoor = ModBlocks.createNewBlock("soa_door", () -> new SoADoorBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(2.0f, 1.0f)));
    public static final Supplier<Block> pedestal = ModBlocks.createNewBlock("pedestal", () -> new PedestalBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(2.0f, 1.0f)));
    public static final Supplier<Block> mosaic_stained_glass = ModBlocks.createNewBlock("mosaic_stained_glass", () -> new MosaicStainedGlassBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).lightLevel(state -> (Boolean)state.getValue((Property)MosaicStainedGlassBlock.STRUCTURE) != false ? 15 : 0).noOcclusion().sound(SoundType.GLASS).strength(1.0f, 10.0f)));
    public static final Supplier<Block> station_of_awakening_core = ModBlocks.createNewBlock("station_of_awakening_core", () -> new SoAPlatformCoreBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).noOcclusion().sound(SoundType.GLASS).strength(1.0f, 10.0f)));
    public static final Supplier<Block> orgPortal = ModBlocks.createNewBlock("org_portal", () -> new OrgPortalBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(2.0f, 1.0f)));
    public static final Supplier<Block> moogleProjector = ModBlocks.createNewBlock("moogle_projector", () -> new MoogleProjectorBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).lightLevel(state -> 6).noOcclusion().strength(2.0f, 1.0f)));
    public static final Supplier<Block> gummiEditor = ModBlocks.createNewBlock("gummi_editor", () -> new GummiEditorBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(2.0f, 1.0f)));
    public static final Supplier<Block> sorCore = ModBlocks.createNewBlock("sor_core", () -> new SoRCore(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(2.0f, 1.0f)));
    public static final Supplier<Block> dataPortal = ModBlocks.createNewBlock("data_portal", () -> new DataPortalBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(2.0f, 1.0f)));
    public static final Supplier<Block> cardDoor = ModBlocks.createNewBlock("card_door", () -> new CardDoorBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(-1.0f, 3600000.0f)));
    public static final Supplier<Block> structureWall = ModBlocks.createNewBlock("structure_wall", () -> new StructureWallBlock(BlockBehaviour.Properties.of().noOcclusion().strength(-1.0f, 3600000.0f).dropsLike(Blocks.AIR).isValidSpawn((p1, p2, p3, p4) -> false)));
    public static final Supplier<Block> castleOblivionWall = ModBlocks.createNewBlock("castle_oblivion_wall", () -> new CastleOblivionWallBlock(BlockBehaviour.Properties.of().noOcclusion().strength(-1.0f, 3600000.0f)));
    public static final Supplier<Block> castleOblivionWallChiseled = ModBlocks.createNewBlock("castle_oblivion_wall_chiseled", () -> new CastleOblivionWallBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).noOcclusion().strength(-1.0f, 3600000.0f)));
    public static final Supplier<Block> castleOblivionWall2 = ModBlocks.createNewBlock("castle_oblivion_wall2", () -> new CastleOblivionWallBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).noOcclusion().strength(-1.0f, 3600000.0f)));
    public static final Supplier<Block> castleOblivionWall3 = ModBlocks.createNewBlock("castle_oblivion_wall3", () -> new CastleOblivionWallBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).noOcclusion().strength(-1.0f, 3600000.0f)));
    public static final Supplier<Block> castleOblivionPillar = ModBlocks.createNewBlock("castle_oblivion_pillar", () -> new CastleOblivionPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).noOcclusion().strength(-1.0f, 3600000.0f)));
    public static final Supplier<Block> castleOblivionStairs = ModBlocks.createNewBlock("castle_oblivion_stairs", () -> new CastleOblivionStairBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).noOcclusion().strength(-1.0f, 3600000.0f)));
    public static final Supplier<Block> castleOblivionSlab = ModBlocks.createNewBlock("castle_oblivion_slab", () -> new CastleOblivionSlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).noOcclusion().strength(-1.0f, 3600000.0f)));
    public static final Supplier<Block> rodSand = ModBlocks.createNewBlock("rod_sand", BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).sound(SoundType.SAND).strength(1.0f, 10.0f));
    public static final Supplier<Block> rodStone = ModBlocks.createNewBlock("rod_stone", BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(1.0f, 10.0f));
    public static final Supplier<Block> rodCrackedStone = ModBlocks.createNewBlock("rod_cracked_stone", BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(1.0f, 10.0f).lightLevel(state -> 14));
    public static final Supplier<Block> airstepTarget = ModBlocks.createNewBlock("airstep_target", () -> new AirStepBlock(BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).instrument(NoteBlockInstrument.CHIME).strength(1.0f, 10.0f).lightLevel(state -> 10)));

    private static Supplier<Block> createNewBlock(String name, BlockBehaviour.Properties properties) {
        DeferredBlock newBlock = BLOCKS.register(name, () -> new Block(properties));
        ModBlocks.createNewBlockItem(name, newBlock);
        return newBlock;
    }

    private static Supplier<Block> createNewBlock(String name, BlockBehaviour.Properties properties, CreativeModeTab tab) {
        DeferredBlock newBlock = BLOCKS.register(name, () -> new Block(properties));
        ModBlocks.createNewBlockItem(name, newBlock, tab);
        return newBlock;
    }

    private static <T extends Block> Supplier<T> createNewBlock(String name, Supplier<? extends T> block) {
        DeferredBlock newBlock = BLOCKS.register(name, block);
        ModBlocks.createNewBlockItem(name, newBlock);
        return newBlock;
    }

    private static <T extends Block> void createNewBlockItem(String name, Supplier<? extends T> block) {
        Supplier<BlockItem> item = () -> new BlockItem(Objects.requireNonNull((Block)block.get()), new Item.Properties());
        ModItems.ITEMS.register(name, item);
    }

    private static <T extends Block> void createNewBlockItem(String name, Supplier<? extends T> block, CreativeModeTab tab) {
        Supplier<BlockItem> item = () -> new BlockItem(Objects.requireNonNull((Block)block.get()), new Item.Properties());
        ModItems.ITEMS.register(name, item);
    }
}

