/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import java.util.ArrayList;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import online.kingdomkeys.kingdomkeys.block.INoDataGen;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;

@EventBusSubscriber
public class MosaicStainedGlassBlock
extends StainedGlassBlock
implements INoDataGen {
    public static final BooleanProperty STRUCTURE = BooleanProperty.create((String)"structure");

    public MosaicStainedGlassBlock(BlockBehaviour.Properties properties) {
        super(DyeColor.LIME, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)STRUCTURE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{STRUCTURE});
    }

    public RenderShape getRenderShape(BlockState state) {
        return (Boolean)state.getValue((Property)STRUCTURE) != false ? RenderShape.INVISIBLE : super.getRenderShape(state);
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        if (event.getState().getBlock() == ModBlocks.mosaic_stained_glass.get() && ((Boolean)event.getState().getValue((Property)STRUCTURE)).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        ArrayList toRemove = new ArrayList();
        event.getAffectedBlocks().forEach(block -> {
            BlockState state = event.getLevel().getBlockState(block);
            if (state.getBlock() == ModBlocks.mosaic_stained_glass.get() && ((Boolean)state.getValue((Property)STRUCTURE)).booleanValue()) {
                toRemove.add(block);
            }
        });
        if (!toRemove.isEmpty()) {
            event.getAffectedBlocks().removeAll(toRemove);
        }
    }
}

