/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.entity.block.PairBloxEntity;

public class PairBloxBlock
extends FallingBlock {
    public static final IntegerProperty PAIR = IntegerProperty.create((String)"pair", (int)0, (int)2);

    public PairBloxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)PAIR, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return PairBloxBlock.simpleCodec(PairBloxBlock::new);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PAIR});
    }

    public void attack(BlockState state, Level worldIn, BlockPos pos, Player player) {
        PairBloxEntity pairEntity = new PairBloxEntity(worldIn, pos.getX(), pos.getY(), pos.getZ(), (Integer)state.getValue((Property)PAIR));
        float velocity = 0.5f;
        switch (Mth.floor((double)((double)(player.getYRot() * 8.0f / 360.0f) + 0.5)) & 7) {
            case 0: {
                pairEntity.setDeltaMovement(0.0, 0.0, velocity);
                break;
            }
            case 1: {
                pairEntity.setDeltaMovement(-velocity, 0.0, velocity);
                break;
            }
            case 2: {
                pairEntity.setDeltaMovement(-velocity, 0.0, 0.0);
                break;
            }
            case 3: {
                pairEntity.setDeltaMovement(-velocity, 0.0, -velocity);
                break;
            }
            case 4: {
                pairEntity.setDeltaMovement(0.0, 0.0, -velocity);
                break;
            }
            case 5: {
                pairEntity.setDeltaMovement(velocity, 0.0, -velocity);
                break;
            }
            case 6: {
                pairEntity.setDeltaMovement(velocity, 0.0, 0.0);
                break;
            }
            case 7: {
                pairEntity.setDeltaMovement(velocity, 0.0, velocity);
            }
        }
        worldIn.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        worldIn.addFreshEntity((Entity)pairEntity);
        super.attack(state, worldIn, pos, player);
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (worldIn.isEmptyBlock(pos.below()) || PairBloxBlock.canFallThrough(worldIn.getBlockState(pos.below())) && pos.getY() >= 0) {
            worldIn.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            PairBloxEntity pairEntity = new PairBloxEntity((Level)worldIn, pos.getX(), pos.getY(), pos.getZ(), (Integer)state.getValue((Property)PAIR));
            pairEntity.setDeltaMovement(0.0, -1.0, 0.0);
            worldIn.addFreshEntity((Entity)pairEntity);
        }
    }

    public static boolean canFallThrough(BlockState state) {
        Block block = state.getBlock();
        return state.isAir() || block == Blocks.FIRE || state.liquid() || state.canBeReplaced();
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockState other = null;
        BlockPos[] positions = new BlockPos[]{pos.north(), pos.east(), pos.south(), pos.west()};
        int i = 0;
        for (i = 0; i < positions.length; ++i) {
            if (world.getBlockState(positions[i]).getBlock() != ModBlocks.pairBlox.get().defaultBlockState().getBlock()) continue;
            other = world.getBlockState(positions[i]);
            break;
        }
        if (other != null && (Integer)state.getValue((Property)PAIR) < 2 && (Integer)other.getValue((Property)PAIR) < 2 && state.getValue((Property)PAIR) != other.getValue((Property)PAIR)) {
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            world.setBlockAndUpdate(positions[i], Blocks.AIR.defaultBlockState());
            world.setBlockAndUpdate(positions[i], (BlockState)ModBlocks.pairBlox.get().defaultBlockState().setValue((Property)PAIR, (Comparable)Integer.valueOf(2)));
        } else {
            world.scheduleTick(pos, (Block)this, this.getDelayAfterPlace());
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)PAIR, (Comparable)Integer.valueOf(0));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if ((Integer)state.getValue((Property)PAIR) < 2) {
            int newState = (Integer)state.getValue((Property)PAIR) == 0 ? 1 : 0;
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PAIR, (Comparable)Integer.valueOf(newState)));
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }
}

