/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import online.kingdomkeys.kingdomkeys.block.INoDataGen;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.block.PedestalTileEntity;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCOpenChoiceScreen;

public class PedestalBlock
extends BaseEntityBlock
implements INoDataGen {
    private static final VoxelShape collision = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);

    public PedestalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return PedestalBlock.simpleCodec(PedestalBlock::new);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return collision;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShape(state, worldIn, pos, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        PedestalTileEntity te;
        BlockEntity blockEntity;
        if (worldIn.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        MenuProvider namedContainerProvider = this.getMenuProvider(state, worldIn, pos);
        if (namedContainerProvider == null) return ItemInteractionResult.SUCCESS;
        if (!(player instanceof ServerPlayer)) {
            return ItemInteractionResult.FAIL;
        }
        ServerPlayer serverPlayerEntity = (ServerPlayer)player;
        if (!state.hasBlockEntity() || !((blockEntity = worldIn.getBlockEntity(pos)) instanceof PedestalTileEntity) || (te = (PedestalTileEntity)blockEntity) == null) return ItemInteractionResult.SUCCESS;
        if (te.isStationOfAwakeningMarker()) {
            PlayerData playerData = PlayerData.get(player);
            SoAState soAState = playerData.getSoAState();
            if (soAState != SoAState.CHOICE && (soAState != SoAState.SACRIFICE || playerData.getChoicePedestal().equals((Object)pos))) return ItemInteractionResult.FAIL;
            PacketHandler.sendTo(new SCOpenChoiceScreen(te.getDisplayStack(), soAState, pos), serverPlayerEntity);
            return ItemInteractionResult.SUCCESS;
        } else {
            serverPlayerEntity.openMenu(namedContainerProvider, packetBuffer -> packetBuffer.writeBlockPos(pos));
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasBlockEntity() && state.getBlock() != newState.getBlock()) {
            IItemHandler itemHandler;
            PedestalTileEntity TE = (PedestalTileEntity)world.getBlockEntity(pos);
            if (TE != null && (itemHandler = (IItemHandler)TE.inventory.get()) != null) {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    PedestalBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)itemHandler.getStackInSlot(i));
                }
            }
            world.removeBlockEntity(pos);
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    @Deprecated
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModEntities.TYPE_PEDESTAL.get() ? PedestalTileEntity::tick : null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return ModEntities.TYPE_PEDESTAL.get().create(pPos, pState);
    }
}

