/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import online.kingdomkeys.kingdomkeys.block.BaseBlock;
import online.kingdomkeys.kingdomkeys.block.INoDataGen;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.block.SavepointTileEntity;
import online.kingdomkeys.kingdomkeys.item.ModComponents;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCDeleteSavePointScreenshot;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;
import online.kingdomkeys.kingdomkeys.network.stc.SCUpdateSavePoints;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.SavePointStorage;

public class SavePointBlock
extends BaseBlock
implements EntityBlock,
INoDataGen {
    private static final VoxelShape collisionShape = Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)16.0);
    public static final EnumProperty<SavePointStorage.SavePointType> TIER = EnumProperty.create((String)"tier", SavePointStorage.SavePointType.class);

    public SavePointBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(TIER, (Comparable)((Object)SavePointStorage.SavePointType.NORMAL)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockItem blockItem;
        ItemStack held = pContext.getItemInHand();
        Item item = held.getItem();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() == ModBlocks.savepoint.get() && held.has(ModComponents.SAVE_POINT_TIER)) {
            return (BlockState)this.defaultBlockState().setValue(TIER, (Comparable)((Object)SavePointStorage.SavePointType.valueOf((String)held.get(ModComponents.SAVE_POINT_TIER))));
        }
        return (BlockState)this.defaultBlockState().setValue(TIER, (Comparable)((Object)SavePointStorage.SavePointType.NORMAL));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (stack.has(ModComponents.SAVE_POINT_TIER) && tooltipComponents.get(0) != null) {
            if (((String)stack.get(ModComponents.SAVE_POINT_TIER)).equals(SavePointStorage.SavePointType.LINKED.getSerializedName().toUpperCase())) {
                tooltipComponents.set(0, (Component)Component.translatable((String)"block.kingdomkeys.linked_savepoint"));
            } else if (((String)stack.get(ModComponents.SAVE_POINT_TIER)).equals(SavePointStorage.SavePointType.WARP.getSerializedName().toUpperCase())) {
                tooltipComponents.set(0, (Component)Component.translatable((String)"block.kingdomkeys.warp_point"));
            }
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{TIER});
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return collisionShape;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return collisionShape;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (pNewState.getBlock() != this && pState.getValue(TIER) != SavePointStorage.SavePointType.NORMAL && !pLevel.isClientSide()) {
            SavepointTileEntity te = (SavepointTileEntity)pLevel.getBlockEntity(pPos);
            SavePointStorage storage = SavePointStorage.getStorage(pLevel.getServer());
            if (storage.savePointRegistered(te.getID())) {
                SavePointStorage.SavePoint removed = storage.getSavePoint(te.getID());
                storage.removeSavePoint(te.getID());
                for (Level level : pLevel.getServer().getAllLevels()) {
                    for (Player playerFromList : level.players()) {
                        PacketHandler.sendTo(new SCUpdateSavePoints(storage.getDiscoveredSavePoints(playerFromList)), (ServerPlayer)playerFromList);
                        PacketHandler.sendTo(new SCDeleteSavePointScreenshot(removed.name(), removed.id()), (ServerPlayer)playerFromList);
                    }
                }
            }
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!stack.isEmpty() && (blockEntity = worldIn.getBlockEntity(pos)) instanceof SavepointTileEntity) {
            String list;
            SavepointTileEntity savepoint = (SavepointTileEntity)blockEntity;
            if (worldIn.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            switch ((SavePointStorage.SavePointType)((Object)state.getValue(TIER))) {
                default: {
                    throw new MatchException(null, null);
                }
                case NORMAL: {
                    String string = ModConfigs.savePointRecovers;
                    break;
                }
                case LINKED: {
                    String string = ModConfigs.linkedSavePointRecovers;
                    break;
                }
                case WARP: {
                    String string = list = ModConfigs.warpPointRecovers;
                }
            }
            if (stack.getItem() == ModItems.orichalcum.get()) {
                if (savepoint.getHeal() > 1 && list.contains("HP")) {
                    stack.shrink(1);
                    savepoint.setHeal(Math.max(savepoint.getHeal() - 4, 1));
                    player.displayClientMessage((Component)Component.translatable((String)"savepoint.upgrade", (Object[])new Object[]{Utils.translateToLocal("savepoint.healing", new Object[0]), Utils.getSavepointPercent(savepoint.getHeal())}), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"savepoint.maxed", (Object[])new Object[]{Utils.translateToLocal("savepoint.healing", new Object[0])}), true);
                }
            } else if (stack.getItem() == ModItems.illusory_crystal.get()) {
                if (savepoint.getMagic() > 1 && list.contains("MP")) {
                    stack.shrink(1);
                    savepoint.setMagic(Math.max(savepoint.getMagic() - 4, 1));
                    player.displayClientMessage((Component)Component.translatable((String)"savepoint.upgrade", (Object[])new Object[]{Utils.translateToLocal("savepoint.magic", new Object[0]), Utils.getSavepointPercent(savepoint.getMagic())}), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"savepoint.maxed", (Object[])new Object[]{Utils.translateToLocal("savepoint.magic", new Object[0])}), true);
                }
            } else if (stack.getItem() == ModItems.hungry_crystal.get()) {
                if (savepoint.getHunger() > 1 && list.contains("HUNGER")) {
                    stack.shrink(1);
                    savepoint.setHunger(Math.max(savepoint.getHunger() - 4, 1));
                    player.displayClientMessage((Component)Component.translatable((String)"savepoint.upgrade", (Object[])new Object[]{Utils.translateToLocal("savepoint.feed", new Object[0]), Utils.getSavepointPercent(savepoint.getHunger())}), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"savepoint.maxed", (Object[])new Object[]{Utils.translateToLocal("savepoint.feed", new Object[0])}), true);
                }
            } else if (stack.getItem() == ModItems.remembrance_crystal.get()) {
                if (savepoint.getFocus() > 1 && list.contains("FOCUS")) {
                    stack.shrink(1);
                    savepoint.setFocus(Math.max(savepoint.getFocus() - 4, 1));
                    player.displayClientMessage((Component)Component.translatable((String)"savepoint.upgrade", (Object[])new Object[]{Utils.translateToLocal("savepoint.focus", new Object[0]), Utils.getSavepointPercent(savepoint.getFocus())}), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"savepoint.maxed", (Object[])new Object[]{Utils.translateToLocal("savepoint.focus", new Object[0])}), true);
                }
            } else if (stack.getItem() == ModItems.evanescent_crystal.get()) {
                if (savepoint.getDrive() > 1 && list.contains("DRIVE")) {
                    stack.shrink(1);
                    savepoint.setDrive(Math.max(savepoint.getDrive() - 4, 1));
                    player.displayClientMessage((Component)Component.translatable((String)"savepoint.upgrade", (Object[])new Object[]{Utils.translateToLocal("savepoint.drive", new Object[0]), Utils.getSavepointPercent(savepoint.getDrive())}), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"savepoint.maxed", (Object[])new Object[]{Utils.translateToLocal("savepoint.drive", new Object[0])}), true);
                }
            } else if (stack.getItem() == ModItems.orichalcumplus.get()) {
                if (state.getValue(TIER) != SavePointStorage.SavePointType.WARP) {
                    stack.shrink(1);
                    BlockState newState = (BlockState)state.setValue(TIER, (Comparable)((Object)(state.getValue(TIER) == SavePointStorage.SavePointType.NORMAL ? SavePointStorage.SavePointType.LINKED : SavePointStorage.SavePointType.WARP)));
                    worldIn.setBlockAndUpdate(pos, newState);
                    player.displayClientMessage((Component)Component.translatable((String)"savepoint.upgrade_type", (Object[])new Object[]{((SavePointStorage.SavePointType)((Object)newState.getValue(TIER))).getSerializedName()}), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"savepoint.max_upgrade"), true);
                }
            }
        }
        return ItemInteractionResult.CONSUME;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity instanceof Player) {
            BlockEntity blockEntity;
            PlayerData playerData;
            Player player = (Player)entity;
            if (!world.isClientSide() && (playerData = PlayerData.get(player)) != null && (blockEntity = world.getBlockEntity(pos)) instanceof SavepointTileEntity) {
                String list;
                SavepointTileEntity savepoint = (SavepointTileEntity)blockEntity;
                switch ((SavePointStorage.SavePointType)((Object)state.getValue(TIER))) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORMAL: {
                        String string = ModConfigs.savePointRecovers;
                        break;
                    }
                    case LINKED: {
                        String string = ModConfigs.linkedSavePointRecovers;
                        break;
                    }
                    case WARP: {
                        String string = list = ModConfigs.warpPointRecovers;
                    }
                }
                if (savepoint.getHeal() == 0 || savepoint.getHunger() == 0 || savepoint.getFocus() == 0 || savepoint.getMagic() == 0 || savepoint.getDrive() == 0) {
                    player.displayClientMessage((Component)Component.translatable((String)"ERROR, this is probably an old savepoint, break and place it again to correct it"), true);
                } else {
                    if (list.contains("HP") && entity.tickCount % savepoint.getHeal() == 0 && player.getHealth() < player.getMaxHealth()) {
                        player.heal(1.0f);
                        this.showParticles(player, world, pos);
                    }
                    if (list.contains("HUNGER") && entity.tickCount % savepoint.getHunger() == 0 && player.getFoodData().getFoodLevel() < 20) {
                        player.getFoodData().eat(1, 1.0f);
                        this.showParticles(player, world, pos);
                    }
                    if (list.contains("MP") && entity.tickCount % savepoint.getMagic() == 0 && playerData.getMP() < playerData.getMaxMP()) {
                        playerData.addMP(1.0);
                        PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
                        this.showParticles(player, world, pos);
                    }
                    if (list.contains("FOCUS") && entity.tickCount % savepoint.getFocus() == 0 && playerData.getFocus() < playerData.getMaxFocus()) {
                        playerData.addFocus(1.0);
                        PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
                        this.showParticles(player, world, pos);
                    }
                    if (list.contains("DRIVE") && entity.tickCount % savepoint.getDrive() == 0 && playerData.getDP() < playerData.getMaxDP()) {
                        playerData.addDP(5.0);
                        PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
                        this.showParticles(player, world, pos);
                    }
                }
            }
        }
        super.entityInside(state, world, pos, entity);
    }

    public void showParticles(Player player, Level world, BlockPos pos) {
        if (player.tickCount % 5 == 0) {
            player.playSound((SoundEvent)ModSounds.savepoint.get(), 1.0f, 1.0f);
        }
        world.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.2, (double)pos.getY() + 2.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        world.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 2.5, (double)pos.getZ() + 0.2, 0.0, 0.0, 0.0);
        world.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.8, (double)pos.getY() + 2.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        world.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 2.5, (double)pos.getZ() + 0.8, 0.0, 0.0, 0.0);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModEntities.TYPE_SAVEPOINT.get() ? SavepointTileEntity::tick : null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return ModEntities.TYPE_SAVEPOINT.get().create(pPos, pState);
    }
}

