/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import online.kingdomkeys.kingdomkeys.block.BaseBlock;
import online.kingdomkeys.kingdomkeys.block.INoDataGen;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.block.MosaicStainedGlassBlock;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.block.SoAPlatformTileEntity;
import online.kingdomkeys.kingdomkeys.item.ModItems;

public class SoAPlatformCoreBlock
extends BaseBlock
implements EntityBlock,
INoDataGen {
    public static final BooleanProperty STRUCTURE = BooleanProperty.create((String)"structure");
    int width = 17;
    int height = 24;
    int depth = 17;
    String structureTop = "0000011111110000000011111111111000001111111111111000111111111111111001111111111111110111111111111111111111111111111111111111111111111111111111112111111111111111111111111111111111111111111111111111111111110111111111111111001111111111111110001111111111111000001111111111100000000111111100000";
    String structureMiddle = "0000011111110000000011000000011000001000000000001000100000000000001001000000000000010100000000000000011000000000000000110000000000000001100000000000000011000000000000000110000000000000001100000000000000010100000000000001001000000000000010001000000000001000001100000001100000000111111100000";
    String structureBottom = "0000011111110000000011111111111000001111111111111000111111111111111001111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111001111111111111110001111111111111000001111111111100000000111111100000";

    public boolean checkStructure(BlockPos.MutableBlockPos corePos, Level world, SoAPlatformTileEntity tileEntity) {
        corePos.set(corePos.getX() - this.width / 2, corePos.getY(), corePos.getZ() - this.depth / 2);
        BlockPos startPos = corePos.immutable();
        BlockState structureBlock = ModBlocks.mosaic_stained_glass.get().defaultBlockState();
        BlockState coreBlock = this.defaultBlockState();
        for (int y = 0; y < this.height; ++y) {
            corePos.set(corePos.getX(), startPos.getY() - y, corePos.getZ());
            for (int z = 0; z < this.depth; ++z) {
                corePos.set(corePos.getX(), corePos.getY(), startPos.getZ() + z);
                block15: for (int x = 0; x < this.width; ++x) {
                    corePos.set(startPos.getX() + x, corePos.getY(), corePos.getZ());
                    if (corePos.getY() == startPos.getY()) {
                        switch (this.structureTop.charAt(x + z * this.width)) {
                            case '0': {
                                break;
                            }
                            case '1': {
                                if (world.getBlockState((BlockPos)corePos).getBlock() != structureBlock.getBlock()) {
                                    tileEntity.clearPositions();
                                    return false;
                                }
                                tileEntity.addPos(corePos.immutable());
                                break;
                            }
                            case '2': {
                                if (world.getBlockState((BlockPos)corePos).getBlock() != coreBlock.getBlock()) {
                                    tileEntity.clearPositions();
                                    return false;
                                } else {
                                    break;
                                }
                            }
                        }
                        continue;
                    }
                    if (startPos.getY() - corePos.getY() == this.height - 1) {
                        switch (this.structureBottom.charAt(x + z * this.width)) {
                            case '0': {
                                break;
                            }
                            case '1': {
                                if (world.getBlockState((BlockPos)corePos).getBlock() != structureBlock.getBlock()) {
                                    tileEntity.clearPositions();
                                    return false;
                                }
                                tileEntity.addPos(corePos.immutable());
                            }
                        }
                        continue;
                    }
                    switch (this.structureMiddle.charAt(x + z * this.width)) {
                        case '0': {
                            continue block15;
                        }
                        case '1': {
                            if (world.getBlockState((BlockPos)corePos).getBlock() != structureBlock.getBlock()) {
                                tileEntity.clearPositions();
                                return false;
                            }
                            tileEntity.addPos(corePos.immutable());
                        }
                    }
                }
            }
        }
        return true;
    }

    public SoAPlatformCoreBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)STRUCTURE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{STRUCTURE});
    }

    public RenderShape getRenderShape(BlockState state) {
        return (Boolean)state.getValue((Property)STRUCTURE) != false ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return ModEntities.TYPE_SOA_PLATFORM.get().create(pPos, pState);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity te = worldIn.getBlockEntity(pos);
        if (te instanceof SoAPlatformTileEntity && !((SoAPlatformTileEntity)te).isMultiblockFormed() && player.getItemInHand(handIn).getItem() == ModItems.woodenStick.get()) {
            this.tryToFormPlatform((SoAPlatformTileEntity)te, worldIn, pos);
        }
        return super.useItemOn(stack, state, worldIn, pos, player, handIn, hit);
    }

    public void setBlockStates(Level world, List<BlockPos> positions, boolean form) {
        BlockState stateToSet = (BlockState)ModBlocks.mosaic_stained_glass.get().defaultBlockState().setValue((Property)MosaicStainedGlassBlock.STRUCTURE, (Comparable)Boolean.valueOf(form));
        positions.forEach(pos -> world.setBlockAndUpdate(pos, stateToSet));
    }

    public void tryToFormPlatform(SoAPlatformTileEntity tileEntity, Level world, BlockPos pos) {
        boolean shapeCorrect = this.checkStructure(new BlockPos.MutableBlockPos(pos.getX(), pos.getY(), pos.getZ()), world, tileEntity);
        if (shapeCorrect) {
            this.setBlockStates(world, tileEntity.structureBlockPosCache, true);
            tileEntity.setMultiblockFormed(true);
            BlockState state = world.getBlockState(pos);
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)STRUCTURE, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        SoAPlatformTileEntity soAPlatformTileEntity;
        BlockEntity te = worldIn.getBlockEntity(pos);
        if (newState.getBlock() != ModBlocks.station_of_awakening_core.get() && te != null && te instanceof SoAPlatformTileEntity && (soAPlatformTileEntity = (SoAPlatformTileEntity)te).isMultiblockFormed()) {
            this.setBlockStates(worldIn, soAPlatformTileEntity.structureBlockPosCache, false);
            soAPlatformTileEntity.setMultiblockFormed(false);
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)STRUCTURE, (Comparable)Boolean.valueOf(false)));
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }
}

