/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client;

import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.client.ScreenshotManager;
import online.kingdomkeys.kingdomkeys.client.gui.ConfirmChoiceMenuPopup;
import online.kingdomkeys.kingdomkeys.client.gui.IPlayerDataRequester;
import online.kingdomkeys.kingdomkeys.client.gui.OrgPortalGui;
import online.kingdomkeys.kingdomkeys.client.gui.SavePointScreen;
import online.kingdomkeys.kingdomkeys.client.gui.castle_oblivion.CardSelectionScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.MenuScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.NoChoiceMenuPopup;
import online.kingdomkeys.kingdomkeys.client.gui.menu.customize.MenuCustomizeMagicScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.customize.MenuCustomizeShortcutsScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.equipment.MenuEquipmentScreen;
import online.kingdomkeys.kingdomkeys.client.gui.organization.AlignmentSelectionScreen;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.COMinimap;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.SoAMessages;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisMaterialScreen;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.CastleOblivionData;
import online.kingdomkeys.kingdomkeys.data.GlobalData;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.DriveFormData;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.entity.block.CardDoorTileEntity;
import online.kingdomkeys.kingdomkeys.entity.block.SavepointTileEntity;
import online.kingdomkeys.kingdomkeys.entity.organization.OrgPortalEntity;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.item.organization.OrganizationData;
import online.kingdomkeys.kingdomkeys.limit.Limit;
import online.kingdomkeys.kingdomkeys.limit.LimitData;
import online.kingdomkeys.kingdomkeys.limit.ModLimits;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.MagicData;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.stc.SCDeleteSavePointScreenshot;
import online.kingdomkeys.kingdomkeys.network.stc.SCOpenCODoorGui;
import online.kingdomkeys.kingdomkeys.network.stc.SCOpenChoiceScreen;
import online.kingdomkeys.kingdomkeys.network.stc.SCOpenMaterialsScreen;
import online.kingdomkeys.kingdomkeys.network.stc.SCOpenMenu;
import online.kingdomkeys.kingdomkeys.network.stc.SCOpenSavePointScreen;
import online.kingdomkeys.kingdomkeys.network.stc.SCSendPlayerDataToClient;
import online.kingdomkeys.kingdomkeys.network.stc.SCShowMessagesPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCShowOrgPortalGUI;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCastleOblivionInteriorData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncDimensionLists;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncDriveFormData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncGlobalData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncKeybladeData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncLimitData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncMagicData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncMoogleNames;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncOrgPortalPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncOrganizationData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncShopData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncSynthesisData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncWorldData;
import online.kingdomkeys.kingdomkeys.network.stc.SCUpdateCORooms;
import online.kingdomkeys.kingdomkeys.network.stc.SCUpdateSavePoints;
import online.kingdomkeys.kingdomkeys.sound.AeroSoundInstance;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeData;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopList;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopListRegistry;
import online.kingdomkeys.kingdomkeys.synthesis.shop.names.NamesListRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.apache.commons.io.IOUtils;

public class ClientPacketHandler {
    public static void openMagicCustomize(LinkedHashMap<String, int[]> knownMagic) {
        Minecraft.getInstance().setScreen((Screen)new MenuCustomizeMagicScreen(knownMagic));
    }

    public static void openShortcutsCustomize(LinkedHashMap<String, int[]> knownMagic) {
        Minecraft.getInstance().setScreen((Screen)new MenuCustomizeShortcutsScreen(knownMagic));
    }

    public static void openAlignment() {
        Minecraft.getInstance().setScreen((Screen)new AlignmentSelectionScreen());
    }

    public static void openChoice(SCOpenChoiceScreen message) {
        Minecraft.getInstance().setScreen((Screen)new ConfirmChoiceMenuPopup(message.state(), message.choice(), message.pos()));
        SoAMessages.INSTANCE.clearMessage();
    }

    public static void syncOrgPortal(SCSyncOrgPortalPacket msg) {
        LocalPlayer player = Minecraft.getInstance().player;
        OrgPortalEntity portal = new OrgPortalEntity(player.level(), msg.pos(), msg.destPos(), msg.dimension(), msg.pos() != msg.destPos());
        player.level().addFreshEntity((Entity)portal);
    }

    public static void showOrgPortalGUI(SCShowOrgPortalGUI message) {
        Minecraft.getInstance().setScreen((Screen)new OrgPortalGui(message.pos()));
    }

    public static void openSynthesisGui(CompoundTag playerData, String inv, String name, int moogle) {
        PlayerData data = PlayerData.get((Player)Minecraft.getInstance().player);
        data.deserializeNBT((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), playerData);
        if (inv != null && !inv.equals("")) {
            Minecraft.getInstance().setScreen((Screen)new SynthesisScreen(data, inv, name, moogle));
        } else {
            Minecraft.getInstance().setScreen((Screen)new SynthesisScreen(data, name));
        }
        Minecraft.getInstance().level.playSound((Player)Minecraft.getInstance().player, Minecraft.getInstance().player.blockPosition(), (SoundEvent)ModSounds.kupo.get(), SoundSource.MASTER, 1.0f, 1.0f);
    }

    public static void recalcEyeHeight() {
        LocalPlayer player = Minecraft.getInstance().player;
        player.refreshDimensions();
        if (player.getForcedPose() != null && !PlayerData.get((Player)player).getIsGliding()) {
            player.setForcedPose(null);
        }
    }

    public static void aeroSoundInstance(int entID) {
        LocalPlayer player = Minecraft.getInstance().player;
        Entity ent = player.level().getEntity(entID);
        if (ent != null && ent instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)ent;
            Minecraft.getInstance().getSoundManager().queueTickingSound((TickableSoundInstance)new AeroSoundInstance(entity));
        }
    }

    public static void syncCapability(SCSyncPlayerData message) {
        PlayerData.get(message.data(), (Player)Minecraft.getInstance().level.getEntity(message.player()));
    }

    public static void syncDriveFormData(SCSyncDriveFormData message) {
        for (int i = 0; i < message.names().size(); ++i) {
            DriveFormData result;
            DriveForm driveform = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)message.names().get(i)));
            String d = message.data().get(i);
            BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(d.getBytes())));
            try {
                result = (DriveFormData)SCSyncDriveFormData.GSON_BUILDER.fromJson((Reader)br, DriveFormData.class);
            }
            catch (JsonParseException e) {
                KingdomKeys.LOGGER.error("Error parsing json file {}: {}", (Object)message.names().get(i), (Object)e);
                continue;
            }
            driveform.setDriveFormData(result);
            IOUtils.closeQuietly((Reader)br);
        }
    }

    public static void syncSynthesisData(SCSyncSynthesisData message) {
        LocalPlayer player = Minecraft.getInstance().player;
        RecipeRegistry.getInstance().clearRegistry();
        message.recipes().forEach(recipe -> RecipeRegistry.getInstance().register((Recipe)recipe));
    }

    public static void syncShopData(SCSyncShopData message) {
        LocalPlayer player = Minecraft.getInstance().player;
        ShopListRegistry.getInstance().clearRegistry();
        message.list().forEach(shopItem -> ShopListRegistry.getInstance().register((ShopList)shopItem));
    }

    public static void syncKeybladeData(SCSyncKeybladeData message) {
        LocalPlayer player = Minecraft.getInstance().player;
        for (int i = 0; i < message.names().size(); ++i) {
            KeybladeData result;
            KeybladeItem keyblade = (KeybladeItem)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)message.names().get(i)));
            String d = message.data().get(i);
            BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(d.getBytes())));
            try {
                result = (KeybladeData)SCSyncKeybladeData.GSON_BUILDER.fromJson((Reader)br, KeybladeData.class);
            }
            catch (JsonParseException e) {
                KingdomKeys.LOGGER.error("Error parsing json file {}: {}", (Object)message.names().get(i), (Object)e);
                continue;
            }
            keyblade.setKeybladeData(result);
            if (result.keychain != null) {
                result.keychain.setKeyblade(keyblade);
            }
            IOUtils.closeQuietly((Reader)br);
        }
    }

    public static void syncMagicData(SCSyncMagicData message) {
        LocalPlayer player = Minecraft.getInstance().player;
        for (int i = 0; i < message.names().size(); ++i) {
            MagicData result;
            Magic magic = (Magic)ModMagic.registry.get(ResourceLocation.parse((String)message.names().get(i)));
            String d = message.data().get(i);
            BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(d.getBytes())));
            try {
                result = (MagicData)SCSyncMagicData.GSON_BUILDER.fromJson((Reader)br, MagicData.class);
            }
            catch (JsonParseException e) {
                KingdomKeys.LOGGER.error("Error parsing magic json file {}: {}", (Object)message.names().get(i), (Object)e);
                continue;
            }
            magic.setMagicData(result);
            IOUtils.closeQuietly((Reader)br);
        }
    }

    public static void syncLimitData(SCSyncLimitData message) {
        LocalPlayer player = Minecraft.getInstance().player;
        for (int i = 0; i < message.names().size(); ++i) {
            LimitData result;
            Limit limit = (Limit)ModLimits.registry.get(ResourceLocation.parse((String)message.names().get(i)));
            String d = message.data().get(i);
            BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(d.getBytes())));
            try {
                result = (LimitData)SCSyncLimitData.GSON_BUILDER.fromJson((Reader)br, LimitData.class);
            }
            catch (JsonParseException e) {
                KingdomKeys.LOGGER.error("Error parsing limit json file {}: {}", (Object)message.names().get(i), (Object)e);
                continue;
            }
            limit.setLimitData(result);
            IOUtils.closeQuietly((Reader)br);
        }
    }

    public static void syncOrgData(SCSyncOrganizationData message) {
        LocalPlayer player = Minecraft.getInstance().player;
        for (int i = 0; i < message.names().size(); ++i) {
            OrganizationData result;
            IOrgWeapon weapon = (IOrgWeapon)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)message.names().get(i)));
            String d = message.data().get(i);
            BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(d.getBytes())));
            try {
                result = (OrganizationData)SCSyncOrganizationData.GSON_BUILDER.fromJson((Reader)br, OrganizationData.class);
            }
            catch (JsonParseException e) {
                KingdomKeys.LOGGER.error("Error parsing json file {}: {}", (Object)message.names().get(i), (Object)e);
                continue;
            }
            weapon.setOrganizationData(result);
            IOUtils.closeQuietly((Reader)br);
        }
    }

    public static void openCODoorGui(SCOpenCODoorGui message) {
        Minecraft.getInstance().setScreen((Screen)new CardSelectionScreen((CardDoorTileEntity)Minecraft.getInstance().level.getBlockEntity(message.pos())));
    }

    public static void syncCastleOblivionInterior(SCSyncCastleOblivionInteriorData message) {
        ClientLevel world = Minecraft.getInstance().level;
        CastleOblivionData.InteriorData.setClientCache(world, CastleOblivionData.InteriorData.load(message.data(), (HolderLookup.Provider)world.registryAccess()));
    }

    public static void syncWorldData(SCSyncWorldData message) {
        ClientLevel world = Minecraft.getInstance().level;
        WorldData.setClientCache(WorldData.load(message.data(), (HolderLookup.Provider)world.registryAccess()));
    }

    public static void syncMoogleNames(SCSyncMoogleNames message) {
        NamesListRegistry.getInstance().clearRegistry();
        NamesListRegistry.getInstance().setRegistry(message.names());
    }

    public static void openSavePointScreen(SCOpenSavePointScreen message) {
        Minecraft.getInstance().setScreen((Screen)new SavePointScreen((SavepointTileEntity)Minecraft.getInstance().level.getBlockEntity(message.tileEntity()), message.savePoints(), message.create()));
    }

    public static void updateSavePoints(SCUpdateSavePoints message) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof SavePointScreen) {
            SavePointScreen savePointScreen = (SavePointScreen)screen;
            savePointScreen.updateSavePointsFromServer(message.savePoints());
        }
    }

    public static void deleteScreenshot(SCDeleteSavePointScreenshot message) {
        File screenshotFile = ScreenshotManager.getScreenshotFile(message.name(), message.uuid());
        if (screenshotFile != null) {
            String path = screenshotFile.getPath();
            if (!screenshotFile.delete()) {
                KingdomKeys.LOGGER.warn("Failed to delete screenshot file {}", (Object)path);
            } else {
                KingdomKeys.LOGGER.info("Deleted save point screenshot: {}", (Object)screenshotFile.getName());
            }
        }
    }

    public static void updateCORooms(SCUpdateCORooms message) {
        COMinimap.rooms = message.rooms();
    }

    public static void showTitles(SCShowMessagesPacket message) {
        SoAMessages.INSTANCE.clearMessage();
        for (Utils.Title t : message.titles()) {
            SoAMessages.INSTANCE.queueMessage(t);
        }
    }

    public static void sendPlayerDataToClient(SCSendPlayerDataToClient message) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof IPlayerDataRequester) {
            IPlayerDataRequester gui = (IPlayerDataRequester)screen;
            PlayerData data = PlayerData.get(message.playerData(), (Player)Minecraft.getInstance().player);
            gui.updatePlayerData(data);
        }
    }

    public static void openMenu(SCOpenMenu message) {
        if (message.open()) {
            Minecraft.getInstance().setScreen((Screen)new MenuScreen(PlayerData.get(message.playerData(), (Player)Minecraft.getInstance().player)));
        } else {
            Minecraft.getInstance().setScreen((Screen)new NoChoiceMenuPopup());
        }
    }

    public static void openEquipmentScreen() {
        Minecraft.getInstance().setScreen((Screen)new MenuEquipmentScreen());
    }

    public static void openMaterialsScreen(SCOpenMaterialsScreen message) {
        PlayerData data = PlayerData.get(message.playerData(), (Player)Minecraft.getInstance().player);
        Minecraft.getInstance().setScreen((Screen)new SynthesisMaterialScreen(data, message.inv(), message.name(), message.moogle()));
    }

    public static void syncGlobalData(SCSyncGlobalData message) {
        if (Minecraft.getInstance().level.getEntity(message.entity()) == null) {
            return;
        }
        GlobalData globalData = GlobalData.get((LivingEntity)Minecraft.getInstance().level.getEntity(message.entity()));
        globalData.deserializeNBT((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), message.data());
        GlobalData.setClientCache((LivingEntity)Minecraft.getInstance().level.getEntity(message.entity()), globalData);
    }

    public static void syncDimensionLists(SCSyncDimensionLists message) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            Set levels = player.connection.levels();
            levels.addAll(message.addedDims());
            message.removedDims().forEach(levels::remove);
        }
    }
}

