/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.io.FileNotFoundException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.handler.ClientEvents;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.shotlock.Shotlock;
import online.kingdomkeys.kingdomkeys.util.IDisabledAnimations;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ClientUtils {
    public static boolean disableEFMAnims = false;
    public static final RenderType SHOTLOCK_INDICATOR = RenderType.create((String)"kingdomkeys:shotlock_indicator", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_TEX_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/shotlock_indicator.png"), false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.NO_DEPTH_TEST).setWriteMaskState(RenderStateShard.COLOR_WRITE).setLightmapState(RenderStateShard.NO_LIGHTMAP).setOverlayState(RenderStateShard.NO_OVERLAY).createCompositeState(true));
    public static final RenderType ULTIMATE_SHOTLOCK_INDICATOR = RenderType.create((String)"kingdomkeys:shotlock_indicator", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_TEX_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/ultimate_shotlock_indicator.png"), false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.NO_DEPTH_TEST).setWriteMaskState(RenderStateShard.COLOR_WRITE).setLightmapState(RenderStateShard.NO_LIGHTMAP).setOverlayState(RenderStateShard.NO_OVERLAY).createCompositeState(true));

    public static int drawScrollingString(GuiGraphics gui, Font font, Component text, int minX, int maxX, int y, int color, boolean centered) {
        int maxWidth = maxX - minX;
        int textWidth = font.width(text.getVisualOrderText());
        if (textWidth <= maxWidth) {
            if (centered) {
                int i = font.width((FormattedText)text);
                int i1 = Mth.clamp((int)((minX + maxX) / 2), (int)(minX + i / 2), (int)(maxX - i / 2));
                gui.drawCenteredString(font, text, i1 + 1, y, color);
                return maxWidth;
            }
            return gui.drawString(font, text, minX, y, color);
        }
        gui.drawScrollingString(font, text, minX, maxX, --y, color);
        return maxWidth;
    }

    public static boolean getResourceExists(String path) {
        try {
            Minecraft.getInstance().getResourceManager().getResourceOrThrow(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)path));
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public static ResourceLocation getResourceExistsOrDefault(String path, String name, String defaultName) {
        return ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)String.format(path, ClientUtils.getResourceExists(String.format(path, name)) ? name : defaultName));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void blitScaled(ResourceLocation texture, GuiGraphics gui, float x, float y, int u, int v, int width, int height, float scaleX, float scaleY) {
        gui.pose().pushPose();
        gui.pose().translate(x, y, 0.0f);
        gui.pose().scale(scaleX, scaleY, 1.0f);
        gui.blit(texture, 0, 0, u, v, width, height);
        gui.pose().popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void blitScaled(ResourceLocation texture, GuiGraphics gui, float x, float y, int u, int v, int width, int height, float scaleXY) {
        ClientUtils.blitScaled(texture, gui, x, y, u, v, width, height, scaleXY, scaleXY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawStringScaled(GuiGraphics gui, float x, float y, String text, int colour, float scaleX, float scaleY) {
        gui.pose().pushPose();
        gui.pose().translate(x, y, 0.0f);
        gui.pose().scale(scaleX, scaleY, 1.0f);
        gui.drawString(Minecraft.getInstance().font, text, 0, 0, colour);
        gui.pose().popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawStringScaled(GuiGraphics gui, float x, float y, String text, int colour, float scaleXY) {
        ClientUtils.drawStringScaled(gui, x, y, text, colour, scaleXY, scaleXY);
    }

    public static void drawSplitString(GuiGraphics gui, String text, int x, int y, int len, int color) {
        gui.drawWordWrap(Minecraft.getInstance().font, FormattedText.of((String)text), x, y, len, color);
    }

    public static void drawItemAsIcon(ItemStack itemStack, PoseStack poseStack, int positionX, int positionY, int size) {
        boolean flag;
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel itemBakedModel = itemRenderer.getModel(itemStack, null, null, 0);
        Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.pushPose();
        poseStack.translate((float)positionX, (float)positionY, 100.0f);
        poseStack.translate(8.0, 8.0, 0.0);
        poseStack.scale(1.0f, -1.0f, 1.0f);
        poseStack.scale((float)size, (float)size, (float)size);
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        boolean bl = flag = !itemBakedModel.usesBlockLight();
        if (flag) {
            Lighting.setupForFlatItems();
        }
        itemRenderer.render(itemStack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.NO_OVERLAY, itemBakedModel);
        multibuffersource$buffersource.endBatch();
        if (flag) {
            Lighting.setupFor3DItems();
        }
        poseStack.popPose();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderPlayerNoAnims(PoseStack posestack, int pPosX, int pPosY, int pScale, float pMouseX, float pMouseY, LivingEntity pLivingEntity) {
        float f = (float)Math.atan(pMouseX / 40.0f);
        float f1 = (float)Math.atan(pMouseY / 40.0f);
        ClientUtils.renderPlayerNoAnimsRaw(posestack, pPosX, pPosY, pScale, f, f1, pLivingEntity);
    }

    public static void renderPlayerNoAnimsRaw(PoseStack p_275396_, int p_275688_, int p_275245_, int p_275535_, float angleXComponent, float angleYComponent, LivingEntity p_275689_) {
        float f = angleXComponent;
        float f1 = angleYComponent;
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = new Quaternionf().rotateX(f1 * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf1);
        float f2 = p_275689_.yBodyRot;
        float f3 = p_275689_.getYRot();
        float f4 = p_275689_.getXRot();
        float f5 = p_275689_.yHeadRotO;
        float f6 = p_275689_.yHeadRot;
        p_275689_.yBodyRot = 180.0f + f * 20.0f;
        p_275689_.setYRot(180.0f + f * 40.0f);
        p_275689_.setXRot(-f1 * 20.0f);
        p_275689_.yHeadRot = p_275689_.getYRot();
        p_275689_.yHeadRotO = p_275689_.getYRot();
        double d0 = 1000.0;
        Matrix4fStack posestack = RenderSystem.getModelViewStack();
        posestack.pushMatrix();
        posestack.translate(0.0f, 0.0f, 1000.0f);
        RenderSystem.applyModelViewMatrix();
        p_275396_.pushPose();
        p_275396_.translate((double)p_275688_, (double)p_275245_, -950.0);
        p_275396_.mulPose(new Matrix4f().scaling((float)p_275535_, (float)p_275535_, (float)(-p_275535_)));
        p_275396_.mulPose(quaternionf);
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        if (quaternionf1 != null) {
            quaternionf1.conjugate();
            entityrenderdispatcher.overrideCameraOrientation(quaternionf1);
        }
        entityrenderdispatcher.setRenderShadow(false);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.runAsFancy(() -> {
            LivingEntityRenderer renderer = (LivingEntityRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)((AbstractClientPlayer)p_275689_));
            ((IDisabledAnimations)renderer).kingdom_Keys$setDisabled(true);
            disableEFMAnims = true;
            renderer.render((LivingEntity)((AbstractClientPlayer)p_275689_), 0.0f, 1.0f, p_275396_, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0);
            renderer = (LivingEntityRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)((AbstractClientPlayer)p_275689_));
            ((IDisabledAnimations)renderer).kingdom_Keys$setDisabled(false);
            disableEFMAnims = false;
        });
        multibuffersource$buffersource.endBatch();
        entityrenderdispatcher.setRenderShadow(true);
        p_275396_.popPose();
        Lighting.setupFor3DItems();
        posestack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        p_275689_.yBodyRot = f2;
        p_275689_.setYRot(f3);
        p_275689_.setXRot(f4);
        p_275689_.yHeadRotO = f5;
        p_275689_.yHeadRot = f6;
    }

    public static List<Component> getTooltip(List<Component> tooltip, Item.TooltipContext context, ItemStack stack) {
        if (context.level() != null) {
            float baseStr = 0.0f;
            float baseMag = 0.0f;
            float totalStr = 0.0f;
            float totalMag = 0.0f;
            String desc = "";
            MutableComponent ln1 = null;
            KeybladeItem kbItem = null;
            if (stack == null) {
                return tooltip;
            }
            Item item = stack.getItem();
            if (item instanceof KeybladeItem) {
                KeybladeItem keyblade;
                kbItem = keyblade = (KeybladeItem)item;
            } else {
                item = stack.getItem();
                if (item instanceof KeychainItem) {
                    KeychainItem keychain = (KeychainItem)item;
                    kbItem = keychain.getKeyblade();
                }
            }
            if (kbItem != null) {
                if (kbItem.getKeybladeLevel(stack) > 0) {
                    ln1 = Component.translatable((String)(String.valueOf(ChatFormatting.YELLOW) + "Level %s"), (Object[])new Object[]{kbItem.getKeybladeLevel(stack)});
                }
                baseStr = (float)kbItem.getStrength(kbItem.getKeybladeLevel(stack)) + DamageCalculation.getSharpnessDamage(stack, context.level().registryAccess());
                totalStr = DamageCalculation.getKBStrengthDamage((Player)Minecraft.getInstance().player, stack) + DamageCalculation.getSharpnessDamage(stack, context.level().registryAccess());
                baseMag = kbItem.getMagic(kbItem.getKeybladeLevel(stack));
                totalMag = DamageCalculation.getMagicDamage((Player)Minecraft.getInstance().player, stack);
                desc = kbItem.getDesc();
            } else {
                Item item2 = stack.getItem();
                if (item2 instanceof IOrgWeapon) {
                    IOrgWeapon orgItem = (IOrgWeapon)item2;
                    ln1 = Component.translatable((String)(String.valueOf(ChatFormatting.YELLOW) + String.valueOf((Object)orgItem.getMember())));
                    baseStr = (float)orgItem.getStrength() + DamageCalculation.getSharpnessDamage(stack, context.level().registryAccess());
                    totalStr = DamageCalculation.getOrgStrengthDamage((Player)Minecraft.getInstance().player, stack) + DamageCalculation.getSharpnessDamage(stack, context.level().registryAccess());
                    baseMag = orgItem.getMagic();
                    totalMag = DamageCalculation.getOrgMagicDamage((Player)Minecraft.getInstance().player, orgItem);
                    desc = orgItem.getDesc();
                }
            }
            if (ln1 != null) {
                tooltip.add((Component)ln1);
            }
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.RED) + Utils.translateToLocal("gui.menu.status.strength", new Object[0]) + " %s"), (Object[])new Object[]{baseStr + " [" + totalStr + "]"}));
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.BLUE) + Utils.translateToLocal("gui.menu.status.magic", new Object[0]) + " %s"), (Object[])new Object[]{baseMag + " [" + totalMag + "]"}));
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.WHITE) + String.valueOf(ChatFormatting.ITALIC) + desc)));
        }
        return tooltip;
    }

    public static Matrix4f getMVMatrix(PoseStack poseStack, float posX, float posY, float posZ, float x, float y, float z, boolean lockRotation, float partialTicks) {
        poseStack.pushPose();
        poseStack.translate(-posX, -posY, -posZ);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        float screenX = posX + x;
        float screenY = posY + y;
        float screenZ = posZ + z;
        Matrix4f viewMatrix = poseStack.last().pose();
        Matrix4f finalMatrix = new Matrix4f();
        finalMatrix.translate(-screenX, screenY, -screenZ);
        poseStack.popPose();
        if (lockRotation) {
            finalMatrix.m00(viewMatrix.m00());
            finalMatrix.m01(viewMatrix.m10());
            finalMatrix.m02(viewMatrix.m20());
            finalMatrix.m10(viewMatrix.m01());
            finalMatrix.m11(viewMatrix.m11());
            finalMatrix.m12(viewMatrix.m21());
            finalMatrix.m20(viewMatrix.m02());
            finalMatrix.m21(viewMatrix.m12());
            finalMatrix.m22(viewMatrix.m22());
        }
        finalMatrix = viewMatrix.mul((Matrix4fc)finalMatrix);
        return finalMatrix;
    }

    public static Matrix4f getMVMatrix(PoseStack poseStack, LivingEntity entity, float x, float y, float z, boolean lockRotation, float partialTicks) {
        float posX = (float)Mth.lerp((double)partialTicks, (double)entity.xOld, (double)entity.getX());
        float posY = (float)Mth.lerp((double)partialTicks, (double)entity.yOld, (double)entity.getY());
        float posZ = (float)Mth.lerp((double)partialTicks, (double)entity.zOld, (double)entity.getZ());
        return ClientUtils.getMVMatrix(poseStack, posX, posY, posZ, x, y, z, lockRotation, partialTicks);
    }

    public static void drawSingleShotlockIndicator(int entityID, PoseStack matStackIn, MultiBufferSource bufferIn, float partialTicks) {
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        Shotlock shotlock = Utils.getPlayerShotlock((Player)localPlayer);
        Entity entity = localPlayer.level().getEntity(entityID);
        if (entity instanceof LivingEntity) {
            LivingEntity entityIn = (LivingEntity)entity;
            float x = (float)(localPlayer.getX() - entityIn.getX()) * 0.3f;
            float y = (float)(localPlayer.getY() - entityIn.getY()) * 0.3f;
            float z = (float)(localPlayer.getZ() - entityIn.getZ()) * 0.3f;
            Matrix4f mvMatrix = ClientUtils.getMVMatrix(matStackIn, entityIn, x, y + entityIn.getBbHeight() / 2.0f, z, true, partialTicks);
            float renderSize = 1.5f + (float)shotlock.getCooldown() * 0.2f - (float)ClientEvents.focusingAnEntityTicks * 0.2f;
            mvMatrix.rotate((Quaternionfc)Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
            ClientUtils.drawTexturedModalRect2DPlane(mvMatrix, bufferIn.getBuffer(ULTIMATE_SHOTLOCK_INDICATOR), -renderSize, -renderSize, renderSize, renderSize, 0.0f, 0.0f, 256.0f, 256.0f);
        }
    }

    public static void drawShotlockIndicator(LivingEntity entityIn, PoseStack matStackIn, MultiBufferSource bufferIn, float partialTicks) {
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        PlayerData localPlayerData = PlayerData.get((Player)localPlayer);
        Shotlock shotlock = Utils.getPlayerShotlock((Player)localPlayer);
        for (Utils.ShotlockPosition shotlockEnemy : localPlayerData.getShotlockEnemies()) {
            float ex = (float)entityIn.getX();
            float ey = (float)entityIn.getY();
            float ez = (float)entityIn.getZ();
            float renderSize = 1.5f;
            if (shotlock.getMaxLocks() > 1) {
                ex += shotlockEnemy.x();
                ey += shotlockEnemy.y();
                ez += shotlockEnemy.z();
                renderSize = 0.1f;
            }
            float x = (float)(localPlayer.getX() - (double)ex) * 0.3f;
            float y = (float)(localPlayer.getY() - (double)ey) * 0.3f;
            float z = (float)(localPlayer.getZ() - (double)ez) * 0.3f;
            Matrix4f mvMatrix = ClientUtils.getMVMatrix(matStackIn, entityIn, x, y + entityIn.getBbHeight() / 2.0f, z, true, partialTicks);
            if (shotlockEnemy.id() != entityIn.getId()) continue;
            mvMatrix.rotate((Quaternionfc)Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
            ClientUtils.drawTexturedModalRect2DPlane(mvMatrix, bufferIn.getBuffer(shotlock.getMaxLocks() == 1 ? ULTIMATE_SHOTLOCK_INDICATOR : SHOTLOCK_INDICATOR), -renderSize, -renderSize, renderSize, renderSize, 0.0f, 0.0f, 256.0f, 256.0f);
        }
    }

    public static void drawShotlockIndicator(BlockPos pos, PoseStack matStackIn, MultiBufferSource bufferIn, float partialTicks) {
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        float x = (float)(localPlayer.getX() - (double)pos.getX()) * 0.8f;
        float y = (float)(localPlayer.getY() - (double)pos.getY()) * 0.8f;
        float z = (float)(localPlayer.getZ() - (double)pos.getZ()) * 0.8f;
        Matrix4f mvMatrix = ClientUtils.getMVMatrix(matStackIn, x, y, z, 0.5f, 0.5f, 0.5f, true, partialTicks);
        mvMatrix.rotate((Quaternionfc)Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        ClientUtils.drawTexturedModalRect2DPlane(mvMatrix, bufferIn.getBuffer(SHOTLOCK_INDICATOR), -0.6f, -0.6f, 0.6f, 0.6f, 0.0f, 0.0f, 256.0f, 256.0f);
    }

    public static void drawTexturedModalRect2DPlane(Matrix4f matrix, VertexConsumer vertexBuilder, float minX, float minY, float maxX, float maxY, float minTexU, float minTexV, float maxTexU, float maxTexV) {
        ClientUtils.drawTexturedModalRect3DPlane(matrix, vertexBuilder, minX, minY, 0.0f, maxX, maxY, 0.0f, minTexU, minTexV, maxTexU, maxTexV);
    }

    public static void drawTexturedModalRect3DPlane(Matrix4f matrix, VertexConsumer vertexBuilder, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float minTexU, float minTexV, float maxTexU, float maxTexV) {
        float cor = 0.00390625f;
        vertexBuilder.addVertex(matrix, minX, minY, maxZ).setUv(minTexU * cor, maxTexV * cor);
        vertexBuilder.addVertex(matrix, maxX, minY, maxZ).setUv(maxTexU * cor, maxTexV * cor);
        vertexBuilder.addVertex(matrix, maxX, maxY, minZ).setUv(maxTexU * cor, minTexV * cor);
        vertexBuilder.addVertex(matrix, minX, maxY, minZ).setUv(minTexU * cor, minTexV * cor);
    }

    public static PlayerData readPlayerData(CompoundTag data, int player) {
        PlayerData playerData = PlayerData.get((Player)Minecraft.getInstance().level.getEntity(player));
        playerData.deserializeNBT((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), data);
        return playerData;
    }

    public static class ModelAnimation {
        public ModelPart model;
        public ModelPart modelCounterpart;
        public float defVal;
        public float minVal;
        public float maxVal;
        public float actVal;
        public Angle angle;
        public boolean increasing;

        public ModelAnimation(ModelPart model, float defVal, float minVal, float maxVal, float actVal, boolean increasing, Angle angle, @Nullable ModelPart counterpart) {
            this.model = model;
            this.defVal = defVal;
            this.minVal = minVal;
            this.maxVal = maxVal;
            this.actVal = actVal;
            this.increasing = increasing;
            this.angle = angle;
            this.modelCounterpart = counterpart;
        }

        public String toString() {
            return this.defVal + ": " + this.actVal + " " + this.increasing;
        }

        public void animate() {
            if (this.model != null) {
                if (this.increasing) {
                    this.actVal += 2.0f;
                    if (this.actVal >= this.maxVal) {
                        this.increasing = false;
                    }
                } else {
                    this.actVal -= 2.0f;
                    if (this.actVal <= this.minVal) {
                        this.increasing = true;
                    }
                }
                switch (this.angle.ordinal()) {
                    case 0: {
                        this.model.xRot = (float)Math.toRadians(this.actVal);
                        if (this.modelCounterpart == null) break;
                        this.modelCounterpart.xRot = (float)Math.toRadians(this.defVal * 2.0f - this.actVal);
                        break;
                    }
                    case 1: {
                        this.model.yRot = (float)Math.toRadians(this.actVal);
                        if (this.modelCounterpart == null) break;
                        this.modelCounterpart.yRot = (float)Math.toRadians(this.defVal * 2.0f - this.actVal);
                        break;
                    }
                    case 2: {
                        this.model.zRot = (float)Math.toRadians(this.actVal);
                        if (this.modelCounterpart == null) break;
                        this.modelCounterpart.zRot = (float)Math.toRadians(this.defVal * 2.0f - this.actVal);
                    }
                }
            }
        }

        public void setDefault() {
            if (this.model != null) {
                switch (this.angle.ordinal()) {
                    case 0: {
                        this.model.xRot = (float)Math.toRadians(this.defVal);
                        if (this.modelCounterpart == null) break;
                        this.modelCounterpart.xRot = (float)Math.toRadians(this.defVal);
                        break;
                    }
                    case 1: {
                        this.model.yRot = (float)Math.toRadians(this.defVal);
                        if (this.modelCounterpart == null) break;
                        this.modelCounterpart.yRot = (float)Math.toRadians(this.defVal);
                        break;
                    }
                    case 2: {
                        this.model.zRot = (float)Math.toRadians(this.defVal);
                        if (this.modelCounterpart == null) break;
                        this.modelCounterpart.zRot = (float)Math.toRadians(this.defVal);
                    }
                }
            }
        }
    }

    public static enum Angle {
        X,
        Y,
        Z;

    }
}

