/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuPopup;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.SoAMessages;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.entity.block.PedestalTileEntity;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSetChoice;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class ConfirmChoiceMenuPopup
extends MenuPopup {
    SoAState state;
    SoAState choice;
    List<String> warrior = Arrays.asList("soa.warrior.1", "soa.warrior.2", "soa.warrior.3");
    List<String> guardian = Arrays.asList("soa.guardian.1", "soa.guardian.2", "soa.guardian.3");
    List<String> mystic = Arrays.asList("soa.mystic.1", "soa.mystic.2", "soa.mystic.3");
    final String choiceConfirm = "soa.choice.confirm";
    final String sacrificeConfirm = "soa.sacrifice.confirm";
    BlockPos pedestal;

    public ConfirmChoiceMenuPopup(SoAState state, SoAState choice, BlockPos pedestal) {
        this.state = state;
        this.choice = choice;
        this.pedestal = pedestal;
    }

    @Override
    @Nonnull
    public String OKString() {
        return "soa.ok";
    }

    @Override
    @Nonnull
    public String CANCELString() {
        if (this.state == SoAState.CONFIRM) {
            return "soa.confirm.cancel";
        }
        return "soa.cancel";
    }

    @Override
    public void OK() {
        Minecraft mc = Minecraft.getInstance();
        PlayerData playerData = PlayerData.get((Player)mc.player);
        BlockEntity te = mc.level.getBlockEntity(this.pedestal);
        if (this.state == SoAState.CONFIRM) {
            playerData.setSoAState(SoAState.COMPLETE);
            PacketHandler.sendToServer(new CSSetChoice(this.state, true));
        } else if (this.state == SoAState.CHOICE) {
            playerData.setChoicePedestal(this.pedestal);
            playerData.setChoice(this.choice);
            playerData.setSoAState(SoAState.SACRIFICE);
            if (te != null) {
                ((PedestalTileEntity)te).hide = true;
            }
        } else if (this.state == SoAState.SACRIFICE) {
            playerData.setSacrificePedestal(this.pedestal);
            playerData.setSacrifice(this.choice);
            playerData.setSoAState(SoAState.CONFIRM);
            if (te != null) {
                ((PedestalTileEntity)te).hide = true;
            }
        }
        if (this.state != SoAState.CONFIRM) {
            PacketHandler.sendToServer(new CSSetChoice(this.state, this.choice, this.pedestal));
        }
        Minecraft.getInstance().setScreen(null);
        if (this.state == SoAState.CHOICE) {
            SoAMessages.INSTANCE.clearMessage();
            SoAMessages.INSTANCE.queueMessages(new Utils.Title(null, "soa.sacrifice.intro.1", 10, 35, 20), new Utils.Title(null, "soa.sacrifice.intro.2", 10, 70, 20));
        }
        if (this.state == SoAState.SACRIFICE) {
            Minecraft.getInstance().setScreen((Screen)new ConfirmChoiceMenuPopup(SoAState.CONFIRM, SoAState.NONE, new BlockPos(0, 0, 0)));
        }
    }

    @Override
    public void CANCEL() {
        if (this.state == SoAState.CONFIRM) {
            SoAMessages.INSTANCE.clearMessage();
            SoAMessages.INSTANCE.queueMessages(new Utils.Title(null, "soa.reset.intro.1", 10, 35, 20), new Utils.Title(null, "soa.reset.intro.2", 10, 70, 20));
            Minecraft mc = Minecraft.getInstance();
            PlayerData playerData = PlayerData.get((Player)mc.player);
            BlockEntity teChoice = mc.level.getBlockEntity(playerData.getChoicePedestal());
            BlockEntity teSacrifice = mc.level.getBlockEntity(playerData.getSacrificePedestal());
            playerData.setChoicePedestal(new BlockPos(0, 0, 0));
            playerData.setSacrificePedestal(new BlockPos(0, 0, 0));
            playerData.setChoice(SoAState.NONE);
            playerData.setSacrifice(SoAState.NONE);
            playerData.setSoAState(SoAState.CHOICE);
            if (teChoice != null) {
                ((PedestalTileEntity)teChoice).hide = false;
            }
            if (teSacrifice != null) {
                ((PedestalTileEntity)teSacrifice).hide = false;
            }
            PacketHandler.sendToServer(new CSSetChoice(this.state, false));
        }
        Minecraft.getInstance().setScreen(null);
    }

    public String getStringForChoice(SoAState state) {
        switch (state) {
            case WARRIOR: {
                return "soa.confirm.warrior";
            }
            case GUARDIAN: {
                return "soa.confirm.guardian";
            }
            case MYSTIC: {
                return "soa.confirm.mystic";
            }
        }
        return "This ain't right";
    }

    @Override
    public List<String> getTextToDisplay() {
        ArrayList<String> displayText;
        block10: {
            block9: {
                displayText = new ArrayList<String>();
                if (this.state == SoAState.CONFIRM) break block9;
                switch (this.choice) {
                    case WARRIOR: {
                        displayText.addAll(this.warrior);
                        break;
                    }
                    case GUARDIAN: {
                        displayText.addAll(this.guardian);
                        break;
                    }
                    case MYSTIC: {
                        displayText.addAll(this.mystic);
                        break;
                    }
                    default: {
                        return Collections.singletonList("This ain't right");
                    }
                }
                switch (this.state) {
                    case CHOICE: {
                        displayText.add("soa.choice.confirm");
                        break block10;
                    }
                    case SACRIFICE: {
                        displayText.add("soa.sacrifice.confirm");
                        break block10;
                    }
                    default: {
                        return Collections.singletonList("This ain't right");
                    }
                }
            }
            PlayerData playerData = PlayerData.get((Player)Minecraft.getInstance().player);
            displayText.add("soa.confirm.1");
            displayText.add(this.getStringForChoice(playerData.getChosen()));
            displayText.add("soa.confirm.3");
            displayText.add(this.getStringForChoice(playerData.getSacrificed()));
            displayText.add("soa.confirm.5");
        }
        return displayText;
    }
}

