/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.entity.block.OrgPortalTileEntity;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSetOrgPortalName;

public class OrgPortalGui
extends Screen {
    EditBox nameBox;
    BlockPos pos;

    public OrgPortalGui(BlockPos pos) {
        super((Component)Component.translatable((String)"Org Portal"));
        this.pos = pos;
        this.minecraft = Minecraft.getInstance();
    }

    protected void init() {
        OrgPortalTileEntity te;
        UUID portalUUID;
        BlockEntity blockEntity;
        int tfWidth = this.minecraft.font.width("####################");
        this.nameBox = new EditBox(this.minecraft.font, this.width / 2 - tfWidth / 2, this.height / 2 - 10, tfWidth, 16, (Component)Component.literal((String)""));
        this.addRenderableWidget((GuiEventListener)this.nameBox);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"Set name"), e -> this.action()).bounds(this.width / 2 - tfWidth / 2, this.height / 2 + 10, tfWidth, 20).build());
        if (this.minecraft.player.level().getBlockEntity(this.pos) != null && (blockEntity = this.minecraft.player.level().getBlockEntity(this.pos)) instanceof OrgPortalTileEntity && (portalUUID = (te = (OrgPortalTileEntity)blockEntity).getUUID()) != null) {
            String text = WorldData.getClient().getPortalFromUUID(portalUUID).getName();
            this.nameBox.setValue(text);
        }
        super.init();
    }

    private void action() {
        PacketHandler.sendToServer(new CSSetOrgPortalName(this.pos, this.nameBox.getValue()));
        this.onClose();
    }
}

