/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.block.SavePointBlock;
import online.kingdomkeys.kingdomkeys.client.ScreenshotManager;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.CheckboxButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.DropDownButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.EditBoxLength;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.SavePointButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.SavePointExtrasButton;
import online.kingdomkeys.kingdomkeys.entity.block.SavepointTileEntity;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSCreateSavePoint;
import online.kingdomkeys.kingdomkeys.network.cts.CSSavePointTP;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.SavePointStorage;
import org.jetbrains.annotations.NotNull;

public class SavePointScreen
extends MenuBackground {
    SavepointTileEntity tileEntity;
    public Map<UUID, Pair<SavePointStorage.SavePoint, Instant>> savePoints;
    public Map<UUID, Screenshot> savePointScreenshots = new HashMap<UUID, Screenshot>();
    boolean create;
    public UUID hovered = null;
    private final int SAVE = 0;
    private final int RENAME = 1;
    private final int RETAKE = 2;
    int sorting = 0;
    int ordering = 0;
    EditBoxLength nameField;
    MenuButton save;
    MenuScrollBar bar;
    DropDownButton sortDropDown;
    DropDownButton orderDropDown;
    CheckboxButton setGlobal;
    SavePointExtrasButton rename;
    SavePointExtrasButton retake;
    SavePointStorage.SavePointType type;
    SavePointStorage.SavePoint current;
    final int recent = 0;
    final int name = 1;
    final int dimension = 2;
    final int owner = 3;

    public SavePointScreen(SavepointTileEntity tileEntity, Map<UUID, Pair<SavePointStorage.SavePoint, Instant>> savePoints, boolean create) {
        super(create ? "gui.save.create.title" : ((SavePointStorage.SavePoint)savePoints.get(tileEntity.getID()).getFirst()).name(), Color.green);
        this.tileEntity = tileEntity;
        this.type = (SavePointStorage.SavePointType)((Object)tileEntity.getBlockState().getValue(SavePointBlock.TIER));
        this.savePoints = savePoints;
        this.create = create;
        savePoints.forEach((uuid, savePoint) -> this.savePointScreenshots.put((UUID)uuid, new Screenshot(Minecraft.getInstance().getTextureManager(), ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)("save_points/" + String.valueOf(uuid))))));
        if (!create) {
            this.current = (SavePointStorage.SavePoint)savePoints.get(tileEntity.getID()).getFirst();
            if (ScreenshotManager.getScreenshotFile(this.current.name(), this.current.id()) == null) {
                ScreenshotManager.screenshot(this.current.name(), this.current.id());
            }
            this.loadSavePointScreenshots();
        }
        this.shouldCloseOnMenu = false;
    }

    public void updateSavePointsFromServer(Map<UUID, Pair<SavePointStorage.SavePoint, Instant>> savePoints) {
        if (!savePoints.containsKey(this.tileEntity.getID())) {
            this.onClose();
        }
        if (!this.create) {
            this.current = (SavePointStorage.SavePoint)savePoints.get(this.tileEntity.getID()).getFirst();
            this.savePoints = savePoints;
            this.renderables.clear();
            this.children().clear();
            this.init();
            this.updateButtons();
            savePoints.forEach((uuid, savePoint) -> this.savePointScreenshots.put((UUID)uuid, new Screenshot(Minecraft.getInstance().getTextureManager(), ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)("save_points/" + String.valueOf(uuid))))));
            this.loadSavePointScreenshots();
        }
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        if (!ScreenshotManager.isTakingScreenshot()) {
            this.drawMenuBackground(gui, mouseX, mouseY, partialTicks);
            boolean mouseOverCurrent = false;
            for (Renderable renderable : this.renderables) {
                SavePointButton savePointButton;
                if (renderable instanceof SavePointButton && (savePointButton = (SavePointButton)renderable).getDestination().equals(this.tileEntity.getID())) {
                    mouseOverCurrent = savePointButton.isMouseOverInactive(mouseX, mouseY);
                }
                if (renderable instanceof SavePointButton || renderable == this.rename || renderable == this.retake) {
                    gui.enableScissor(0, (int)this.topBarHeight, this.width, (int)(this.topBarHeight + this.middleHeight));
                    renderable.render(gui, mouseX, mouseY, partialTicks);
                    gui.disableScissor();
                    continue;
                }
                if (renderable instanceof DropDownButton) continue;
                renderable.render(gui, mouseX, mouseY, partialTicks);
            }
            if (this.rename != null) {
                this.rename.visible = mouseOverCurrent;
            }
            if (this.retake != null) {
                this.retake.visible = mouseOverCurrent;
            }
            if (this.orderDropDown != null && this.sortDropDown != null) {
                this.orderDropDown.render(gui, mouseX, mouseY, partialTicks);
                gui.pose().translate(0.0f, 0.0f, 1.0f);
                this.sortDropDown.render(gui, mouseX, mouseY, partialTicks);
            }
        }
        if (this.create) {
            String text = Utils.translateToLocal("gui.save.create.prompt", new Object[0]);
            Font font = this.minecraft.font;
            int n = this.width / 2 - this.minecraft.font.width(text) / 2;
            int n2 = this.height / 2;
            Objects.requireNonNull(this.minecraft.font);
            gui.drawString(font, text, n, n2 - 9 / 2 - 60, Color.WHITE.getRGB());
        }
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.create && this.save.active && keyCode == 257) {
            this.action(0);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        this.savePointScreenshots.forEach((uuid, screenshot) -> screenshot.close());
        super.onClose();
    }

    private void action(int id) {
        switch (id) {
            case 0: {
                File currentName;
                if (this.nameField.getValue().isEmpty()) break;
                if (this.savePointScreenshots.containsKey(this.tileEntity.getID()) && (currentName = this.getSavePointScreenshots().get(this.tileEntity.getID())) != null) {
                    if (currentName.delete()) {
                        KingdomKeys.LOGGER.info("Deleted save point screenshot: {}", (Object)currentName.getName());
                    } else {
                        KingdomKeys.LOGGER.error("Failed to delete save point screenshot: {}", (Object)currentName.getName());
                    }
                }
                LocalPlayer player = Minecraft.getInstance().player;
                PacketHandler.sendToServer(new CSCreateSavePoint(this.tileEntity, this.nameField.getValue(), (Player)player, this.setGlobal.isChecked()));
                this.create = false;
                this.nameField.visible = false;
                this.save.visible = false;
                this.setGlobal.visible = false;
                ScreenshotManager.screenshot(this.nameField.getValue(), this.tileEntity.getID());
                this.title = Component.literal((String)this.nameField.getValue());
                break;
            }
            case 1: {
                this.create = true;
                this.sortDropDown = null;
                this.renderables.clear();
                this.children().clear();
                this.init();
                break;
            }
            case 2: {
                ScreenshotManager.screenshot(((SavePointStorage.SavePoint)this.savePoints.get(this.tileEntity.getID()).getFirst()).name(), this.tileEntity.getID());
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.create) {
            this.save.active = !this.nameField.getValue().isEmpty();
        }
    }

    public void clickSavePoint(UUID id) {
        PacketHandler.sendToServer(new CSSavePointTP(this.tileEntity.getID(), id));
        this.onClose();
    }

    public void loadSavePointScreenshots() {
        long timeStarted = System.currentTimeMillis();
        KingdomKeys.LOGGER.debug("Loading screenshots...");
        Map<UUID, File> files = this.getSavePointScreenshots();
        KingdomKeys.LOGGER.debug("Got files in {}ms", (Object)(System.currentTimeMillis() - timeStarted));
        if (!files.isEmpty()) {
            files.forEach((uuid, file) -> {
                try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                    long timeStartedReading = System.currentTimeMillis();
                    this.savePointScreenshots.get(uuid).upload(NativeImage.read((InputStream)inputStream));
                    KingdomKeys.LOGGER.debug("Read image for {} in {}ms", (Object)file.getName(), (Object)(System.currentTimeMillis() - timeStartedReading));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        KingdomKeys.LOGGER.debug("Screenshots loaded in {}ms", (Object)(System.currentTimeMillis() - timeStarted));
    }

    Map<UUID, File> getSavePointScreenshots() {
        Map<UUID, File> files;
        File[] fileArray;
        HashMap<UUID, File> fileMap = new HashMap<UUID, File>();
        Path screenshotsDir = Paths.get(Minecraft.getInstance().gameDirectory.getPath(), "kingdomkeys/save_points/");
        if (!this.savePoints.isEmpty() && Files.exists(screenshotsDir, new LinkOption[0]) && (fileArray = screenshotsDir.toFile().listFiles()) != null && fileArray.length > 0 && !(files = Arrays.stream(fileArray).collect(Collectors.toMap(file -> {
            String fileName = file.getName();
            int uuidIndex = fileName.lastIndexOf("_") + 1;
            String uuidString = fileName.substring(uuidIndex, fileName.length() - 4);
            return UUID.fromString(uuidString);
        }, file -> file, (file, file2) -> {
            File toDelete;
            String[] fileNameSplit = file.getName().split("_");
            UUID uuid = UUID.fromString(fileNameSplit[1].substring(0, fileNameSplit[1].length() - 4));
            String savePointName = ((SavePointStorage.SavePoint)this.savePoints.get(uuid).getFirst()).name();
            File file3 = toDelete = savePointName.equals(fileNameSplit[0]) ? file2 : file;
            if (toDelete.delete()) {
                KingdomKeys.LOGGER.info("Deleted old save point screenshot under previous name {}", (Object)toDelete.getName());
            }
            return !savePointName.equals(fileNameSplit[0]) ? file2 : file;
        }))).isEmpty()) {
            files.forEach((uuid, file) -> {
                if (this.savePoints.containsKey(uuid)) {
                    String nameNoInvalid = ((SavePointStorage.SavePoint)this.savePoints.get(uuid).getFirst()).name().replaceAll("[\\\\/:*?\"<>|]", "_").toLowerCase();
                    if (file.isFile() && file.getName().equals(nameNoInvalid + "_" + uuid.toString() + ".png")) {
                        fileMap.put((UUID)uuid, (File)file);
                    }
                }
            });
        }
        return fileMap;
    }

    @Override
    public void init() {
        super.init();
        if (this.create) {
            this.nameField = new EditBoxLength(Minecraft.getInstance().font, this.width / 2 - 50, this.height / 2 - 10 - 40, 100, 20, 32, (Component)Component.empty()){

                @Override
                public boolean charTyped(char pCodePoint, int pModifiers) {
                    boolean b = super.charTyped(pCodePoint, pModifiers);
                    SavePointScreen.this.updateButtons();
                    return b;
                }

                @Override
                public void deleteChars(int pNum) {
                    super.deleteChars(pNum);
                    SavePointScreen.this.updateButtons();
                }
            };
            this.addRenderableWidget(this.nameField);
            this.setGlobal = new CheckboxButton(this.width / 2 - 60, this.height / 2 - 14, "gui.save.create.global", false, "gui.save.create.global.desc", Color.WHITE.getRGB());
            this.addRenderableWidget((GuiEventListener)this.setGlobal);
            this.save = new MenuButton(this.width / 2 - 60, this.height / 2, 100, Utils.translateToLocal("gui.save.create.accept", new Object[0]), MenuButton.ButtonType.BUTTON, press -> this.action(0));
            this.addRenderableWidget((GuiEventListener)this.save);
        } else {
            this.init(0, 0);
        }
        this.updateButtons();
    }

    public Comparator<? super Map.Entry<UUID, Pair<SavePointStorage.SavePoint, Instant>>> getSortedList(int sorting) {
        return switch (sorting) {
            case 0 -> Comparator.comparing(uuidPairEntry -> (Instant)((Pair)uuidPairEntry.getValue()).getSecond()).reversed();
            case 1 -> Comparator.comparing(uuidPairEntry -> ((SavePointStorage.SavePoint)((Pair)uuidPairEntry.getValue()).getFirst()).name().toLowerCase()).thenComparing(uuidPairEntry -> ((SavePointStorage.SavePoint)((Pair)uuidPairEntry.getValue()).getFirst()).name());
            case 2 -> Comparator.comparing(uuidPairEntry -> ((SavePointStorage.SavePoint)((Pair)uuidPairEntry.getValue()).getFirst()).dimension());
            case 3 -> Comparator.comparing(uuidPairEntry -> (String)((SavePointStorage.SavePoint)((Pair)uuidPairEntry.getValue()).getFirst()).owner().getSecond());
            default -> Map.Entry.comparingByKey();
        };
    }

    public void init(int sorting, int ordering) {
        Objects.requireNonNull(this.font);
        int elementHeight = 9 * 5 + 4;
        int elementWidth = (int)((float)elementHeight * 1.7777778f);
        int maxRowWidth = (int)((float)this.width / 1.5f);
        int elementsPerRow = (int)Math.max(1.0f, (float)maxRowWidth / (float)(elementWidth + 2));
        int column = 0;
        int row = 0;
        int yPos = 0;
        Comparator<? super Map.Entry<UUID, Pair<SavePointStorage.SavePoint, Instant>>> comparator = this.getSortedList(sorting);
        comparator = ordering == 0 ? comparator : comparator.reversed();
        List sortedList = this.savePoints.entrySet().stream().filter(uuidPairEntry -> !((UUID)uuidPairEntry.getKey()).equals(this.tileEntity.getID())).sorted(comparator).map(Map.Entry::getKey).collect(Collectors.toList());
        sortedList.add(0, this.tileEntity.getID());
        for (UUID uuid : sortedList) {
            SavePointStorage.SavePoint savePoint = (SavePointStorage.SavePoint)this.savePoints.get(uuid).getFirst();
            if ((this.type != SavePointStorage.SavePointType.WARP || savePoint.type() != SavePointStorage.SavePointType.WARP) && savePoint.dimension() != this.tileEntity.getLevel().dimension()) continue;
            if (column == elementsPerRow) {
                column = 0;
                ++row;
            }
            yPos = (int)(this.topBarHeight + 2.0f + (float)((elementHeight + 2) * row));
            SavePointButton button = new SavePointButton(this, this.width / 2 - (elementWidth + 2) * elementsPerRow / 2 + (elementWidth + 2) * column, yPos, elementWidth, elementHeight, (Component)Component.literal((String)savePoint.name()), uuid);
            if (uuid.equals(this.tileEntity.getID())) {
                button.active = false;
                int bwidth = elementWidth;
                int retakeOffset = 0;
                if (((UUID)this.current.owner().getFirst()).equals(Minecraft.getInstance().player.getUUID())) {
                    retakeOffset = (bwidth /= 2) + 1;
                    this.rename = new SavePointExtrasButton(this.width / 2 - (elementWidth + 2) * elementsPerRow / 2 + (elementWidth + 2) * column, yPos, bwidth, (Component)Component.translatable((String)"gui.save.main.rename"), pButton -> this.action(1));
                    this.addRenderableWidget((GuiEventListener)this.rename);
                }
                this.retake = new SavePointExtrasButton(this.width / 2 - (elementWidth + 2) * elementsPerRow / 2 + (elementWidth + 2) * column + retakeOffset, yPos, bwidth, (Component)Component.translatable((String)"gui.save.main.retake"), pButton -> this.action(2));
                this.addRenderableWidget((GuiEventListener)this.retake);
            }
            this.addRenderableWidget((GuiEventListener)button);
            ++column;
        }
        int n = this.width / 2 - (elementWidth + 2) * elementsPerRow / 2 - 62;
        int n2 = (int)this.topBarHeight;
        Objects.requireNonNull(this.font);
        this.sortDropDown = new DropDownButton(n, n2, 60, 9, List.of(Component.translatable((String)"gui.save.sort.recent"), Component.translatable((String)"gui.save.sort.name"), Component.translatable((String)"gui.save.sort.dimension"), Component.translatable((String)"gui.save.sort.owner")), (Component)Component.translatable((String)"gui.save.main.sort"));
        this.addRenderableWidget((GuiEventListener)this.sortDropDown);
        int n3 = this.width / 2 - (elementWidth + 2) * elementsPerRow / 2 - 72;
        int n4 = (int)this.topBarHeight;
        Objects.requireNonNull(this.font);
        int n5 = n4 + 9 + 4;
        Objects.requireNonNull(this.font);
        this.orderDropDown = new DropDownButton(n3, n5, 70, 9, List.of(Component.translatable((String)"gui.save.sort.ascending"), Component.translatable((String)"gui.save.sort.descending")), (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)this.orderDropDown);
        this.sortDropDown.setSelected(sorting);
        this.orderDropDown.setSelected(ordering);
        this.sorting = sorting;
        this.ordering = ordering;
        this.bar = new MenuScrollBar(this.width / 2 - (elementWidth + 2) * elementsPerRow / 2 + (elementWidth + 2) * elementsPerRow, (int)this.topBarHeight, (int)(this.topBarHeight + this.middleHeight), (int)this.middleHeight, (int)((float)yPos - this.topBarHeight) + elementHeight + 2);
        this.addRenderableWidget((GuiEventListener)this.bar);
    }

    public void updateScroll(MenuScrollBar bar) {
        for (Renderable renderable : this.renderables) {
            if (!(renderable instanceof SavePointButton)) continue;
            SavePointButton button = (SavePointButton)renderable;
            button.offsetY = (int)bar.scrollOffset;
        }
        if (this.rename != null) {
            this.rename.offsetY = (int)bar.scrollOffset;
        }
        if (this.retake != null) {
            this.retake.offsetY = (int)bar.scrollOffset;
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.bar != null) {
            this.bar.mouseClicked(pMouseX, pMouseY, pButton);
        }
        if (this.sortDropDown != null && this.orderDropDown != null) {
            if (this.sortDropDown.isOpen() && !this.orderDropDown.isOpen()) {
                return this.sortDropDown.mouseClicked(pMouseX, pMouseY, pButton);
            }
            if (!this.sortDropDown.isOpen() && this.orderDropDown.isOpen()) {
                return this.orderDropDown.mouseClicked(pMouseX, pMouseY, pButton);
            }
        }
        if ((pMouseY > (double)(this.topBarHeight + this.middleHeight) || pMouseY < (double)this.topBarHeight) && !this.create) {
            return false;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.bar != null) {
            this.bar.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
            this.updateScroll(this.bar);
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (this.bar != null) {
            this.bar.mouseReleased(pMouseX, pMouseY, pButton);
        }
        if (this.sortDropDown != null && this.orderDropDown != null) {
            this.orderDropDown.active = !this.sortDropDown.isOpen();
            boolean bl = this.sortDropDown.active = !this.orderDropDown.isOpen();
            if (this.sortDropDown.getSelected() != this.sorting || this.orderDropDown.getSelected() != this.ordering) {
                this.renderables.clear();
                this.children().clear();
                this.init(this.sortDropDown.getSelected(), this.orderDropDown.getSelected());
            }
        }
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double deltaX, double deltaY) {
        if (this.bar != null) {
            this.bar.mouseScrolled(pMouseX, pMouseY, deltaX, deltaY);
            this.updateScroll(this.bar);
        }
        return super.mouseScrolled(pMouseX, pMouseY, deltaX, deltaY);
    }

    public static class Screenshot
    implements AutoCloseable {
        private static final ResourceLocation MISSING_LOCATION = null;
        private final TextureManager textureManager;
        private final ResourceLocation textureLocation;
        @Nullable
        private DynamicTexture texture;
        private boolean closed;

        private Screenshot(TextureManager pTextureManager, ResourceLocation pTextureLocation) {
            this.textureManager = pTextureManager;
            this.textureLocation = pTextureLocation;
        }

        public void upload(NativeImage pImage) {
            if (pImage.getWidth() % 16 == 0 && pImage.getHeight() % 9 == 0) {
                try {
                    this.checkOpen();
                    if (this.texture == null) {
                        this.texture = new DynamicTexture(pImage);
                    } else {
                        this.texture.setPixels(pImage);
                        this.texture.upload();
                    }
                    this.textureManager.register(this.textureLocation, (AbstractTexture)this.texture);
                }
                catch (Throwable throwable) {
                    pImage.close();
                    this.clear();
                    throw throwable;
                }
            } else {
                pImage.close();
                throw new IllegalArgumentException("Icon must be " + ScreenshotManager.width + "x" + ScreenshotManager.height + ", but was " + pImage.getWidth() + "x" + pImage.getHeight());
            }
        }

        public void clear() {
            this.checkOpen();
            if (this.texture != null) {
                this.textureManager.release(this.textureLocation);
                this.texture.close();
                this.texture = null;
            }
        }

        public ResourceLocation textureLocation() {
            return this.texture != null ? this.textureLocation : MISSING_LOCATION;
        }

        @Override
        public void close() {
            this.clear();
            this.closed = true;
        }

        private void checkOpen() {
            if (this.closed) {
                throw new IllegalStateException("Icon already closed");
            }
        }
    }
}

