/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.castle_oblivion;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.CardSelectButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.data.CastleOblivionData;
import online.kingdomkeys.kingdomkeys.entity.block.CardDoorTileEntity;
import online.kingdomkeys.kingdomkeys.item.card.MapCardItem;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSGenerateRoom;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.Room;

public class CardSelectionScreen
extends MenuBackground {
    public CardDoorTileEntity te;
    private final List<CardSelectButton> cards = new ArrayList<CardSelectButton>();
    private ItemStack selectedCardStack;
    private MenuButton createBtn;

    public CardSelectionScreen(CardDoorTileEntity te) {
        super("Card Selection", new Color(100, 100, 100));
        this.te = te;
        this.minecraft = Minecraft.getInstance();
    }

    @Override
    public void init() {
        int x = 0;
        int y = 0;
        this.cards.clear();
        for (int i = 0; i < this.minecraft.player.getInventory().getContainerSize(); ++i) {
            Item item;
            ItemStack stack = this.minecraft.player.getInventory().getItem(i);
            if (!stack.isEmpty() && (item = stack.getItem()) instanceof MapCardItem) {
                MapCardItem card = (MapCardItem)item;
                CardSelectButton c = new CardSelectButton((int)((float)this.width * 0.25f + (float)(x++ * 42)), (int)((float)this.height * 0.5f + (float)(y * 50)), 42, 50, stack, this, e -> {
                    this.selectedCardStack = stack;
                });
                this.cards.add(c);
            }
            if (x != 6) continue;
            x = 0;
            ++y;
        }
        this.cards.forEach(x$0 -> {
            CardSelectButton cfr_ignored_0 = (CardSelectButton)this.addWidget((GuiEventListener)x$0);
        });
        super.init();
        this.createBtn = new MenuButton((int)((double)this.width * 0.79), (int)((double)this.height * 0.6), (int)this.buttonWidth, Utils.translateToLocal("create", new Object[0]), MenuButton.ButtonType.BUTTON, e -> {
            int slot = -1;
            for (int i = 0; i < this.minecraft.player.getInventory().getContainerSize(); ++i) {
                ItemStack stack = this.minecraft.player.getInventory().getItem(i);
                if (stack != this.selectedCardStack) continue;
                slot = i;
                break;
            }
            PacketHandler.sendToServer(new CSGenerateRoom(this.selectedCardStack, slot, this.te.getBlockPos()));
            this.selectedCardStack.shrink(1);
            ClientLevel level = this.minecraft.level;
            CastleOblivionData.InteriorData cap = CastleOblivionData.InteriorData.getClient(level);
            Room currentRoom = cap.getRoomAtPos(this.te.getBlockPos());
            this.te.openDoor(true);
            this.minecraft.setScreen(null);
        });
        this.addRenderableWidget((GuiEventListener)this.createBtn);
        this.createBtn.visible = false;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.minecraft.font, "Is opened? " + this.te.isOpen(), 20, 50, 0xFF9900);
        guiGraphics.drawString(this.minecraft.font, "Cost: " + this.te.getDestinationRoom().getCardCost(), 20, 60, 0xFF9900);
        for (int i = 0; i < this.cards.size(); ++i) {
            this.cards.get(i).render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.selectedCardStack != null) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((double)this.width * 0.83, (double)this.height * 0.3, 0.0);
            guiGraphics.drawCenteredString(this.minecraft.font, Utils.translateToLocal(this.selectedCardStack.getItem().getName(this.selectedCardStack).getString(), new Object[0]), 26, -20, 0xFFFFFF);
            guiGraphics.pose().scale(5.0f, 5.0f, 1.0f);
            guiGraphics.pose().translate(-2.5, -2.5, 20.0);
            ClientUtils.drawItemAsIcon(this.selectedCardStack, guiGraphics.pose(), 0, 0, 16);
            guiGraphics.pose().popPose();
            this.createBtn.active = true;
            this.createBtn.visible = true;
        } else {
            this.createBtn.active = false;
            this.createBtn.visible = false;
        }
    }
}

