/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.container;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.CheckboxButton;
import online.kingdomkeys.kingdomkeys.menu.PedestalMenu;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSPedestalConfig;
import org.jetbrains.annotations.NotNull;

public class PedestalScreen
extends AbstractContainerScreen<PedestalMenu> {
    private static final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/pedestal.png");
    final float rotationSpeedMax = 5.0f;
    final float bobSpeedMax = 0.5f;
    final float scaleMax = 2.0f;
    final float heightMax = 3.0f;
    ExtendedSlider rotationSpeedSlider;
    ExtendedSlider bobSpeedSlider;
    ExtendedSlider scaleSlider;
    ExtendedSlider heightSlider;
    CheckboxButton pauseCheckbox;
    CheckboxButton flippedCheckbox;
    ExtendedButton reset;

    public PedestalScreen(PedestalMenu container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.imageHeight = 186;
    }

    protected void init() {
        super.init();
        this.scaleSlider = new ExtendedSlider(this.leftPos + 8, this.topPos + 30, 50, 10, (Component)Component.literal((String)""), (Component)Component.literal((String)""), 0.2, 2.0, (double)((PedestalMenu)this.menu).TE.getScale(), 0.0, 0, false);
        this.addRenderableWidget((GuiEventListener)this.scaleSlider);
        this.heightSlider = new ExtendedSlider(this.leftPos + 8, this.topPos + 42, 50, 10, (Component)Component.literal((String)""), (Component)Component.literal((String)""), 0.0, 3.0, (double)((PedestalMenu)this.menu).TE.getBaseHeight(), 0.0, 0, false);
        this.addRenderableWidget((GuiEventListener)this.heightSlider);
        this.rotationSpeedSlider = new ExtendedSlider(this.leftPos + 8, this.topPos + 54, 50, 10, (Component)Component.literal((String)""), (Component)Component.literal((String)""), -5.0, 5.0, (double)((PedestalMenu)this.menu).TE.getRotationSpeed(), 0.0, 0, false);
        this.addRenderableWidget((GuiEventListener)this.rotationSpeedSlider);
        this.bobSpeedSlider = new ExtendedSlider(this.leftPos + 8, this.topPos + 66, 50, 10, (Component)Component.literal((String)""), (Component)Component.literal((String)""), 0.0, 0.5, (double)((PedestalMenu)this.menu).TE.getBobSpeed(), 0.0, 0, false);
        this.addRenderableWidget((GuiEventListener)this.bobSpeedSlider);
        this.pauseCheckbox = new CheckboxButton(this.leftPos + 8, this.topPos + 18, "Pause", ((PedestalMenu)this.menu).TE.isPaused());
        this.addRenderableWidget((GuiEventListener)this.pauseCheckbox);
        this.flippedCheckbox = new CheckboxButton(this.leftPos + 60, this.topPos + 18, "Flip", ((PedestalMenu)this.menu).TE.isFlipped());
        this.addRenderableWidget((GuiEventListener)this.flippedCheckbox);
        this.reset = new ExtendedButton(this.leftPos + this.imageWidth - 53, this.topPos + 80, 45, 15, (Component)Component.translatable((String)"Reset"), p -> {
            ((PedestalMenu)this.menu).TE.setPause(false);
            ((PedestalMenu)this.menu).TE.setCurrentTransforms(0.0f, 1.25f);
            ((PedestalMenu)this.menu).TE.setSpeed(0.6f, 0.02f);
            ((PedestalMenu)this.menu).TE.setScale(1.0f);
            ((PedestalMenu)this.menu).TE.setBaseHeight(1.25f);
            this.rotationSpeedSlider.setValue((double)0.6f);
            this.bobSpeedSlider.setValue((double)0.02f);
            this.scaleSlider.setValue(1.0);
            this.heightSlider.setValue(1.25);
            this.pauseCheckbox.setChecked(false);
            this.flippedCheckbox.setChecked(false);
            PacketHandler.sendToServer(new CSPedestalConfig(((PedestalMenu)this.menu).TE.getBlockPos(), ((PedestalMenu)this.menu).TE.getRotationSpeed(), ((PedestalMenu)this.menu).TE.getBobSpeed(), ((PedestalMenu)this.menu).TE.getSavedRotation(), ((PedestalMenu)this.menu).TE.getSavedHeight(), ((PedestalMenu)this.menu).TE.getBaseHeight(), ((PedestalMenu)this.menu).TE.getScale(), ((PedestalMenu)this.menu).TE.isPaused(), ((PedestalMenu)this.menu).TE.isFlipped()));
        });
        this.addRenderableWidget((GuiEventListener)this.reset);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256 || p_keyPressed_1_ == Minecraft.getInstance().options.keyInventory.getKey().getValue()) {
            PacketHandler.sendToServer(new CSPedestalConfig(((PedestalMenu)this.menu).TE.getBlockPos(), ((PedestalMenu)this.menu).TE.getRotationSpeed(), ((PedestalMenu)this.menu).TE.getBobSpeed(), ((PedestalMenu)this.menu).TE.getSavedRotation(), ((PedestalMenu)this.menu).TE.getSavedHeight(), ((PedestalMenu)this.menu).TE.getBaseHeight(), ((PedestalMenu)this.menu).TE.getScale(), ((PedestalMenu)this.menu).TE.isPaused(), ((PedestalMenu)this.menu).TE.isFlipped()));
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    protected void containerTick() {
        ((PedestalMenu)this.menu).TE.setSpeed((float)this.rotationSpeedSlider.getValue(), (float)this.bobSpeedSlider.getValue());
        ((PedestalMenu)this.menu).TE.setPause(this.pauseCheckbox.isChecked());
        ((PedestalMenu)this.menu).TE.setFlipped(this.flippedCheckbox.isChecked());
        ((PedestalMenu)this.menu).TE.setScale((float)this.scaleSlider.getValue());
        ((PedestalMenu)this.menu).TE.setBaseHeight((float)this.heightSlider.getValue());
        if (this.pauseCheckbox.isChecked()) {
            ((PedestalMenu)this.menu).TE.saveTransforms(((PedestalMenu)this.menu).TE.getCurrentRotation(), ((PedestalMenu)this.menu).TE.getCurrentHeight());
        }
        super.containerTick();
    }

    public void render(@NotNull GuiGraphics gui, int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground(gui, p_render_1_, p_render_2_, p_render_3_);
        super.render(gui, p_render_1_, p_render_2_, p_render_3_);
        this.renderTooltip(gui, p_render_1_, p_render_2_);
    }

    protected void renderLabels(@NotNull GuiGraphics gui, int mouseX, int mouseY) {
        gui.drawString(this.font, this.title.getString(), 8.0f, 6.0f, 0x404040, false);
        gui.drawString(this.font, "Scale " + String.format("%.2f", this.scaleSlider.getValue()) + "x", 60.0f, 31.0f, 0x404040, false);
        gui.drawString(this.font, "Height " + String.format("%.2f", this.heightSlider.getValue()), 60.0f, 43.0f, 0x404040, false);
        gui.drawString(this.font, "Rotation Speed " + String.format("%.2f", this.rotationSpeedSlider.getValue()), 60.0f, 55.0f, 0x404040, false);
        gui.drawString(this.font, "Bob Speed " + String.format("%.2f", this.bobSpeedSlider.getValue()), 60.0f, 67.0f, 0x404040, false);
        gui.drawString(this.font, this.playerInventoryTitle.getString(), 8.0f, (float)(this.imageHeight - 96 + 2), 0x404040, false);
    }

    protected void renderBg(@NotNull GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.getInstance();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xPos = (this.width - this.imageWidth) / 2;
        int yPos = this.height / 2 - this.imageHeight / 2;
        gui.blit(texture, xPos, yPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (pMouseX >= (double)this.scaleSlider.getX() && pMouseX <= (double)(this.scaleSlider.getX() + this.width) && pMouseY >= (double)this.scaleSlider.getY() && pMouseY <= (double)(this.scaleSlider.getY() + this.scaleSlider.getHeight())) {
            this.scaleSlider.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        if (pMouseX >= (double)this.heightSlider.getX() && pMouseX <= (double)(this.heightSlider.getX() + this.width) && pMouseY >= (double)this.heightSlider.getY() && pMouseY <= (double)(this.heightSlider.getY() + this.heightSlider.getHeight())) {
            this.heightSlider.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        if (pMouseX >= (double)this.rotationSpeedSlider.getX() && pMouseX <= (double)(this.rotationSpeedSlider.getX() + this.width) && pMouseY >= (double)this.rotationSpeedSlider.getY() && pMouseY <= (double)(this.rotationSpeedSlider.getY() + this.rotationSpeedSlider.getHeight())) {
            this.rotationSpeedSlider.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        if (pMouseX >= (double)this.bobSpeedSlider.getX() && pMouseX <= (double)(this.bobSpeedSlider.getX() + this.width) && pMouseY >= (double)this.bobSpeedSlider.getY() && pMouseY <= (double)(this.bobSpeedSlider.getY() + this.bobSpeedSlider.getHeight())) {
            this.bobSpeedSlider.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }
}

