/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.container;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.HiddenButton;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.ModComponents;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.menu.SynthesisBagMenu;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSUpgradeSynthesisBagPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class SynthesisBagScreen
extends AbstractContainerScreen<SynthesisBagMenu> {
    private static final String textureBase = "textures/gui/synthesis_bag_";
    int[] texHeight = new int[]{140, 176, 212, 248};
    int bagLevel = 0;
    HiddenButton upgradeButton;

    public SynthesisBagScreen(SynthesisBagMenu container, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)container, playerInv, title);
        this.minecraft = Minecraft.getInstance();
    }

    protected void init() {
        this.bagLevel = (Integer)((SynthesisBagMenu)this.menu).bag.getOrDefault(ModComponents.SYNTH_BAG_LEVEL, (Object)0);
        this.imageHeight = this.texHeight[this.bagLevel];
        this.imageWidth = 193;
        this.upgradeButton = new HiddenButton((this.width - this.imageWidth) / 2 + this.imageWidth - 20, this.height / 2 - this.imageHeight / 2 + 17, 18, 18, e -> this.upgrade());
        this.addRenderableWidget((GuiEventListener)this.upgradeButton);
        super.init();
    }

    private void upgrade() {
        if (this.bagLevel < 3 && PlayerData.get((Player)this.minecraft.player).getMunny() >= Utils.getBagCosts(this.bagLevel)) {
            PacketHandler.sendToServer(new CSUpgradeSynthesisBagPacket());
            this.onClose();
        }
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot != null && slot.hasItem() && slot.getItem().getItem() == ModItems.synthesisBag.get()) {
            return;
        }
        super.slotClicked(slot, slotId, mouseButton, type);
    }

    public void render(@NotNull GuiGraphics gui, int x, int y, float partialTicks) {
        ItemStack stack = Utils.getItemInAnyHand((Player)this.minecraft.player, ModItems.synthesisBag.get());
        if (stack == null || stack.isEmpty() || stack.getItem() != ModItems.synthesisBag.get()) {
            this.onClose();
        }
        this.renderBackground(gui, x, y, partialTicks);
        super.render(gui, x, y, partialTicks);
        this.renderTooltip(gui, x, y);
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        boolean bl = this.upgradeButton.visible = this.bagLevel < 3;
        if (this.upgradeButton.visible && x >= this.upgradeButton.getX() && x <= this.upgradeButton.getX() + this.upgradeButton.getWidth() && y >= this.upgradeButton.getY() && y <= this.upgradeButton.getY() + this.upgradeButton.getHeight()) {
            list.add(Component.translatable((String)"gui.synthesisbag.upgrade"));
            list.add(Component.translatable((String)(String.valueOf(ChatFormatting.YELLOW) + Component.translatable((String)"gui.synthesisbag.munny").getString() + ": " + Utils.getBagCosts(this.bagLevel))));
            if (PlayerData.get((Player)this.minecraft.player).getMunny() < Utils.getBagCosts(this.bagLevel)) {
                list.add(Component.translatable((String)(String.valueOf(ChatFormatting.RED) + Component.translatable((String)"gui.synthesisbag.notenoughmunny").getString())));
            }
            gui.renderTooltip(this.font, list, Optional.empty(), x, y);
        }
    }

    protected void renderLabels(GuiGraphics gui, int mouseX, int mouseY) {
        String s = this.title.getString() + " LV." + (this.bagLevel + 1);
        gui.drawString(this.font, s, this.imageWidth / 2 - 8 - this.font.width(s) / 2, 5, 0x404040, false);
    }

    protected void renderBg(@NotNull GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xPos = (this.width - this.imageWidth) / 2;
        int yPos = this.height / 2 - this.imageHeight / 2;
        gui.blit(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)(textureBase + this.bagLevel + ".png")), xPos, yPos, 0, 0, this.imageWidth, this.imageHeight);
    }
}

