/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import online.kingdomkeys.kingdomkeys.api.event.client.CommandMenuEvent;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.CommandMenuItem;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.CommandMenuGui;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.handler.EntityEvents;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CommandMenuSubMenu {
    private final ResourceLocation id;
    private int x;
    private int z;
    private int maxY;
    private int width;
    private final int height;
    private Component title;
    private CommandMenuItem selected;
    private boolean visible;
    private boolean open;
    private boolean active;
    private final List<CommandMenuItem> children;
    private CommandMenuSubMenu parent;
    private final OnOpen onOpen;
    private final OnUpdate onUpdate;
    private Color colour;
    private Color titleColour;
    private boolean useOrgColour;
    private boolean useBossColour;
    private boolean useHostileColour;
    private boolean useFixedHeader;
    private final boolean autoResize;
    public static final Color ORG_COLOUR = new Color(204, 204, 204);
    public static final Color BOSS_COLOUR = new Color(255, 0, 0);
    public static final Color HOSTILE_COLOUR = new Color(255, 204, 0);
    public final int minWidth = 70;

    private CommandMenuSubMenu(Builder builder) {
        this.id = builder.id;
        this.x = builder.x;
        this.maxY = builder.maxY;
        this.title = builder.title;
        this.onOpen = builder.onOpen;
        this.onUpdate = builder.onUpdate;
        this.parent = builder.parent;
        this.children = new ArrayList<CommandMenuItem>();
        builder.children.forEach(itemBuilder -> this.children.add(itemBuilder.build(this)));
        this.sort();
        if (!this.children.isEmpty() && this.getFirst() != null) {
            this.selected = this.getFirst();
        }
        this.colour = builder.colour;
        this.titleColour = builder.titleColour;
        this.open = builder.open;
        this.width = builder.width;
        this.height = builder.height;
        this.active = builder.active;
        this.visible = builder.visible;
        this.useOrgColour = builder.useOrgColour;
        this.useHostileColour = builder.useHostileColour;
        this.useBossColour = builder.useBossColour;
        this.autoResize = builder.autoResize;
        this.useFixedHeader = builder.useFixedHeader;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public void onOpen() {
        if (this.active) {
            if (this.onOpen != null && !CommandMenuGui.INSTANCE.currentSubmenu.equals((Object)CommandMenuGui.INSTANCE.target) && !((CommandMenuEvent.SubmenuOpen)NeoForge.EVENT_BUS.post((Event)new CommandMenuEvent.SubmenuOpen(this.getId(), this))).isCanceled()) {
                this.onOpen.onOpen(this);
            }
            this.open = true;
            if (this.selected == null && this.getFirst() != null) {
                this.setSelected(this.getFirst());
            }
            this.sort();
        }
    }

    public void onUpdate(GuiGraphics guiGraphics) {
        this.getChildren().forEach(item -> item.onUpdate(guiGraphics));
        if (this.getVisibleChildren().isEmpty()) {
            this.setActive(false);
        }
        if (this.onUpdate != null && !((CommandMenuEvent.SubmenuUpdate)NeoForge.EVENT_BUS.post((Event)new CommandMenuEvent.SubmenuUpdate(this.getId(), this, guiGraphics))).isCanceled()) {
            this.onUpdate.onUpdate(this, guiGraphics);
        }
        if (this.autoResize) {
            this.setWidth(this.getMaxChildWidth());
        }
        if (this.getSelected() != null && !this.getSelected().isVisible() && this.getFirst() != null) {
            this.setSelected(this.getFirst());
        }
    }

    public CommandMenuSubMenu getParent() {
        return this.parent;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isUseHostileColour() {
        return this.useHostileColour;
    }

    public boolean isUseBossColour() {
        return this.useBossColour;
    }

    public boolean isUseOrgColour() {
        return this.useOrgColour;
    }

    public void setColourChanging(boolean useOrgColour, boolean useHostileColour, boolean useBossColour) {
        this.useOrgColour = useOrgColour;
        this.useHostileColour = useHostileColour;
        this.useBossColour = useBossColour;
    }

    public void close() {
        this.open = false;
    }

    public Component getTitle() {
        return this.title;
    }

    public void setTitle(Component title) {
        this.title = title;
    }

    public Color getTitleColour() {
        return this.titleColour;
    }

    public void setTitleColour(Color titleColour) {
        this.titleColour = titleColour;
    }

    public Color getColour() {
        if (this.useBossColour && EntityEvents.isBoss) {
            return this.active ? BOSS_COLOUR : BOSS_COLOUR.darker().darker();
        }
        if (this.useHostileColour && EntityEvents.isHostiles) {
            return this.active ? HOSTILE_COLOUR : HOSTILE_COLOUR.darker().darker();
        }
        if (this.useOrgColour && PlayerData.get((Player)Minecraft.getInstance().player).getAlignment() != Utils.OrgMember.NONE) {
            return this.active ? ORG_COLOUR : ORG_COLOUR.darker().darker();
        }
        return this.active ? this.colour : this.colour.darker().darker();
    }

    public void setColour(Color colour) {
        this.colour = colour;
    }

    public int getZ() {
        if (this.parent != null) {
            return this.parent.getZ() + 1;
        }
        return this.z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        int totalHeight = this.height;
        for (CommandMenuItem item : this.children) {
            if (!item.isVisible()) continue;
            totalHeight += item.getHeight();
        }
        return this.maxY - totalHeight;
    }

    public void setMaxY(int maxY) {
        this.maxY = maxY;
    }

    public void updatePosition() {
        this.x = (int)((double)this.parent.getX() + (double)(10 * ModConfigs.cmSubXOffset) / 100.0);
        this.setMaxY(this.parent.maxY);
    }

    public void setParent(CommandMenuSubMenu parent) {
        this.parent = parent;
        this.updatePosition();
    }

    public void updatePosition(int x, int maxY) {
        this.x = x;
        this.setMaxY(maxY);
    }

    public void addChild(CommandMenuItem item) {
        this.getChildren().add(item);
        if (this.getSelected() == null && item.visible) {
            this.setSelected(item);
        }
        this.sort();
    }

    public void removeChild(CommandMenuItem item) {
        this.getChildren().remove(item);
    }

    public void removeChild(int index) {
        this.getChildren().remove(index);
    }

    public CommandMenuItem getChild(int index) {
        return this.getChildren().get(index);
    }

    public CommandMenuItem getChild(ResourceLocation id) {
        for (CommandMenuItem child : this.children) {
            if (!child.getId().equals((Object)id)) continue;
            return child;
        }
        return null;
    }

    public List<CommandMenuItem> getChildren() {
        return this.children;
    }

    public List<CommandMenuItem> getVisibleChildren() {
        return this.children.stream().filter(CommandMenuItem::isVisible).toList();
    }

    public void setWidth(int width) {
        this.width = width;
        this.children.forEach(item -> {
            item.width = width;
        });
    }

    public int getMaxChildWidth() {
        int width = 70;
        for (CommandMenuItem item : this.children) {
            int messageWidth;
            if (!item.isVisible() || (messageWidth = Minecraft.getInstance().font.width(item.getMessage().getString()) + 22) <= width) continue;
            width = messageWidth;
        }
        return width;
    }

    public void sort() {
        this.getChildren().sort(Comparator.comparingDouble(item -> item.sorting));
    }

    public CommandMenuItem getFirst() {
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.getChildren().get(i).isVisible()) continue;
            return this.getChildren().get(i);
        }
        return null;
    }

    public int visibleSize() {
        int size = 0;
        for (CommandMenuItem item : this.getChildren()) {
            if (!item.isVisible()) continue;
            ++size;
        }
        return size;
    }

    public int getWidth() {
        return this.width * ModConfigs.cmXScale / 100;
    }

    public int getHeight() {
        return this.height;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public CommandMenuItem getSelected() {
        return this.selected;
    }

    public void setSelected(CommandMenuItem selected) {
        this.selected = selected;
    }

    public void next() {
        int i;
        int currentIndex = 0;
        int nextIndex = -1;
        for (i = 0; i < this.getChildren().size(); ++i) {
            if (!this.getChildren().get(i).equals(this.getSelected())) continue;
            currentIndex = i;
            break;
        }
        i = currentIndex;
        while (nextIndex == -1) {
            if (++i >= this.getChildren().size()) {
                i = 0;
            }
            if (!this.getChildren().get(i).isVisible()) continue;
            nextIndex = i;
        }
        this.setSelected(this.getChildren().get(nextIndex));
    }

    public void prev() {
        int i;
        int currentIndex = 0;
        int nextIndex = -1;
        for (i = 0; i < this.getChildren().size(); ++i) {
            if (!this.getChildren().get(i).equals(this.getSelected())) continue;
            currentIndex = i;
            break;
        }
        i = currentIndex;
        while (nextIndex == -1) {
            if (--i < 0) {
                i = this.getChildren().size() - 1;
            }
            if (!this.getChildren().get(i).isVisible()) continue;
            nextIndex = i;
        }
        this.setSelected(this.getChildren().get(nextIndex));
    }

    public ResourceLocation getTexture() {
        return ClientUtils.getResourceExistsOrDefault("textures/gui/commandmenu/%s.png", Minecraft.getInstance().level.dimension().location().getPath(), "default");
    }

    public void render(GuiGraphics guiGraphics, int screenWidth, int screenHeight, float partialTick) {
        if (this.isVisible()) {
            if (this.parent != null) {
                this.updatePosition();
            }
            RenderSystem.enableBlend();
            guiGraphics.pose().translate(0.0f, 0.0f, (float)this.getZ());
            guiGraphics.setColor((float)this.getColour().getRed() / 255.0f, (float)this.getColour().getGreen() / 255.0f, (float)this.getColour().getBlue() / 255.0f, 1.0f);
            if (this.useFixedHeader) {
                guiGraphics.blit(this.getTexture(), this.getX(), this.getY(), 0, 70, 70, 15);
            } else {
                guiGraphics.blit(this.getTexture(), this.getX(), this.getY(), 0, 0, ModConfigs.cmHeaderEndLWidth, this.getHeight());
                guiGraphics.blit(this.getTexture(), this.getX() + ModConfigs.cmHeaderEndLWidth, this.getY(), this.getWidth() - (ModConfigs.cmHeaderEndLWidth + ModConfigs.cmHeaderEndRWidth), this.getHeight(), (float)(ModConfigs.cmHeaderEndLWidth + 1), 0.0f, 1, this.getHeight(), 256, 256);
                guiGraphics.blit(this.getTexture(), this.getX() + this.getWidth() - ModConfigs.cmHeaderEndRWidth, this.getY(), ModConfigs.cmHeaderEndLWidth + 3, 0, ModConfigs.cmHeaderEndRWidth, this.getHeight());
            }
            if (ModConfigs.cmHeaderTextVisible) {
                Color textColour = this.isActive() ? this.titleColour : this.titleColour.darker().darker();
                guiGraphics.setColor((float)textColour.getRed() / 255.0f, (float)textColour.getGreen() / 255.0f, (float)textColour.getBlue() / 255.0f, 1.0f);
                guiGraphics.drawString(Minecraft.getInstance().font, this.getTitle(), this.getX() + 1 + ModConfigs.cmSelectedXOffset + ModConfigs.cmTextXOffset, this.getY() + 4, 0xFFFFFF);
            }
            this.renderChildren(guiGraphics, screenWidth, screenHeight, partialTick);
            RenderSystem.disableBlend();
        }
    }

    public int getChildY(CommandMenuItem child) {
        int totalHeight = 0;
        if (this.children.contains(child)) {
            for (CommandMenuItem item : this.getChildren()) {
                if (!item.isVisible()) continue;
                if (item.equals(child)) {
                    return child.parent.getY() + this.getHeight() + totalHeight;
                }
                totalHeight += item.getHeight();
            }
        }
        return this.getY();
    }

    protected void renderChildren(GuiGraphics guiGraphics, int screenWidth, int screenHeight, float partialTick) {
        int totalHeight = 0;
        for (CommandMenuItem child : this.getChildren()) {
            if (!child.isVisible()) continue;
            child.render(guiGraphics, this.getX(), this.getY() + this.getHeight() + totalHeight, screenWidth, screenHeight, partialTick);
            totalHeight += child.getHeight();
        }
    }

    public static class Builder {
        private final ResourceLocation id;
        private final Component title;
        private int x;
        private int maxY;
        private OnOpen onOpen;
        private OnUpdate onUpdate;
        private Color colour = Color.WHITE;
        private Color titleColour = Color.WHITE;
        private boolean open = false;
        private boolean active = false;
        private boolean visible = false;
        private int width = 70;
        private int height = 15;
        private final List<CommandMenuItem.Builder> children;
        private boolean useOrgColour;
        private boolean useBossColour;
        private boolean useHostileColour;
        private boolean autoResize;
        private boolean useFixedHeader;
        private CommandMenuSubMenu parent;

        public Builder(ResourceLocation id, Component title) {
            this.id = id;
            this.title = title;
            this.children = new ArrayList<CommandMenuItem.Builder>();
        }

        public Builder position(int x, int maxY) {
            this.x = x;
            this.maxY = maxY;
            return this;
        }

        public Builder onOpen(OnOpen onOpen) {
            this.onOpen = onOpen;
            return this;
        }

        public Builder onUpdate(OnUpdate onUpdate) {
            this.onUpdate = onUpdate;
            return this;
        }

        public Builder withChildren(CommandMenuItem.Builder ... children) {
            this.children.addAll(List.of(children));
            return this;
        }

        public Builder colour(Color colour) {
            this.colour = colour;
            return this;
        }

        public Builder titleColour(Color titleColour) {
            this.titleColour = titleColour;
            return this;
        }

        public Builder openByDefault() {
            this.open = true;
            this.visible = true;
            this.active = true;
            return this;
        }

        public Builder changesColour() {
            this.useOrgColour = true;
            this.useBossColour = true;
            this.useHostileColour = true;
            return this;
        }

        public Builder dimensions(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder autoResizes() {
            this.autoResize = true;
            return this;
        }

        public Builder fixedHeader() {
            this.useFixedHeader = true;
            return this;
        }

        public CommandMenuSubMenu build() {
            return this.buildWithParent(null);
        }

        public CommandMenuSubMenu buildWithParent(@Nullable CommandMenuSubMenu parent) {
            this.parent = parent;
            if (parent != null) {
                this.open = false;
                this.position((int)((double)parent.getX() + (double)(10 * ModConfigs.cmSubXOffset) / 100.0), parent.maxY);
            }
            CommandMenuSubMenu instance = new CommandMenuSubMenu(this);
            CommandMenuGui.commandMenuElements.put(this.id, instance);
            return instance;
        }
    }

    public static interface OnOpen {
        public void onOpen(CommandMenuSubMenu var1);
    }

    public static interface OnUpdate {
        public void onUpdate(CommandMenuSubMenu var1, GuiGraphics var2);
    }
}

