/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButtonBase;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.handler.InputHandler;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class MenuBackground
extends Screen {
    int selected;
    String tip = null;
    Color color;
    protected Component title;
    public boolean shouldCloseOnMenu;
    public boolean drawPlayerInfo;
    public MenuBar bottomLeftBar;
    public MenuBar bottomRightBar;
    public MenuBar topLeftBar;
    public MenuBar topRightBar;
    public static float tooltipPosX;
    public static float tooltipPosY;
    protected float topBarHeight = (float)this.height * 0.17f;
    protected float bottomBarHeight;
    protected float topLeftBarWidth;
    protected float topRightBarWidth;
    protected float topGap;
    protected float bottomLeftBarWidth;
    protected float bottomRightBarWidth;
    protected float bottomGap;
    protected float middleHeight;
    public boolean drawSeparately = false;
    protected float buttonPosX;
    protected int buttonPosY;
    protected float buttonWidth;
    public static final ResourceLocation menu;
    public static final ResourceLocation menubg;

    public MenuBackground(String name, Color rgb) {
        super((Component)Component.translatable((String)name));
        this.minecraft = Minecraft.getInstance();
        this.selected = -1;
        this.color = rgb;
        this.title = ((Screen)this).title;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (InputHandler.Keybinds.OPENMENU.getKeybind().isActiveAndMatches(mouseKey) && this.shouldCloseOnMenu) {
            Minecraft mc = Minecraft.getInstance();
            mc.level.playSound((Player)mc.player, mc.player.blockPosition(), (SoundEvent)ModSounds.menu_back.get(), SoundSource.MASTER, 1.0f, 1.0f);
            this.onClose();
            return true;
        }
        return false;
    }

    public Component getTitle() {
        return this.title;
    }

    public void drawMenuBackground(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.drawBars(gui, mouseX, mouseY, partialTicks);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawMunnyTime(gui);
        this.drawBiomeDim(gui);
        this.drawTip(gui);
        gui.pose().pushPose();
        gui.pose().scale(1.3f, 1.3f, 1.0f);
        gui.drawString(this.minecraft.font, Utils.translateToLocal(this.getTitle().getString(), new Object[0]), 2, 10, 0xFF9900);
        gui.pose().popPose();
    }

    protected void renderBlurredBackground(float pPartialTick) {
    }

    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(gui, mouseX, mouseY, partialTicks);
        if (!this.drawSeparately) {
            this.drawMenuBackground(gui, mouseX, mouseY, partialTicks);
        }
        for (Renderable renderable : this.renderables) {
            renderable.render(gui, mouseX, mouseY, partialTicks);
        }
    }

    private void clearButtons() {
        for (Renderable btn : this.renderables) {
            if (!(btn instanceof MenuButtonBase)) continue;
            ((MenuButtonBase)btn).setSelected(false);
        }
    }

    public void drawBars(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(gui, mouseX, mouseY, partialTicks);
        int sh = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        int sw = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        float r = (float)this.color.getRed() / 255.0f;
        float g = (float)this.color.getGreen() / 255.0f;
        float b = (float)this.color.getBlue() / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        RenderSystem.enableBlend();
        gui.blit(menubg, 0, 0, this.width, this.height, 0.0f, 0.0f, this.width, this.height, 4, 4);
        RenderSystem.disableBlend();
        this.topLeftBar.draw(gui);
        this.topRightBar.draw(gui);
        this.bottomLeftBar.draw(gui);
        this.bottomRightBar.draw(gui);
    }

    public void drawBiomeDim(GuiGraphics gui) {
        gui.pose().pushPose();
        String dimension = this.minecraft.player.level().dimension().location().getPath().toUpperCase().replaceAll("_", " ");
        ResourceLocation biomeLoc = ResourceLocation.parse((String)MenuBackground.printBiome((Holder<Biome>)this.minecraft.level.getBiome(this.minecraft.player.blockPosition())));
        Object biome = "biome." + biomeLoc.getNamespace() + "." + biomeLoc.getPath();
        biome = Language.getInstance().has((String)biome) ? Utils.translateToLocal((String)biome, new Object[0]) : biomeLoc.toString();
        String text = dimension + " | " + (String)biome;
        gui.drawString(this.minecraft.font, text, this.width - this.minecraft.font.width(text) - 5, 5, 16091955);
        gui.pose().popPose();
    }

    public void drawMunnyTime(GuiGraphics gui) {
        gui.pose().pushPose();
        gui.pose().scale(1.05f, 1.05f, 1.0f);
        PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
        int y = (int)(this.topBarHeight + this.middleHeight + 1.0f);
        gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.main.synthesis_tier", new Object[0]) + ": " + Utils.getTierFromInt(playerData.getSynthLevel()), 5, y, 0xFFFF00);
        Objects.requireNonNull(this.minecraft.font);
        gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.main.munny", new Object[0]) + ": " + playerData.getMunny(), 5, y += 9, 16148007);
        Objects.requireNonNull(this.minecraft.font);
        gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.main.hearts", new Object[0]) + ": " + playerData.getHearts(), 5, y += 9, playerData.getAlignment() == Utils.OrgMember.NONE ? 0x888888 : 0xFF3333);
        Objects.requireNonNull(this.minecraft.font);
        gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.main.time", new Object[0]) + ": " + MenuBackground.getWorldHours((Level)this.minecraft.level) + ":" + MenuBackground.getWorldMinutes((Level)this.minecraft.level), 5, y += 9, 0xFFFFFF);
        long seconds = this.minecraft.level.getDayTime() / 20L;
        long h = seconds / 3600L;
        long m = seconds % 3600L / 60L;
        long s = seconds % 3600L % 60L;
        String sec = s < 10L ? "0" + s : "" + s;
        String min = m < 10L ? "0" + m : "" + m;
        String hou = h < 10L ? "0" + h : "" + h;
        String time = hou + ":" + min + ":" + sec;
        Objects.requireNonNull(this.minecraft.font);
        gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.main.time.spent", new Object[0]) + ": " + time, 5, y += 9, 4378367);
        gui.pose().popPose();
    }

    public void drawTip(GuiGraphics gui) {
        this.tip = null;
        for (Renderable btn : this.renderables) {
            if (!(btn instanceof MenuButtonBase) || !((MenuButtonBase)btn).isHoveredOrFocused()) continue;
            this.selected = -1;
            this.clearButtons();
            if (!(btn instanceof MenuButton) || !((MenuButton)btn).visible) continue;
            this.tip = ((MenuButton)btn).getTip();
        }
        if (this.tip != null) {
            gui.pose().pushPose();
            ClientUtils.drawSplitString(gui, Utils.translateToLocal(this.tip, new Object[0]), (int)tooltipPosX, (int)tooltipPosY, (int)((float)this.width * 0.6f), 0xFF9900);
            gui.pose().popPose();
        }
    }

    public static String getWorldMinutes(Level world) {
        int time = (int)Math.abs((world.getGameTime() + 6000L) % 24000L);
        if (time % 1000 * 6 / 100 < 10) {
            return "0" + time % 1000 * 6 / 100;
        }
        return Integer.toString(time % 1000 * 6 / 100);
    }

    public static int getWorldHours(Level world) {
        int time = (int)Math.abs((world.getGameTime() + 6000L) % 24000L);
        return (int)((float)time / 1000.0f);
    }

    public void init() {
        this.topBarHeight = (float)this.height * 0.17f;
        this.bottomBarHeight = (float)this.height * 0.23f;
        this.topLeftBarWidth = (float)this.width * 0.175f;
        this.topRightBarWidth = (float)this.width * 0.82f;
        this.topGap = (float)this.width * 0.005f;
        this.bottomLeftBarWidth = (float)this.width * 0.304f;
        this.bottomRightBarWidth = (float)this.width * 0.6875f;
        this.bottomGap = (float)this.width * 0.0085f;
        this.middleHeight = (float)this.height * 0.6f;
        this.topLeftBar = new MenuBar(-10, -10, (int)this.topLeftBarWidth + 10, (int)this.topBarHeight + 10, true);
        this.topRightBar = new MenuBar((int)(this.topLeftBarWidth + this.topGap), -10, (int)this.topRightBarWidth + 10, (int)this.topBarHeight + 10, true);
        this.bottomLeftBar = new MenuBar(-10, (int)(this.topBarHeight + this.middleHeight), (int)this.bottomLeftBarWidth + 10, (int)this.bottomBarHeight + 10, false);
        this.bottomRightBar = new MenuBar((int)(this.bottomLeftBarWidth + this.bottomGap), (int)(this.topBarHeight + this.middleHeight), (int)this.bottomRightBarWidth + 10, (int)this.bottomBarHeight + 10, false);
        this.buttonPosX = (float)this.width * 0.03f;
        this.buttonPosY = (int)this.topBarHeight + 5;
        this.buttonWidth = (float)this.width * 0.1744f - 22.0f;
        tooltipPosX = this.bottomRightBar.getPosX() + 15;
        tooltipPosY = this.bottomRightBar.getPosY() + 15;
    }

    private static String printBiome(Holder<Biome> p_205375_) {
        return (String)p_205375_.unwrap().map(p_205377_ -> p_205377_.location().toString(), p_205367_ -> "[unregistered " + String.valueOf(p_205367_) + "]");
    }

    static {
        menu = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");
        menubg = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_background.png");
    }
}

