/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MenuColourBox
extends AbstractWidget {
    private final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");
    private final int u = 215;
    private final int vPos = 0;
    private final int middleWidth;
    private boolean selected;
    String key;
    String value;
    Color color;
    Minecraft minecraft;

    public MenuColourBox(int x, int y, int widthIn, String key, String value, int color) {
        super(x, y, widthIn, 14, (Component)Component.translatable((String)key));
        this.key = key;
        this.value = value;
        this.middleWidth = widthIn;
        this.color = new Color(color);
        this.minecraft = Minecraft.getInstance();
    }

    @ParametersAreNonnullByDefault
    public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            gui.pose().pushPose();
            RenderSystem.setShaderColor((float)((float)this.color.getRed() / 255.0f), (float)((float)this.color.getGreen() / 255.0f), (float)((float)this.color.getBlue() / 255.0f), (float)1.0f);
            RenderSystem.enableBlend();
            gui.blit(this.texture, this.getX(), this.getY(), this.middleWidth, this.height, 215.0f, 0.0f, 1, this.height, 256, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.drawString(this.minecraft.font, this.key, this.getX() + 4, this.getY() + 4, new Color(255, 255, 255).hashCode());
            gui.drawString(this.minecraft.font, this.value, this.getX() + this.width - this.minecraft.font.width(this.value) - 4, this.getY() + 4, new Color(255, 255, 0).hashCode());
            RenderSystem.disableBlend();
            gui.pose().popPose();
        }
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String val) {
        this.value = val;
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void playDownSound(SoundManager soundHandlerIn) {
    }

    public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }
}

