/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public abstract class MenuPopup
extends Screen {
    MenuButton ok;
    MenuButton cancel;
    int[] alpha;
    int[] timer;
    int scaledWidth;
    int scaledHeight;
    int titleDisplayTime = 35;
    int titleFadeIn = 10;
    int currentTimer = 0;

    public boolean isPauseScreen() {
        return false;
    }

    public abstract void OK();

    public abstract void CANCEL();

    public abstract List<String> getTextToDisplay();

    @Nonnull
    public String OKString() {
        return "soa.menu.ok";
    }

    @Nonnull
    public String CANCELString() {
        return "soa.menu.cancel";
    }

    private void buttonAction(Action a) {
        switch (a.ordinal()) {
            case 0: {
                this.OK();
                break;
            }
            case 1: {
                this.CANCEL();
            }
        }
    }

    public void onClose() {
        this.CANCEL();
        super.onClose();
    }

    public MenuPopup() {
        super((Component)Component.literal((String)""));
    }

    protected void init() {
        super.init();
        this.scaledWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        this.scaledHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        int buttonWidth = 50;
        int buttonX = this.scaledWidth / 2 - buttonWidth * 2;
        int n = this.scaledHeight / 2 + -10;
        int n2 = this.getTextToDisplay().size();
        Objects.requireNonNull(this.font);
        int buttonY = n + n2 * (9 * 2 + 3);
        this.ok = new MenuButton(buttonX, buttonY, buttonWidth, Utils.translateToLocal(this.OKString(), new Object[0]), MenuButton.ButtonType.BUTTON, p -> this.buttonAction(Action.OK));
        this.addRenderableWidget((GuiEventListener)this.ok);
        this.cancel = new MenuButton(buttonX + buttonWidth * 2, buttonY, buttonWidth, Utils.translateToLocal(this.CANCELString(), new Object[0]), MenuButton.ButtonType.BUTTON, p -> this.buttonAction(Action.CANCEL));
        this.addRenderableWidget((GuiEventListener)this.cancel);
        this.ok.visible = false;
        this.ok.active = false;
        this.cancel.visible = false;
        this.cancel.active = false;
        this.alpha = new int[this.getTextToDisplay().size()];
        this.timer = new int[this.getTextToDisplay().size()];
        this.timer[0] = this.titleDisplayTime + this.titleFadeIn;
        Arrays.fill(this.alpha, 0);
    }

    protected void renderTextBackground(GuiGraphics gui, int yIn, int stringWidthIn) {
        int i = Minecraft.getInstance().options.getBackgroundColor(0.0f);
        if (i != 0) {
            int j = -stringWidthIn / 2;
            gui.fill(j - 2, yIn - 2, j + stringWidthIn + 2, yIn + 9 + 2, i);
        }
    }

    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.render(gui, mouseX, mouseY, partialTicks);
        float startY = -10.0f;
        PoseStack matrixStack = gui.pose();
        matrixStack.pushPose();
        float f = this.scaledWidth / 2;
        float f2 = this.scaledHeight / 2;
        int n = this.getTextToDisplay().size() - 1;
        Objects.requireNonNull(this.font);
        matrixStack.translate(f, f2 - (startY + (float)(n * (9 + 3))) / 2.0f, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.pushPose();
        matrixStack.scale(2.0f, 2.0f, 2.0f);
        for (int i = 0; i < this.getTextToDisplay().size(); ++i) {
            float f4 = (float)this.timer[i] - partialTicks;
            if (this.timer[i] > this.titleDisplayTime) {
                float f5 = (float)(this.titleFadeIn + this.titleDisplayTime) - f4;
                this.alpha[i] = (int)(f5 * 255.0f / (float)this.titleFadeIn);
            }
            if (this.timer[i] == -1) {
                this.alpha[i] = 255;
            }
            this.alpha[i] = Mth.clamp((int)this.alpha[i], (int)0, (int)255);
            if (this.alpha[i] <= 8) continue;
            int l1 = this.alpha[i] << 24 & 0xFF000000;
            int i2 = this.font.width(Utils.translateToLocal(this.getTextToDisplay().get(i), new Object[0]));
            Objects.requireNonNull(this.font);
            this.renderTextBackground(gui, (int)(startY + (float)(i * (9 + 3))), i2);
            Font font = Minecraft.getInstance().font;
            String string = Utils.translateToLocal(this.getTextToDisplay().get(i), new Object[0]);
            float f3 = -i2 / 2;
            Objects.requireNonNull(this.font);
            gui.drawString(font, string, f3, startY + (float)(i * (9 + 3)), 0xFFFFFF | l1, true);
        }
        matrixStack.popPose();
        RenderSystem.disableBlend();
        matrixStack.popPose();
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (32 == p_keyPressed_1_) {
            this.timer[this.currentTimer] = -1;
            if (this.currentTimer + 1 == this.timer.length) {
                this.ok.visible = true;
                this.ok.active = true;
                this.cancel.visible = true;
                this.cancel.active = true;
            } else {
                this.timer[this.currentTimer + 1] = this.titleDisplayTime + this.titleFadeIn;
                ++this.currentTimer;
            }
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void tick() {
        for (int i = 0; i < this.timer.length; ++i) {
            if (this.timer[i] <= 0) continue;
            int n = i;
            this.timer[n] = this.timer[n] - 1;
            if (this.timer[i] > 0) continue;
            if (i != this.timer.length - 1) {
                this.timer[i] = -1;
                this.timer[i + 1] = this.titleDisplayTime + this.titleFadeIn;
                this.currentTimer = i + 1;
                continue;
            }
            this.ok.visible = true;
            this.ok.active = true;
            this.cancel.visible = true;
            this.cancel.active = true;
        }
        super.tick();
    }

    static enum Action {
        OK,
        CANCEL;

    }
}

