/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.castle_oblivion.CardSelectionScreen;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButtonBase;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.item.card.MapCardItem;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CardSelectButton
extends MenuButtonBase {
    private final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");
    ItemStack stack;
    MapCardItem card;
    Minecraft minecraft = Minecraft.getInstance();
    CardSelectionScreen parent;

    public CardSelectButton(int x, int y, int widthIn, int heightIn, ItemStack stack, CardSelectionScreen cardSelectionScreen, Button.OnPress onPress) {
        super(x, y, widthIn, heightIn, Utils.translateToLocal("", new Object[0]), onPress);
        this.stack = stack;
        this.card = (MapCardItem)stack.getItem();
        this.parent = cardSelectionScreen;
    }

    @ParametersAreNonnullByDefault
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.isHovered = mouseX > this.getX() + 1 && mouseY >= this.getY() + 1 && mouseX < this.getX() + this.width - 1 && mouseY < this.getY() + this.height - 1;
        boolean bl = this.active = this.card.getCardValue(this.stack) >= this.parent.te.getDestinationRoom().getCardCost() || this.card.getCardValue(this.stack) == 0;
        if (this.isHovered()) {
            this.selected = false;
        }
        PoseStack matrixStack = guiGraphics.pose();
        matrixStack.pushPose();
        if (this.visible) {
            matrixStack.translate((float)this.getX(), (float)this.getY(), 0.0f);
            if (this.isHovered && this.active) {
                matrixStack.scale(4.0f, 4.0f, 1.0f);
                matrixStack.translate(-2.0f, -2.0f, 20.0f);
            } else {
                matrixStack.scale(3.0f, 3.0f, 1.0f);
            }
            ClientUtils.drawItemAsIcon(this.stack, guiGraphics.pose(), 0, 0, 16);
            matrixStack.translate(9.0f, 10.0f, 150.0f);
            int color = this.active ? 0xFFDD00 : 0xAAAAAA;
            matrixStack.scale(0.7f, 0.7f, 1.0f);
            guiGraphics.drawString(this.minecraft.font, "" + this.card.getCardValue(this.stack), 0, 0, color);
            matrixStack.scale(0.4f, 0.4f, 1.0f);
            guiGraphics.drawString(this.minecraft.font, "x" + this.stack.getCount(), -21, 11, 0xFFFFFF);
        }
        matrixStack.popPose();
        matrixStack.pushPose();
        if (this.isHovered && this.active) {
            matrixStack.translate(30.0f, 100.0f, 0.0f);
            guiGraphics.drawCenteredString(this.minecraft.font, Utils.translateToLocal(this.stack.getItem().getName(this.stack).getString(), new Object[0]), 26, -20, 0xFFFFFF);
            matrixStack.scale(5.0f, 5.0f, 1.0f);
            matrixStack.translate(-2.5f, -2.5f, 20.0f);
            ClientUtils.drawItemAsIcon(this.stack, matrixStack, 0, 0, 16);
            matrixStack.scale(0.7f, 0.7f, 1.0f);
            matrixStack.translate(13.0f, 14.0f, 150.0f);
            guiGraphics.drawString(this.minecraft.font, "" + this.card.getCardValue(this.stack), 0, 0, 0xFFDD00);
            matrixStack.translate(-10.0, 9.5, 150.0);
            matrixStack.scale(0.3f, 0.3f, 1.0f);
            guiGraphics.drawString(this.minecraft.font, "Category: " + String.valueOf((Object)this.card.getRoomType().getCategory()), 0, 0, 0xFFFFFF);
            guiGraphics.drawString(this.minecraft.font, "Room size: " + String.valueOf((Object)this.card.getRoomType().getSize()), 0, 10, 0xFFFFFF);
            guiGraphics.drawString(this.minecraft.font, "Enemies: " + String.valueOf((Object)this.card.getRoomType().getEnemies()), 0, 20, 0xFFFFFF);
        }
        matrixStack.popPose();
    }

    private void drawButton(PoseStack matrixStack, boolean hovered) {
        boolean leftU = false;
        boolean middleU = false;
        boolean rightU = false;
        boolean vPos = false;
        boolean selVPos = false;
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.isHovered && this.active) {
            return super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }
        return false;
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void playDownSound(SoundManager soundHandlerIn) {
        soundHandlerIn.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.menu_select.get()), (float)1.0f, (float)1.0f));
    }
}

