/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class CheckboxButton
extends AbstractButton {
    final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/checkbox.png");
    private boolean checked;
    private String tooltip;
    int labelColour = 0x404040;

    public CheckboxButton(int xIn, int yIn, String msg, boolean checked) {
        super(xIn, yIn, 10, 10, (Component)Component.translatable((String)msg));
        this.checked = checked;
    }

    public CheckboxButton(int xIn, int yIn, String msg, boolean checked, String tooltip, int labelColour) {
        this(xIn, yIn, msg, checked);
        this.tooltip = tooltip;
        this.labelColour = labelColour;
    }

    public void onPress() {
        this.checked = !this.checked;
    }

    public void renderWidget(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            gui.blit(this.TEXTURE, this.getX(), this.getY(), 0, 0, 10, 10);
            if (this.checked) {
                gui.blit(this.TEXTURE, this.getX(), this.getY(), 10, 0, 10, 10);
            }
            gui.drawString(Minecraft.getInstance().font, this.getMessage().getString(), this.getX() + this.width + 3, this.getY() + 2, this.labelColour, false);
            if (mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() + 3 + Minecraft.getInstance().font.width(this.getMessage().getString()) && mouseY >= this.getY()) {
                int n = this.getY();
                Objects.requireNonNull(Minecraft.getInstance().font);
                if (mouseY <= n + 9 && this.tooltip != null) {
                    gui.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)this.tooltip), mouseX, this.getY());
                }
            }
        }
    }

    public int getWidth() {
        return super.getWidth() + 3 + Minecraft.getInstance().font.width((FormattedText)this.getMessage());
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }
}

