/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import com.mojang.math.Axis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;

public class DropDownButton
extends Button {
    int selected = 0;
    List<Entry> options = new ArrayList<Entry>();
    int offsetY;
    boolean open = false;
    int originalHeight;
    Component label;

    public void setSelected(int i) {
        this.selected = Math.min(Math.max(i, 0), this.options.size() - 1);
    }

    public int getSelected() {
        return this.selected;
    }

    public DropDownButton(int pX, int pY, int pWidth, int pHeight, List<Component> options, Component label) {
        super(DropDownButton.builder((Component)(options.isEmpty() ? Component.translatable((String)"No options") : options.get(0)), pButton -> {}).bounds(pX, pY, pWidth, pHeight));
        for (int i = 0; i < options.size(); ++i) {
            Objects.requireNonNull(Minecraft.getInstance().font);
            this.options.add(new Entry(pX, pY + (i + 1) * (9 + 3), options.get(i)));
        }
        this.originalHeight = pHeight;
        this.label = label;
    }

    public void setY(int pY) {
        super.setY(pY);
        for (int i = 0; i < this.options.size(); ++i) {
            Objects.requireNonNull(Minecraft.getInstance().font);
            this.options.get((int)i).y = pY + i * (9 + 3);
        }
    }

    public void setX(int pX) {
        super.setX(pX);
        for (int i = 0; i < this.options.size(); ++i) {
            this.options.get((int)i).x = pX;
        }
    }

    public int getY() {
        return super.getY() - this.offsetY;
    }

    protected void renderWidget(GuiGraphics gui, int pMouseX, int pMouseY, float pPartialTick) {
        Font font = Minecraft.getInstance().font;
        if (this.visible && !this.options.isEmpty()) {
            if (this.label != null) {
                gui.drawString(font, this.label, this.getX() - font.width((FormattedText)this.label) - 2, this.getY() + 1, Color.WHITE.getRGB());
            }
            gui.setColor(1.0f, 1.0f, 1.0f, 0.5f);
            gui.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), Color.BLACK.getRGB());
            gui.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            int n = this.getX();
            int n2 = this.getX() + this.getWidth() - 1;
            int n3 = this.getY();
            Objects.requireNonNull(font);
            gui.hLine(n, n2, n3 + 9, Color.WHITE.getRGB());
            gui.drawString(font, this.options.get((int)this.selected).text, this.getX() + 1, this.getY() + 1, Color.WHITE.getRGB());
            gui.pose().pushPose();
            gui.pose().translate((float)(this.getX() + this.getWidth() - 4), (float)(this.getY() + 2), 0.0f);
            gui.pose().rotateAround(Axis.ZP.rotationDegrees(90.0f), 0.0f, 0.0f, 1.0f);
            gui.drawString(font, (Component)Component.literal((String)">"), 0, 0, Color.WHITE.getRGB(), false);
            gui.pose().popPose();
            if (this.open) {
                this.options.forEach(option -> gui.drawString(font, option.text, option.x + 1, option.y + 1, Color.WHITE.getRGB()));
            }
        }
        if (this.isHovered && this.active) {
            if (pMouseX >= this.getX() && pMouseX <= this.getX() + this.getWidth() && pMouseY >= this.getY() && pMouseY <= this.getY() + this.originalHeight) {
                gui.setColor(1.0f, 1.0f, 1.0f, 0.25f);
                gui.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.originalHeight, Color.WHITE.getRGB());
                gui.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
            for (int i = 0; i < this.options.size(); ++i) {
                if (pMouseY < this.options.get((int)i).y - 1) continue;
                int n = this.options.get((int)i).y - 1;
                Objects.requireNonNull(Minecraft.getInstance().font);
                if (pMouseY > n + 9 + 2) continue;
                gui.setColor(1.0f, 1.0f, 1.0f, 0.25f);
                int n4 = this.getX();
                int n5 = this.options.get((int)i).y - 1;
                int n6 = this.getX() + this.getWidth();
                int n7 = this.options.get((int)i).y;
                Objects.requireNonNull(Minecraft.getInstance().font);
                gui.fill(n4, n5, n6, n7 + 9 + 1, Color.WHITE.getRGB());
                gui.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public void close(boolean selected) {
        this.open = false;
        if (selected) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.menu_select.get()), (float)1.0f));
        } else {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.menu_back.get()), (float)1.0f));
        }
        this.setHeight(this.originalHeight);
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0 && pMouseX >= (double)this.getX() && pMouseX <= (double)(this.getX() + this.getWidth()) && pMouseY >= (double)this.getY() && pMouseY <= (double)(this.getY() + this.getHeight())) {
            if (this.open) {
                for (int i = 0; i < this.options.size(); ++i) {
                    if (!(pMouseY >= (double)(this.options.get((int)i).y - 1))) continue;
                    int n = this.options.get((int)i).y - 1;
                    Objects.requireNonNull(Minecraft.getInstance().font);
                    if (!(pMouseY <= (double)(n + 9 + 2))) continue;
                    this.selected = i;
                }
                this.close(true);
                return false;
            }
            this.open = true;
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.menu_in.get()), (float)1.0f));
            int n = this.getHeight();
            int n2 = this.options.size();
            Objects.requireNonNull(Minecraft.getInstance().font);
            this.setHeight(n + n2 * (9 + 3));
            return true;
        }
        if (this.open) {
            this.close(false);
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    static class Entry {
        public int x;
        public int y;
        public Component text;

        public Entry(int x, int y, Component text) {
            this.x = x;
            this.y = y;
            this.text = text;
        }
    }
}

