/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButtonBase;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;

public class MenuAbilitiesButton
extends MenuButtonBase {
    private final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");
    private final int endWidth = 11;
    private final int leftU = 47;
    private final int middleU = 59;
    private final int rightU = 61;
    private final int vPos = 118;
    private final int selectedVPos = 138;
    private final int middleWidth;
    private final int apMiddleWidth;
    public Ability.AbilityType abilityType;
    private final String text;
    private boolean selected;
    private int ap;
    Minecraft minecraft;
    public boolean equipped = false;
    public int index = 0;
    public boolean isVisual = false;

    public MenuAbilitiesButton(int x, int y, int widthIn, String buttonText, Ability.AbilityType type, Button.OnPress onPress) {
        super(x, y, 22 + widthIn, 20, buttonText, onPress);
        this.text = buttonText;
        this.middleWidth = widthIn;
        this.apMiddleWidth = widthIn / 3;
        this.abilityType = type;
        this.minecraft = Minecraft.getInstance();
    }

    public MenuAbilitiesButton(int buttonPosX, int buttonPosY, int buttonWidth, String abilityName, int finalJ, Ability.AbilityType type, Button.OnPress onPress) {
        this(buttonPosX, buttonPosY, buttonWidth, abilityName, type, onPress);
        this.index = finalJ;
    }

    @ParametersAreNonnullByDefault
    public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.isHovered = mouseX > this.getX() + 1 && mouseY >= this.getY() + 1 && mouseX < this.getX() + this.width - 1 && mouseY < this.getY() + this.height - 1;
        PoseStack matrixStack = gui.pose();
        if (this.visible) {
            matrixStack.pushPose();
            this.renderColor();
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
            if (this.isHovered && this.active) {
                this.drawButton(gui, this.isHovered);
                gui.drawString(this.minecraft.font, this.getMessage().getString().substring(this.getMessage().getString().indexOf(":") + 1), this.getX() + 20, this.getY() + 6, new Color(255, 255, 255).hashCode());
                if (this.abilityType != Ability.AbilityType.WEAPON && this.abilityType != Ability.AbilityType.ACCESSORY) {
                    gui.drawString(this.minecraft.font, "AP", this.getX() + 11 + this.middleWidth + this.apMiddleWidth - 5, this.getY() + 6, new Color(255, 255, 0).hashCode());
                    gui.drawString(this.minecraft.font, "" + this.ap, this.getX() + 11 + this.middleWidth + this.apMiddleWidth + 10, this.getY() + 6, new Color(255, 255, 255).hashCode());
                }
            } else if (this.active) {
                this.drawButton(gui, this.isHovered);
                gui.drawString(this.minecraft.font, this.getMessage(), this.getX() + 20, this.getY() + 6, new Color(255, 255, 255).hashCode());
                if (this.abilityType != Ability.AbilityType.WEAPON && this.abilityType != Ability.AbilityType.ACCESSORY) {
                    gui.drawString(this.minecraft.font, "AP", this.getX() + 11 + this.middleWidth + this.apMiddleWidth - 5, this.getY() + 6, new Color(255, 255, 0).hashCode());
                    gui.drawString(this.minecraft.font, "" + this.ap, this.getX() + 11 + this.middleWidth + this.apMiddleWidth + 10, this.getY() + 6, new Color(255, 255, 255).hashCode());
                }
            } else {
                this.drawButton(gui, this.isHovered);
                gui.drawString(this.minecraft.font, this.getMessage(), this.getX() + 20, this.getY() + 6, new Color(100, 100, 100).hashCode());
                if (this.abilityType != Ability.AbilityType.WEAPON && this.abilityType != Ability.AbilityType.ACCESSORY) {
                    gui.drawString(this.minecraft.font, "AP", this.getX() + 11 + this.middleWidth + this.apMiddleWidth - 5, this.getY() + 6, new Color(255, 255, 0).hashCode());
                    gui.drawString(this.minecraft.font, "" + this.ap, this.getX() + 11 + this.middleWidth + this.apMiddleWidth + 10, this.getY() + 6, new Color(255, 255, 255).hashCode());
                }
            }
            matrixStack.popPose();
        }
    }

    private void renderColor() {
        if (this.abilityType != null) {
            switch (this.abilityType) {
                case ACTION: {
                    RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.4f, (float)1.0f);
                    break;
                }
                case GROWTH: {
                    RenderSystem.setShaderColor((float)0.4f, (float)0.4f, (float)0.0f, (float)1.0f);
                    break;
                }
                case SUPPORT: {
                    RenderSystem.setShaderColor((float)0.0f, (float)0.4f, (float)0.0f, (float)1.0f);
                    break;
                }
                case WEAPON: {
                    RenderSystem.setShaderColor((float)0.4f, (float)0.0f, (float)0.0f, (float)1.0f);
                    break;
                }
                case ACCESSORY: {
                    RenderSystem.setShaderColor((float)0.0f, (float)0.5f, (float)0.7f, (float)1.0f);
                }
            }
        }
    }

    private void drawButton(GuiGraphics gui, boolean hovered) {
        PoseStack matrixStack = gui.pose();
        matrixStack.pushPose();
        gui.blit(this.texture, this.getX(), this.getY(), 47, 118, 11, this.height);
        gui.blit(this.texture, this.getX() + 11, this.getY(), this.middleWidth, this.height, 59.0f, 118.0f, 1, this.height, 256, 256);
        gui.blit(this.texture, this.getX() + 11 + this.middleWidth, this.getY(), 61, 118, 11, this.height);
        matrixStack.popPose();
        if (this.abilityType != Ability.AbilityType.WEAPON && this.abilityType != Ability.AbilityType.ACCESSORY) {
            RenderSystem.setShaderColor((float)0.3f, (float)0.24f, (float)0.0f, (float)1.0f);
            gui.blit(this.texture, this.getX() + this.middleWidth + 11 + 10, this.getY() - 1, 72, 117, 11, this.height);
            gui.blit(this.texture, this.getX() + this.middleWidth + 11 + 19, this.getY(), this.apMiddleWidth, this.height, 59.0f, 118.0f, 1, this.height, 256, 256);
            gui.blit(this.texture, this.getX() + 11 + this.middleWidth + this.apMiddleWidth + 19, this.getY(), 61, 118, 11, this.height);
        }
        matrixStack.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean bl = this.equipped = PlayerData.get((Player)Minecraft.getInstance().player).isAbilityEquipped(this.text, this.index) || this.isVisual;
        if (!this.equipped && this.abilityType != Ability.AbilityType.WEAPON && this.abilityType != Ability.AbilityType.ACCESSORY) {
            gui.blit(this.texture, this.getX() + 6, this.getY() + 4, 74, 102, 12, 12);
        } else {
            gui.blit(this.texture, this.getX() + 6, this.getY() + 4, 87, 102, 12, 12);
        }
        matrixStack.popPose();
        if (hovered) {
            matrixStack.pushPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.blit(this.texture, this.getX(), this.getY(), 47, 138, 11, this.height);
            gui.blit(this.texture, this.getX() + 11, this.getY(), this.middleWidth, this.height, 59.0f, 138.0f, 1, this.height, 256, 256);
            gui.blit(this.texture, this.getX() + 11 + this.middleWidth, this.getY(), 61, 138, 11, this.height);
            matrixStack.popPose();
        }
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.isHovered && this.abilityType != Ability.AbilityType.WEAPON && this.abilityType != Ability.AbilityType.ACCESSORY && !this.isVisual) {
            return super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }
        return false;
    }

    public boolean isHovered() {
        return this.isHovered && this.visible;
    }

    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getText() {
        return this.text;
    }

    public void playDownSound(SoundManager soundHandlerIn) {
        soundHandlerIn.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.menu_select.get()), (float)1.0f, (float)1.0f));
    }

    public void setAP(int apCost) {
        this.ap = apCost;
    }
}

