/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButtonBase;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MenuButton
extends MenuButtonBase {
    private final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");
    private final int endWidth = 11;
    private final int bLeftU = 0;
    private final int bMiddleU = 12;
    private final int bRightU = 14;
    private final int bVPos = 0;
    private final int bSelectedVPos = 20;
    private final int sbLeftU = 22;
    private final int sbMiddleU = 34;
    private final int sbRightU = 36;
    private final int sbVPos = 118;
    private final int sbSelectedVPos = 138;
    private int rbLeftU = 22;
    private int rbMiddleU = 34;
    private int rbRightU = 36;
    private int rbVPos = 158;
    private int rbSelectedVPos = 178;
    private int middleWidth;
    private int offset;
    private String data;
    private String tip;
    ButtonType type;
    private boolean selected;
    private boolean centerText;

    public void setCenterText(boolean b) {
        this.centerText = b;
    }

    public MenuButton(int x, int y, int widthIn, String buttonText, ButtonType type, Button.OnPress onPress) {
        super(x, y, 22 + widthIn, 20, Utils.translateToLocal(buttonText, new Object[0]), onPress);
        this.middleWidth = widthIn;
        this.type = type;
    }

    public MenuButton(int x, int y, int widthIn, String buttonText, ButtonType type, boolean hasTooltip, Button.OnPress onPress) {
        this(x, y, widthIn, buttonText, type, onPress);
        if (hasTooltip) {
            this.tip = buttonText + ".desc";
        }
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getTip() {
        return this.tip;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    @ParametersAreNonnullByDefault
    public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.isHovered = mouseX > this.getX() + 1 && mouseY >= this.getY() + 1 && mouseX < this.getX() + this.width - 1 && mouseY < this.getY() + this.height - 1;
        Font font = Minecraft.getInstance().font;
        PoseStack matrixStack = gui.pose();
        if (this.visible) {
            matrixStack.pushPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
            int btnMargin = 8;
            int textX = this.getX() + btnMargin;
            int activeColor = new Color(255, 255, 255).hashCode();
            int disabledColor = new Color(100, 100, 100).hashCode();
            boolean shouldOffset = this.isHovered && this.active || !this.active && this.selected;
            int drawColor = this.active ? activeColor : disabledColor;
            int x = this.getX();
            if (shouldOffset) {
                this.setX(x + this.offset);
            }
            this.drawButton(gui, this.isHovered && this.active);
            int drawX = textX + (shouldOffset ? this.offset : 0);
            ClientUtils.drawScrollingString(gui, font, this.getMessage(), drawX, drawX + this.getWidth() - btnMargin * 2, this.getY() + 6, drawColor, this.centerText);
            if (shouldOffset) {
                this.setX(x);
            }
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.popPose();
        }
    }

    private void drawButton(GuiGraphics gui, boolean hovered) {
        int leftU = 0;
        int middleU = 0;
        int rightU = 0;
        int vPos = 0;
        int selVPos = 0;
        switch (this.type.ordinal()) {
            case 0: {
                leftU = 0;
                middleU = 12;
                rightU = 14;
                vPos = 0;
                selVPos = 20;
                this.offset = 10;
                break;
            }
            case 1: {
                leftU = 22;
                middleU = 34;
                rightU = 36;
                vPos = 118;
                selVPos = 138;
                this.offset = 10;
                break;
            }
            case 2: {
                leftU = this.rbLeftU;
                middleU = this.rbMiddleU;
                rightU = this.rbRightU;
                vPos = this.rbVPos;
                selVPos = this.rbSelectedVPos;
                this.offset = 0;
            }
        }
        vPos = hovered || this.selected ? selVPos : vPos;
        gui.blit(this.texture, this.getX(), this.getY(), leftU, vPos, 11, this.height);
        for (int i = 0; i < this.middleWidth; ++i) {
            gui.blit(this.texture, this.getX() + i + 11, this.getY(), middleU, vPos, 1, this.height);
        }
        gui.blit(this.texture, this.getX() + 11 + this.middleWidth, this.getY(), rightU, vPos, 11, this.height);
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.isHovered && this.active) {
            return super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }
        return false;
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void playDownSound(SoundManager soundHandlerIn) {
        soundHandlerIn.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.menu_select.get()), (float)1.0f, (float)1.0f));
    }

    public void setWidth(int pWidth) {
        super.setWidth(pWidth);
        this.middleWidth = pWidth;
    }

    public static enum ButtonType {
        BUTTON,
        SUBBUTTON,
        ROUNDBUTTON;

    }
}

