/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.api.item.IKeychain;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.equipment.MenuEquipmentScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.KKAccessoryItem;
import online.kingdomkeys.kingdomkeys.item.KKArmorItem;
import online.kingdomkeys.kingdomkeys.item.KKPotionItem;
import online.kingdomkeys.kingdomkeys.item.KKResistanceType;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.item.PauldronItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.shotlock.ModShotlocks;
import online.kingdomkeys.kingdomkeys.shotlock.Shotlock;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MenuEquipmentButton
extends Button {
    public Screen toOpen;
    ItemStack stack;
    Shotlock shotlock;
    int colour;
    int labelColour;
    MenuEquipmentScreen parent;
    String label;
    boolean hasLabel;
    ItemCategory category;
    public int offsetY;
    final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");

    public MenuEquipmentButton(ItemStack stack, int x, int y, int colour, Screen toOpen, ItemCategory category, MenuEquipmentScreen parent) {
        super(new Button.Builder((Component)Component.literal((String)""), b -> {
            if (b.visible && b.active) {
                Minecraft.getInstance().setScreen(((MenuEquipmentButton)b).toOpen);
            }
        }).bounds(x, y, (int)((float)parent.width * 0.264f), 14));
        this.stack = stack;
        this.colour = colour;
        this.toOpen = toOpen;
        this.parent = parent;
        this.hasLabel = false;
        this.category = category;
    }

    public MenuEquipmentButton(ItemStack stack, int x, int y, int colour, Screen toOpen, ItemCategory category, MenuEquipmentScreen parent, String label, int labelColour) {
        this(stack, x, y, colour, toOpen, category, parent);
        this.hasLabel = true;
        this.labelColour = labelColour;
        this.label = label;
    }

    public MenuEquipmentButton(String shotlock, int x, int y, int colour, Screen toOpen, ItemCategory category, MenuEquipmentScreen parent) {
        super(new Button.Builder((Component)Component.literal((String)""), b -> {
            if (b.visible && b.active) {
                Minecraft.getInstance().setScreen(((MenuEquipmentButton)b).toOpen);
            }
        }).bounds(x, y, (int)((float)parent.width * 0.264f), 14));
        this.stack = null;
        this.shotlock = !shotlock.isEmpty() ? (Shotlock)ModShotlocks.registry.get(ResourceLocation.parse((String)shotlock)) : null;
        this.colour = colour;
        this.toOpen = toOpen;
        this.parent = parent;
        this.hasLabel = false;
        this.category = category;
    }

    public MenuEquipmentButton(String shotlock, int x, int y, int colour, Screen toOpen, ItemCategory category, MenuEquipmentScreen parent, String label, int labelColour) {
        this(shotlock, x, y, colour, toOpen, category, parent);
        this.hasLabel = true;
        this.labelColour = labelColour;
        this.label = label;
    }

    public int getY() {
        return super.getY() - this.offsetY;
    }

    public void playDownSound(SoundManager soundHandler) {
        soundHandler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.menu_select.get()), (float)1.0f, (float)1.0f));
    }

    public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        Font fr = mc.font;
        PoseStack matrixStack = gui.pose();
        this.isHovered = mouseX > this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        Color col = Color.decode(String.valueOf(this.colour));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float labelWidth = (float)this.parent.width * 0.142f;
        float gradientWidth = (float)this.parent.width * 0.175f;
        if (this.visible) {
            float itemWidth = (float)this.parent.width * 0.264f;
            matrixStack.pushPose();
            RenderSystem.enableBlend();
            Lighting.setupForFlatItems();
            RenderSystem.setShaderColor((float)((float)col.getRed() / 255.0f), (float)((float)col.getGreen() / 255.0f), (float)((float)col.getBlue() / 255.0f), (float)1.0f);
            matrixStack.translate((float)this.getX() + 0.6f, (float)this.getY(), 0.0f);
            matrixStack.scale(0.5f, 0.5f, 1.0f);
            int pWidth = (int)((gradientWidth + itemWidth + 5.0f) * 2.0f / 4.0f);
            gui.blit(this.texture, -pWidth + 14, -1, pWidth, (int)((float)(this.height * 2) * 1.1f), 166.0f, 63.0f, 32, 1, 256, 256);
            gui.blit(this.texture, 0, 0, 166, 34, 18, 28);
            gui.blit(this.texture, 16, 0, (int)(itemWidth * 2.0f - 34.0f + 2.0f), 28, 186.0f, 34.0f, 2, 28, 256, 256);
            gui.blit(this.texture, (int)(itemWidth * 2.0f) - 17, 0, 186, 34, 17, 28);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.blit(this.texture, 6, 4, this.category.getU(), this.category.getV(), 20, 20);
            matrixStack.popPose();
            if (this.stack != null) {
                String itemName = this.stack.getHoverName().getString();
                if (this.stack.getItem() instanceof IKeychain) {
                    itemName = new ItemStack((ItemLike)((IKeychain)this.stack.getItem()).toSummon()).getHoverName().getString();
                } else if (ItemStack.matches((ItemStack)this.stack, (ItemStack)ItemStack.EMPTY)) {
                    itemName = "---";
                }
                gui.drawString(fr, itemName, this.getX() + 15, this.getY() + 3, 0xFFFFFF);
            } else if (this.shotlock != null) {
                gui.drawString(fr, Utils.translateToLocal(this.shotlock.getTranslationKey(), new Object[0]), this.getX() + 15, this.getY() + 3, 0xFFFFFF);
            } else {
                gui.drawString(fr, "---", this.getX() + 15, this.getY() + 3, 0xFFFFFF);
            }
            if (this.isHovered) {
                matrixStack.pushPose();
                matrixStack.translate((float)this.getX() + 0.6f, (float)this.getY(), 0.0f);
                matrixStack.scale(0.5f, 0.5f, 1.0f);
                gui.blit(this.texture, 0, 0, 128, 34, 18, 28);
                gui.blit(this.texture, 16, 0, (int)(itemWidth * 2.0f - 34.0f + 1.0f), 28, 148.0f, 34.0f, 2, 28, 256, 256);
                gui.blit(this.texture, (int)(itemWidth * 2.0f) - 17, 0, 148, 34, 17, 28);
                matrixStack.popPose();
                float iconPosX = (float)this.parent.width * 0.6374f;
                float iconPosY = (float)this.parent.height * 0.17f;
                float iconHeight = (float)this.parent.height * 0.3148f;
                if (this.stack != null) {
                    ItemStack item;
                    Item item2 = this.stack.getItem();
                    if (item2 instanceof IKeychain) {
                        IKeychain kc = (IKeychain)item2;
                        item = new ItemStack((ItemLike)kc.toSummon());
                    } else {
                        item = this.stack;
                    }
                    matrixStack.pushPose();
                    matrixStack.translate(iconPosX, iconPosY, 0.0f);
                    matrixStack.scale(0.075f * iconHeight, 0.075f * iconHeight, 1.0f);
                    ClientUtils.drawItemAsIcon(item, matrixStack, 0, 0, 16);
                    matrixStack.popPose();
                    float strPosX = (float)this.parent.width * 0.634f;
                    float posY = (float)this.parent.height * 0.56f;
                    float strNumPosX = (float)this.parent.width * 0.77f;
                    float abiPosX = (float)this.parent.width * 0.685f;
                    int strength = 0;
                    int magic = 0;
                    int ap = 0;
                    ImmutableMap<KKResistanceType, Integer> resistances = null;
                    List<Object> abilities = new ArrayList();
                    boolean showData = true;
                    if (this.stack.getItem() instanceof IKeychain) {
                        strength = ((IKeychain)this.stack.getItem()).toSummon().getStrength(this.stack);
                        magic = ((IKeychain)this.stack.getItem()).toSummon().getMagic(this.stack);
                        int level = ((IKeychain)this.stack.getItem()).toSummon().getKeybladeLevel(this.stack);
                        abilities = Utils.getKeybladeAbilitiesAtLevel(this.stack.getItem(), level);
                    } else if (this.stack.getItem() instanceof KeybladeItem) {
                        strength = ((KeybladeItem)this.stack.getItem()).getStrength(this.stack);
                        magic = ((KeybladeItem)this.stack.getItem()).getMagic(this.stack);
                        int level = ((KeybladeItem)this.stack.getItem()).getKeybladeLevel(this.stack);
                        abilities = Utils.getKeybladeAbilitiesAtLevel(this.stack.getItem(), level);
                    } else {
                        Item level = this.stack.getItem();
                        if (level instanceof IOrgWeapon) {
                            IOrgWeapon orgWeapon = (IOrgWeapon)level;
                            strength = orgWeapon.getStrength();
                            magic = orgWeapon.getMagic();
                            if (orgWeapon.getAbilities() != null) {
                                abilities = Lists.newArrayList((Object[])orgWeapon.getAbilities());
                            }
                        } else {
                            level = this.stack.getItem();
                            if (level instanceof KKArmorItem) {
                                KKArmorItem armorItem = (KKArmorItem)level;
                                resistances = armorItem.getResList();
                                showData = true;
                            } else if (this.stack.getItem() instanceof KKPotionItem) {
                                showData = true;
                            } else if (this.stack.getItem() instanceof KKAccessoryItem) {
                                ap = ((KKAccessoryItem)this.stack.getItem()).getAp();
                                strength = ((KKAccessoryItem)this.stack.getItem()).getStr();
                                magic = ((KKAccessoryItem)this.stack.getItem()).getMag();
                                abilities = ((KKAccessoryItem)this.stack.getItem()).getAbilities();
                            } else {
                                showData = false;
                            }
                        }
                    }
                    if (showData) {
                        String totalDarknessResStr;
                        boolean showStr = true;
                        boolean showMag = true;
                        boolean showAP = true;
                        boolean showResistances = false;
                        abilities.remove(null);
                        String strengthStr = String.valueOf(strength);
                        String magicStr = String.valueOf(magic);
                        String apStr = String.valueOf(ap);
                        PlayerData playerData = PlayerData.get((Player)mc.player);
                        int totalStrength = playerData.getStrength(true) + strength;
                        int totalMagic = playerData.getMagic(true) + magic;
                        int totalAP = playerData.getMaxAP(true) + ap;
                        Object openBracket = " [ ";
                        String totalStrengthStr = String.valueOf(totalStrength);
                        String totalMagicStr = String.valueOf(totalMagic);
                        String totalAPStr = String.valueOf(totalAP);
                        String totalFireResStr = resistances == null ? "" : String.valueOf(resistances.get((Object)KKResistanceType.fire));
                        String totalIceResStr = resistances == null ? "" : String.valueOf(resistances.get((Object)KKResistanceType.ice));
                        String totalLightningResStr = resistances == null ? "" : String.valueOf(resistances.get((Object)KKResistanceType.lightning));
                        String totalWaterResStr = resistances == null ? "" : String.valueOf(resistances.get((Object)KKResistanceType.water));
                        String totalAirResStr = resistances == null ? "" : String.valueOf(resistances.get((Object)KKResistanceType.air));
                        String totalLightResStr = resistances == null ? "" : String.valueOf(resistances.get((Object)KKResistanceType.light));
                        String string = totalDarknessResStr = resistances == null ? "" : String.valueOf(resistances.get((Object)KKResistanceType.darkness));
                        if (totalStrengthStr.length() == 1) {
                            openBracket = (String)openBracket + " ";
                        }
                        if (totalMagicStr.length() == 1) {
                            openBracket = (String)openBracket + " ";
                        }
                        if (totalAPStr.length() == 1) {
                            openBracket = (String)openBracket + " ";
                        }
                        if (this.stack.getItem() instanceof KKAccessoryItem) {
                            showAP = true;
                            showStr = strength != 0;
                            showMag = magic != 0;
                        } else if (this.stack.getItem() instanceof KKArmorItem) {
                            showAP = false;
                            showStr = false;
                            showMag = false;
                            showResistances = true;
                        } else {
                            showAP = false;
                            showStr = true;
                            showMag = true;
                        }
                        if (this.stack.getItem() instanceof KKPotionItem) {
                            showAP = false;
                            showStr = false;
                            showMag = false;
                        }
                        if (showAP) {
                            gui.drawString(fr, Component.translatable((String)"gui.menu.status.ap").getString(), (int)strPosX, (int)posY, 15631875);
                            gui.drawString(fr, apStr, (int)strNumPosX, (int)posY, 0xFFFFFF);
                            gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width(apStr), (int)posY, 12541956);
                            gui.drawString(fr, "" + playerData.getMaxAP(true), (int)strNumPosX + fr.width(apStr) + fr.width((String)openBracket), (int)posY, 16509473);
                            gui.drawString(fr, "]", (int)strNumPosX + fr.width(apStr) + fr.width((String)openBracket) + fr.width(totalAPStr), (int)posY, 12541956);
                            posY += 10.0f;
                        }
                        if (showStr) {
                            gui.drawString(fr, Component.translatable((String)"gui.menu.status.strength").getString(), (int)strPosX, (int)posY, 15631875);
                            gui.drawString(fr, strengthStr, (int)strNumPosX, (int)posY, 0xFFFFFF);
                            gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width(strengthStr), (int)posY, 12541956);
                            gui.drawString(fr, totalStrengthStr, (int)strNumPosX + fr.width(strengthStr) + fr.width((String)openBracket), (int)posY, 16509473);
                            gui.drawString(fr, "]", (int)strNumPosX + fr.width(strengthStr) + fr.width((String)openBracket) + fr.width(totalStrengthStr), (int)posY, 12541956);
                            posY += 10.0f;
                        }
                        if (showMag) {
                            gui.drawString(fr, Component.translatable((String)"gui.menu.status.magic").getString(), (int)strPosX, (int)posY, 15631875);
                            gui.drawString(fr, magicStr, (int)strNumPosX, (int)posY, 0xFFFFFF);
                            gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width(magicStr), (int)posY, 12541956);
                            gui.drawString(fr, totalMagicStr, (int)strNumPosX + fr.width(magicStr) + fr.width((String)openBracket), (int)posY, 16509473);
                            gui.drawString(fr, "]", (int)strNumPosX + fr.width(magicStr) + fr.width((String)openBracket) + fr.width(totalMagicStr), (int)posY, 12541956);
                            posY += 10.0f;
                        }
                        if (showResistances && resistances != null) {
                            int pos = 0;
                            Object resVal = "" + ((KKArmorItem)this.stack.getItem()).getDefense();
                            gui.drawString(fr, Component.translatable((String)"gui.menu.status.defense").getString(), (int)strPosX, (int)posY + 10 * pos, 15631875);
                            gui.drawString(fr, (String)resVal, (int)strNumPosX, (int)posY + 10 * pos, 0xFFFFFF);
                            gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width((String)resVal), (int)posY + 10 * pos, 12541956);
                            gui.drawString(fr, "" + playerData.getDefense(true), (int)strNumPosX + fr.width((String)resVal) + fr.width((String)openBracket), (int)posY + 10 * pos, 0xFFFF00);
                            gui.drawString(fr, "]", (int)strNumPosX + fr.width((String)resVal) + fr.width((String)openBracket) + fr.width(totalFireResStr), (int)posY + 10 * pos++, 12541956);
                            if (resistances.containsKey((Object)KKResistanceType.fire)) {
                                resVal = ((Integer)resistances.get((Object)KKResistanceType.fire)).toString();
                                gui.drawString(fr, Component.translatable((String)"gui.menu.status.fireresshort").getString(), (int)strPosX, (int)posY + 10 * pos, 15631875);
                                gui.drawString(fr, (String)resVal, (int)strNumPosX, (int)posY + 10 * pos, 0xFFFFFF);
                                gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width((String)resVal), (int)posY + 10 * pos, 12541956);
                                gui.drawString(fr, "" + Utils.getArmorsStat(playerData, KKResistanceType.fire.toString()), (int)strNumPosX + fr.width((String)resVal) + fr.width((String)openBracket), (int)posY + 10 * pos, 0xFFFF00);
                                gui.drawString(fr, "]", (int)strNumPosX + fr.width((String)resVal) + fr.width((String)openBracket) + fr.width(totalFireResStr), (int)posY + 10 * pos++, 12541956);
                            }
                            if (resistances.containsKey((Object)KKResistanceType.ice)) {
                                resVal = ((Integer)resistances.get((Object)KKResistanceType.ice)).toString();
                                gui.drawString(fr, Component.translatable((String)"gui.menu.status.blizzardresshort").getString(), (int)strPosX, (int)posY + 10 * pos, 15631875);
                                gui.drawString(fr, (String)resVal, (int)strNumPosX, (int)posY + 10 * pos, 0xFFFFFF);
                                gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width((String)resVal), (int)posY + 10 * pos, 12541956);
                                gui.drawString(fr, "" + Utils.getArmorsStat(playerData, KKResistanceType.ice.toString()), (int)strNumPosX + fr.width((String)resVal) + fr.width((String)openBracket), (int)posY + 10 * pos, 0xFFFF00);
                                gui.drawString(fr, "]", (int)strNumPosX + fr.width((String)resVal) + fr.width((String)openBracket) + fr.width(totalIceResStr), (int)posY + 10 * pos++, 12541956);
                            }
                            if (resistances.containsKey((Object)KKResistanceType.water)) {
                                resVal = ((Integer)resistances.get((Object)KKResistanceType.water)).toString();
                                gui.drawString(fr, Component.translatable((String)"gui.menu.status.waterresshort").getString(), (int)strPosX, (int)posY + 10 * pos, 15631875);
                                gui.drawString(fr, (String)resVal, (int)strNumPosX, (int)posY + 10 * pos, 0xFFFFFF);
                                gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width((String)resVal), (int)posY + 10 * pos, 12541956);
                                gui.drawString(fr, "" + Utils.getArmorsStat(playerData, KKResistanceType.water.toString()), (int)strNumPosX + fr.width((String)resVal) + fr.width((String)openBracket), (int)posY + 10 * pos, 0xFFFF00);
                                gui.drawString(fr, "]", (int)strNumPosX + fr.width((String)resVal) + fr.width((String)openBracket) + fr.width(totalWaterResStr), (int)posY + 10 * pos++, 12541956);
                            }
                            if (resistances.containsKey((Object)KKResistanceType.lightning)) {
                                resVal = ((Integer)resistances.get((Object)KKResistanceType.lightning)).toString();
                                gui.drawString(fr, Component.translatable((String)"gui.menu.status.thunderresshort").getString(), (int)strPosX, (int)posY + 10 * pos, 15631875);
                                gui.drawString(fr, (String)resVal, (int)strNumPosX, (int)posY + 10 * pos, 0xFFFFFF);
                                gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width((String)resVal), (int)posY + 10 * pos, 12541956);
                                gui.drawString(fr, "" + Utils.getArmorsStat(playerData, KKResistanceType.lightning.toString()), (int)strNumPosX + fr.width((String)resVal) + fr.width((String)openBracket), (int)posY + 10 * pos, 0xFFFF00);
                                gui.drawString(fr, "]", (int)strNumPosX + fr.width((String)resVal) + fr.width((String)openBracket) + fr.width(totalLightningResStr), (int)posY + 10 * pos++, 12541956);
                            }
                            if (resistances.containsKey((Object)KKResistanceType.air)) {
                                resVal = ((Integer)resistances.get((Object)KKResistanceType.air)).toString();
                                gui.drawString(fr, Component.translatable((String)"gui.menu.status.airresshort").getString(), (int)strPosX, (int)posY + 10 * pos, 15631875);
                                gui.drawString(fr, (String)resVal, (int)strNumPosX, (int)posY + 10 * pos, 0xFFFFFF);
                                gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width((String)resVal), (int)posY + 10 * pos, 12541956);
                                gui.drawString(fr, "" + Utils.getArmorsStat(playerData, KKResistanceType.air.toString()), (int)strNumPosX + fr.width((String)resVal) + fr.width((String)openBracket), (int)posY + 10 * pos, 0xFFFF00);
                                gui.drawString(fr, "]", (int)strNumPosX + fr.width((String)resVal) + fr.width((String)openBracket) + fr.width(totalAirResStr), (int)posY + 10 * pos++, 12541956);
                            }
                            if (resistances.containsKey((Object)KKResistanceType.light)) {
                                resVal = ((Integer)resistances.get((Object)KKResistanceType.light)).toString();
                                gui.drawString(fr, Component.translatable((String)"gui.menu.status.lightresshort").getString(), (int)strPosX, (int)posY + 10 * pos, 15631875);
                                gui.drawString(fr, (String)resVal, (int)strNumPosX, (int)posY + 10 * pos, 0xFFFFFF);
                                gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width((String)resVal), (int)posY + 10 * pos, 12541956);
                                gui.drawString(fr, "" + Utils.getArmorsStat(playerData, KKResistanceType.light.toString()), (int)strNumPosX + fr.width((String)resVal) + fr.width((String)openBracket), (int)posY + 10 * pos, 0xFFFF00);
                                gui.drawString(fr, "]", (int)strNumPosX + fr.width((String)resVal) + fr.width((String)openBracket) + fr.width(totalLightResStr), (int)posY + 10 * pos++, 12541956);
                            }
                            if (resistances.containsKey((Object)KKResistanceType.darkness)) {
                                resVal = ((Integer)resistances.get((Object)KKResistanceType.darkness)).toString();
                                gui.drawString(fr, Component.translatable((String)"gui.menu.status.darkresshort").getString(), (int)strPosX, (int)posY + 10 * pos, 15631875);
                                gui.drawString(fr, (String)resVal, (int)strNumPosX, (int)posY + 10 * pos, 0xFFFFFF);
                                gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width((String)resVal), (int)posY + 10 * pos, 12541956);
                                gui.drawString(fr, "" + Utils.getArmorsStat(playerData, KKResistanceType.darkness.toString()), (int)strNumPosX + fr.width((String)resVal) + fr.width((String)openBracket), (int)posY + 10 * pos, 0xFFFF00);
                                gui.drawString(fr, "]", (int)strNumPosX + fr.width((String)resVal) + fr.width((String)openBracket) + fr.width(totalDarknessResStr), (int)posY + 10 * pos++, 12541956);
                            }
                        }
                        if (!abilities.isEmpty()) {
                            gui.drawString(fr, String.valueOf(ChatFormatting.UNDERLINE) + Component.translatable((String)"gui.menu.status.abilities").getString(), (int)abiPosX, (int)posY, 15631875);
                            for (int i = 0; i < abilities.size(); ++i) {
                                Ability ability = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)((String)abilities.get(i))));
                                if (ability != null) {
                                    gui.blit(this.texture, (int)strPosX - 2, (int)posY + (i + 1) * 12 - 4, 73, 102, 12, 12);
                                    gui.drawString(fr, Utils.translateToLocal(ability.getTranslationKey(), new Object[0]), (int)strPosX + 14, (int)posY + (i + 1) * 12 - 1, 0xFFFFFF);
                                    continue;
                                }
                                KingdomKeys.LOGGER.error("Ability " + (String)abilities.get(i) + " does not exist for weapon " + String.valueOf(this.stack.getItem()));
                            }
                        }
                        if (this.stack.getItem() instanceof KeychainItem) {
                            ClientUtils.drawSplitString(gui, ((IKeychain)this.stack.getItem()).toSummon().getDesc(), (int)MenuBackground.tooltipPosX, (int)MenuBackground.tooltipPosY, (int)((float)this.parent.width * 0.46875f), 4437481);
                        } else if (this.stack.getItem() instanceof KeybladeItem) {
                            ClientUtils.drawSplitString(gui, ((KeybladeItem)this.stack.getItem()).getDesc(), (int)MenuBackground.tooltipPosX, (int)MenuBackground.tooltipPosY, (int)((float)this.parent.width * 0.46875f), 4437481);
                        } else if (!(this.stack.getItem() instanceof KKAccessoryItem) && this.stack.getItem() instanceof KKPotionItem) {
                            ClientUtils.drawSplitString(gui, ((Component)this.stack.getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)TooltipFlag.Default.NORMAL).get(1)).getString(), (int)MenuBackground.tooltipPosX, (int)MenuBackground.tooltipPosY, (int)((float)this.parent.width * 0.46875f), 4437481);
                        }
                    } else {
                        Item showStr = this.stack.getItem();
                        if (showStr instanceof PauldronItem) {
                            PauldronItem kbArmor = (PauldronItem)showStr;
                            IItemHandler iItemHandler = (IItemHandler)this.stack.getCapability(Capabilities.ItemHandler.ITEM);
                            if (!iItemHandler.getStackInSlot(0).isEmpty()) {
                                gui.drawString(fr, Component.translatable((String)"kingdomkeys.helmet").getString() + ": " + iItemHandler.getStackInSlot(0).getHoverName().getString(), (int)strPosX, (int)posY, 0xFFFFFF);
                                posY += 10.0f;
                            }
                            if (!iItemHandler.getStackInSlot(1).isEmpty()) {
                                gui.drawString(fr, Component.translatable((String)"kingdomkeys.chestplate").getString() + ": " + iItemHandler.getStackInSlot(1).getHoverName().getString(), (int)strPosX, (int)posY, 0xFFFFFF);
                                posY += 10.0f;
                            }
                            if (!iItemHandler.getStackInSlot(2).isEmpty()) {
                                gui.drawString(fr, Component.translatable((String)"kingdomkeys.leggings").getString() + ": " + iItemHandler.getStackInSlot(2).getHoverName().getString(), (int)strPosX, (int)posY, 0xFFFFFF);
                                posY += 10.0f;
                            }
                            if (!iItemHandler.getStackInSlot(3).isEmpty()) {
                                gui.drawString(fr, Component.translatable((String)"kingdomkeys.boots").getString() + ": " + iItemHandler.getStackInSlot(3).getHoverName().getString(), (int)strPosX, (int)posY, 0xFFFFFF);
                                posY += 10.0f;
                            }
                        }
                    }
                }
            }
            Lighting.setupFor3DItems();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.hasLabel) {
                matrixStack.pushPose();
                Lighting.setupForFlatItems();
                RenderSystem.setShaderColor((float)((float)col.getRed() / 255.0f), (float)((float)col.getGreen() / 255.0f), (float)((float)col.getBlue() / 255.0f), (float)1.0f);
                matrixStack.translate((float)this.getX() - labelWidth, (float)this.getY(), 0.0f);
                matrixStack.scale(0.5f, 0.5f, 1.0f);
                gui.blit(this.texture, 0, 0, 166, 34, 17, 28);
                gui.blit(this.texture, 17, 0, (int)(labelWidth * 2.0f - 31.0f), 28, 184.0f, 34.0f, 1, 28, 256, 256);
                gui.blit(this.texture, (int)(labelWidth * 2.0f) - 14, 0, 204, 34, 14, 28);
                matrixStack.popPose();
                float centerX = labelWidth / 2.0f - (float)(fr.width(Utils.translateToLocal(this.label, new Object[0])) / 2);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                gui.drawString(fr, Utils.translateToLocal(this.label, new Object[0]), (int)((float)this.getX() - labelWidth + centerX), this.getY() + 3, this.labelColour);
            }
        }
    }
}

