/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterBar;
import org.jetbrains.annotations.NotNull;

public class MenuFilterButton
extends Button {
    public ItemCategory category;
    int iconSize = 20;
    MenuFilterBar parent;
    final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");

    public MenuFilterButton(MenuFilterBar parent, int x, int y, ItemCategory category) {
        super(new Button.Builder((Component)Component.literal((String)""), b -> parent.onClickFilter(category)).bounds(x, y, 26, 15));
        this.parent = parent;
        this.category = category;
    }

    public MenuFilterButton(MenuFilterBar parent, int x, int y, String text) {
        this(parent, x, y, (ItemCategory)null);
        this.setMessage((Component)Component.translatable((String)text));
    }

    public void renderWidget(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        Font fr = mc.font;
        float scale = 0.5f;
        boolean bl = this.isHovered = mouseX > this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        if (this.visible) {
            float centreX = (float)this.getX() + ((float)this.width - (float)this.iconSize / 2.0f) * scale;
            float centreY = (float)this.getY() + ((float)this.height - (float)this.iconSize / 2.0f) * scale;
            ClientUtils.blitScaled(this.texture, gui, this.getX(), this.getY(), 66, 0, 52, 30, scale);
            if (this.getMessage().getString().isEmpty() && this.category != null) {
                ClientUtils.blitScaled(this.texture, gui, centreX, centreY, this.category.getU(), this.category.getV(), this.iconSize, this.iconSize, scale);
            } else {
                float textCentreX = (float)this.getX() + ((float)this.width * scale - (float)fr.width((FormattedText)this.getMessage()) * 0.75f / 2.0f);
                float f = this.getY();
                float f2 = (float)this.height * scale;
                Objects.requireNonNull(fr);
                float textCentreY = f + (f2 - 9.0f * 0.75f / 2.0f);
                ClientUtils.drawStringScaled(gui, textCentreX, textCentreY, this.getMessage().getString(), 0xFFFFFF, 0.75f);
            }
        }
    }
}

