/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import org.jetbrains.annotations.NotNull;

public class MenuScrollBar
extends Button {
    double clickX;
    double clickY;
    public int startX;
    public int startY;
    public int handleY;
    public int handleYMax;
    public int localHandleY;
    public int localHandleYMax;
    public int visibleHeight;
    public int bottom;
    float scrollPercent;
    private int contentHeight;
    private int handleHeight;
    public float scrollOffset;
    final int handleEndOffset = 3;
    public static final int WIDTH = 14;
    ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");
    final Vec2 barTopUV = new Vec2(26, 29);
    final Vec2 barBottomUV = new Vec2(26, 47);
    final Vec2 handleTopUV = new Vec2(41, 29);
    final Vec2 handleMiddleUV = new Vec2(41, 39);
    final Vec2 handleBottomUV = new Vec2(41, 41);
    final Vec2 barTopBotDims = new Vec2(14, 17);
    final Vec2 handleDims = new Vec2(14, 9);

    public MenuScrollBar(int x, int y, int bottom, int visibleHeight, int contentHeight) {
        super(new Button.Builder((Component)Component.empty(), button -> {}).bounds(x, y, 14, bottom - y));
        this.visibleHeight = visibleHeight;
        this.handleYMax = this.getY() + 3 + this.barTopBotDims.Y;
        this.bottom = bottom;
        int handleBottom = bottom - 3 - this.barTopBotDims.Y;
        this.handleY = this.handleYMax;
        this.localHandleYMax = handleBottom - this.handleYMax + 1;
        this.setContentHeight(contentHeight);
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getHeight() {
        return super.getHeight();
    }

    public void setHandleY(int handleY) {
        this.handleY = handleY < this.handleYMax ? this.handleYMax : handleY;
    }

    public void setHandleHeight(int height) {
        this.handleHeight = height;
        if (this.handleY > this.getHandleBottom()) {
            this.handleY = this.getHandleBottom() + 1;
        } else if (this.handleY < this.handleYMax) {
            this.handleY = this.handleYMax;
        }
    }

    public int getHandleBottom() {
        return this.bottom - 3 - this.barTopBotDims.Y - this.handleHeight;
    }

    public void setContentHeight(int contentHeight) {
        this.contentHeight = contentHeight;
        float visiblePercentage = (float)this.visibleHeight / (float)contentHeight * 100.0f;
        this.setHandleHeight((int)((float)this.localHandleYMax * (visiblePercentage / 100.0f)));
        if (this.visibleHeight > contentHeight) {
            this.scrollOffset = 0.0f;
        }
    }

    public void renderWidget(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        if (this.visible && this.contentHeight > this.visibleHeight) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            int backgroundOffset = 7;
            gui.fill(this.getX(), this.getY() + 7, this.getX() + this.width, this.bottom - 7, new Color(0.0f, 0.0f, 0.0f, 0.5f).hashCode());
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ClientUtils.blitScaled(this.texture, gui, this.getX(), this.getY(), this.barTopUV.X, this.barTopUV.Y, this.barTopBotDims.X, this.barTopBotDims.Y, 1.0f);
            ClientUtils.blitScaled(this.texture, gui, this.getX(), this.handleY - this.handleDims.Y, this.handleTopUV.X, this.handleTopUV.Y, this.handleDims.X, this.handleDims.Y, 1.0f);
            for (int i = 0; i < this.handleHeight; ++i) {
                ClientUtils.blitScaled(this.texture, gui, this.getX(), this.handleY, this.handleMiddleUV.X, this.handleMiddleUV.Y, this.handleDims.X, 1, 1.0f, this.handleHeight);
            }
            ClientUtils.blitScaled(this.texture, gui, this.getX(), this.handleY + this.handleHeight, this.handleBottomUV.X, this.handleBottomUV.Y, this.handleDims.X, this.handleDims.Y, 1.0f);
            ClientUtils.blitScaled(this.texture, gui, this.getX(), this.bottom - this.barTopBotDims.Y, this.barBottomUV.X, this.barBottomUV.Y, this.barTopBotDims.X, this.barTopBotDims.Y, 1.0f);
        }
    }

    public void updateScroll() {
        if (this.visible && this.contentHeight > this.visibleHeight) {
            this.localHandleY = this.handleY - this.handleYMax;
            this.scrollPercent = (float)this.localHandleY / (float)(this.localHandleYMax - this.handleHeight) * 100.0f;
            int totalScroll = this.contentHeight - this.visibleHeight;
            this.scrollOffset = (float)totalScroll * (this.scrollPercent / 100.0f);
        } else {
            this.scrollOffset = 0.0f;
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.visible && this.contentHeight > this.visibleHeight && this.clickX >= (double)this.getX() && this.clickX <= (double)(this.getX() + this.width)) {
            this.updateScroll();
            if (this.active) {
                this.handleY = (double)this.startY - (this.clickY - mouseY) >= (double)(this.getHandleBottom() + 1) ? this.getHandleBottom() + 1 : ((double)this.startY - (this.clickY - mouseY) <= (double)this.handleYMax ? this.handleYMax : (int)((double)this.startY - (this.clickY - mouseY)));
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.clickX = mouseX;
            this.clickY = mouseY;
            this.startX = this.getX();
            this.startY = this.handleY;
            if (this.clickY >= (double)this.getY() && this.clickY <= (double)(this.getY() + this.bottom) && this.clickX >= (double)this.getX() && this.clickX <= (double)(this.getX() + this.width) && this.visible) {
                this.playDownSound(Minecraft.getInstance().getSoundManager());
            }
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.visible && this.contentHeight > this.visibleHeight) {
            int scrollFactor = 5;
            int oldY = this.handleY;
            if (scrollY > 0.0) {
                this.handleY = (int)Math.max((double)this.handleY - scrollY * (double)scrollFactor, (double)this.handleYMax);
            }
            if (scrollY < 0.0) {
                this.handleY = (int)Math.min((double)this.handleY - scrollY * (double)scrollFactor, (double)(this.getHandleBottom() + 1));
            }
            if (oldY != this.handleY) {
                Minecraft.getInstance().player.playSound((SoundEvent)ModSounds.menu_move.get(), 1.0f, 1.0f);
            }
            this.updateScroll();
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean isVisible() {
        return this.visible && this.contentHeight > this.visibleHeight;
    }

    record Vec2(int X, int Y) {
    }
}

