/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.api.event.EquipmentEvent;
import online.kingdomkeys.kingdomkeys.api.item.IKeychain;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButtonBase;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.equipment.MenuAccessorySelectorScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.equipment.MenuEquipmentScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.KKAccessoryItem;
import online.kingdomkeys.kingdomkeys.item.KKPotionItem;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSEquipAccessories;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class MenuSelectAccessoryButton
extends MenuButtonBase {
    ItemStack stack;
    boolean selected;
    int colour;
    int labelColour;
    MenuAccessorySelectorScreen parent;
    int slot;
    Minecraft minecraft;
    ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");

    public MenuSelectAccessoryButton(ItemStack stack, int slot, int x, int y, int widthIn, MenuAccessorySelectorScreen parent, int colour) {
        super(x, y, widthIn, 20, "", b -> {
            if (b.visible && b.active) {
                if (slot != -1) {
                    LocalPlayer player = Minecraft.getInstance().player;
                    PlayerData playerData = PlayerData.get((Player)player);
                    if (!((EquipmentEvent.Accessory)NeoForge.EVENT_BUS.post((Event)new EquipmentEvent.Accessory((Player)player, playerData.getEquippedAccessory(parent.slot), player.getInventory().getItem(slot), slot, parent.slot))).isCanceled()) {
                        PacketHandler.sendToServer(new CSEquipAccessories(parent.slot, slot));
                        int oldItemAP = 0;
                        int newItemAP = 0;
                        if (!ItemStack.matches((ItemStack)playerData.getEquippedAccessory(parent.slot), (ItemStack)ItemStack.EMPTY)) {
                            oldItemAP = ((KKAccessoryItem)playerData.getEquippedAccessory(parent.slot).getItem()).getAp();
                        }
                        if (!ItemStack.matches((ItemStack)player.getInventory().getItem(slot), (ItemStack)ItemStack.EMPTY)) {
                            newItemAP = ((KKAccessoryItem)player.getInventory().getItem(slot).getItem()).getAp();
                        }
                        if (playerData.getMaxAP(true) - oldItemAP + newItemAP >= Utils.getConsumedAP(playerData)) {
                            ItemStack stackToEquip = player.getInventory().getItem(slot);
                            ItemStack stackPreviouslyEquipped = playerData.equipAccessory(parent.slot, stackToEquip);
                            player.getInventory().setItem(slot, stackPreviouslyEquipped);
                        }
                    } else {
                        player.playSound((SoundEvent)ModSounds.error.get(), 1.0f, 1.0f);
                    }
                } else {
                    Minecraft.getInstance().setScreen((Screen)new MenuEquipmentScreen());
                }
            }
        });
        this.stack = stack;
        this.width = widthIn;
        this.height = 14;
        this.colour = colour;
        this.labelColour = 16771868;
        this.parent = parent;
        this.slot = slot;
        this.minecraft = Minecraft.getInstance();
    }

    public void setWidth(int width) {
        super.setWidth(width);
    }

    public void renderWidget(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        KKAccessoryItem accessory;
        this.isHovered = mouseX > this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        Color col = Color.decode(String.valueOf(this.colour));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemCategory category = ItemCategory.ACCESSORIES;
        PoseStack matrixStack = gui.pose();
        KKAccessoryItem kKAccessoryItem = accessory = ItemStack.matches((ItemStack)this.stack, (ItemStack)ItemStack.EMPTY) || !(this.stack.getItem() instanceof KKAccessoryItem) ? null : (KKAccessoryItem)this.stack.getItem();
        if (this.visible) {
            String accessoryName;
            Lighting.setupForFlatItems();
            matrixStack.pushPose();
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)((float)col.getRed() / 255.0f), (float)((float)col.getGreen() / 255.0f), (float)((float)col.getBlue() / 255.0f), (float)1.0f);
            matrixStack.translate((float)this.getX() + 0.6f, (float)this.getY(), 0.0f);
            matrixStack.scale(0.5f, 0.5f, 1.0f);
            gui.blit(this.texture, 0, 0, 166, 34, 18, 28);
            gui.blit(this.texture, 16, 0, this.width * 2 - 34 + 2, 28, 186.0f, 34.0f, 2, 28, 256, 256);
            gui.blit(this.texture, this.width * 2 - 17, 0, 186, 34, 17, 28);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.blit(this.texture, 6, 4, category.getU(), category.getV(), 20, 20);
            matrixStack.popPose();
            if (accessory == null) {
                accessoryName = "---";
            } else {
                accessoryName = this.stack.getHoverName().getString();
                String amount = "x" + String.valueOf(this.parent.addedAccessoriesList.get(this.stack.getItem()));
                gui.drawString(this.minecraft.font, String.valueOf(ChatFormatting.YELLOW) + amount, this.getX() + this.width - this.minecraft.font.width(amount) - 3, this.getY() + 3, 0xFFFFFF);
            }
            gui.drawString(this.minecraft.font, accessoryName, this.getX() + 15, this.getY() + 3, 0xFFFFFF);
            if (this.isButtonRendered(mouseY) && (this.selected || this.isHovered)) {
                matrixStack.pushPose();
                RenderSystem.enableBlend();
                matrixStack.translate((float)this.getX() + 0.6f, (float)this.getY(), 0.0f);
                matrixStack.scale(0.5f, 0.5f, 1.0f);
                gui.blit(this.texture, 0, 0, 128, 34, 18, 28);
                gui.blit(this.texture, 16, 0, this.width * 2 - 34 + 2, 28, 148.0f, 34.0f, 2, 28, 256, 256);
                gui.blit(this.texture, this.width * 2 - 17, 0, 148, 34, 17, 28);
                matrixStack.popPose();
            }
            Lighting.setupForFlatItems();
        }
    }

    public void renderData(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        Font fr = this.minecraft.font;
        KKAccessoryItem accessory = ItemStack.matches((ItemStack)this.stack, (ItemStack)ItemStack.EMPTY) || !(this.stack.getItem() instanceof KKAccessoryItem) ? null : (KKAccessoryItem)this.stack.getItem();
        PoseStack matrixStack = gui.pose();
        if (this.isButtonRendered(mouseY) && (this.selected || this.isHovered) && accessory != null) {
            float iconPosX = (float)this.parent.width * 0.565f;
            float iconPosY = (float)this.parent.height * 0.2f;
            float iconHeight = (float)this.parent.height * 0.3148f;
            Lighting.setupForFlatItems();
            matrixStack.pushPose();
            matrixStack.translate(iconPosX, iconPosY, 0.0f);
            matrixStack.scale(0.0625f * iconHeight, 0.0625f * iconHeight, 1.0f);
            ClientUtils.drawItemAsIcon(this.stack, matrixStack, 0, 0, 16);
            matrixStack.popPose();
            float strPosX = (float)this.parent.width * 0.57f;
            float posY = (float)this.parent.height * 0.55f;
            float strNumPosX = (float)this.parent.width * 0.67f;
            float abiPosX = (float)this.parent.width * 0.62f;
            int strength = 0;
            int magic = 0;
            int ap = 0;
            List<Object> abilities = new ArrayList();
            boolean showData = true;
            if (this.stack.getItem() instanceof IKeychain) {
                strength = ((IKeychain)this.stack.getItem()).toSummon().getStrength(this.stack);
                magic = ((IKeychain)this.stack.getItem()).toSummon().getMagic(this.stack);
                int level = ((IKeychain)this.stack.getItem()).toSummon().getKeybladeLevel(this.stack);
                abilities = Utils.getKeybladeAbilitiesAtLevel(this.stack.getItem(), level);
            } else if (this.stack.getItem() instanceof KeybladeItem) {
                strength = ((KeybladeItem)this.stack.getItem()).getStrength(this.stack);
                magic = ((KeybladeItem)this.stack.getItem()).getMagic(this.stack);
                int level = ((KeybladeItem)this.stack.getItem()).getKeybladeLevel(this.stack);
                abilities = Utils.getKeybladeAbilitiesAtLevel(this.stack.getItem(), level);
            } else {
                Item level = this.stack.getItem();
                if (level instanceof IOrgWeapon) {
                    IOrgWeapon orgWeapon = (IOrgWeapon)level;
                    strength = orgWeapon.getStrength();
                    magic = orgWeapon.getMagic();
                } else if (this.stack.getItem() instanceof ArmorItem) {
                    showData = false;
                } else if (this.stack.getItem() instanceof KKPotionItem) {
                    showData = false;
                } else if (this.stack.getItem() instanceof KKAccessoryItem) {
                    ap = ((KKAccessoryItem)this.stack.getItem()).getAp();
                    strength = ((KKAccessoryItem)this.stack.getItem()).getStr();
                    magic = ((KKAccessoryItem)this.stack.getItem()).getMag();
                    abilities = ((KKAccessoryItem)this.stack.getItem()).getAbilities();
                } else {
                    showData = false;
                }
            }
            if (showData) {
                Item item;
                boolean showStr = true;
                boolean showMag = true;
                boolean showAP = true;
                abilities.remove(null);
                String strengthStr = String.valueOf(strength);
                String magicStr = String.valueOf(magic);
                String apStr = String.valueOf(ap);
                int oldAP = 0;
                int oldStr = 0;
                int oldMag = 0;
                PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
                ItemStack replacedItem = playerData.getEquippedAccessory(this.parent.slot);
                if (!ItemStack.matches((ItemStack)replacedItem, (ItemStack)ItemStack.EMPTY) && (item = replacedItem.getItem()) instanceof KKAccessoryItem) {
                    KKAccessoryItem oldAccessory = (KKAccessoryItem)item;
                    oldAP = oldAccessory.getAp();
                    oldStr = oldAccessory.getStr();
                    oldMag = oldAccessory.getMag();
                }
                int totalStrength = playerData.getStrength(true) + strength;
                int totalMagic = playerData.getMagic(true) + magic;
                int totalAP = playerData.getMaxAP(true) + ap;
                Object openBracket = " [ ";
                String totalStrengthStr = String.valueOf(totalStrength);
                String totalMagicStr = String.valueOf(totalMagic);
                String totalAPStr = String.valueOf(totalAP);
                if (totalStrengthStr.length() == 1) {
                    openBracket = (String)openBracket + " ";
                }
                if (totalMagicStr.length() == 1) {
                    openBracket = (String)openBracket + " ";
                }
                if (totalAPStr.length() == 1) {
                    openBracket = (String)openBracket + " ";
                }
                if (this.stack.getItem() instanceof KKAccessoryItem) {
                    showAP = true;
                    showStr = strength != oldStr || strength != 0;
                    showMag = magic != oldMag || magic != 0;
                } else {
                    showAP = false;
                    showStr = true;
                    showMag = true;
                }
                if (showAP) {
                    gui.drawString(fr, Component.translatable((String)"gui.menu.status.ap").getString(), (int)strPosX, (int)posY, 15631875);
                    gui.drawString(fr, apStr, (int)strNumPosX, (int)posY, 0xFFFFFF);
                    gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width(apStr), (int)posY, 12541956);
                    gui.drawString(fr, "" + (totalAP - oldAP), (int)strNumPosX + fr.width(apStr) + fr.width((String)openBracket), (int)posY, oldAP > ap ? 0xFF0000 : (oldAP == ap ? 0xFFFF00 : 43775));
                    gui.drawString(fr, "]", (int)strNumPosX + fr.width(apStr) + fr.width((String)openBracket) + fr.width(totalAPStr), (int)posY, 12541956);
                    posY += 10.0f;
                }
                if (showStr) {
                    gui.drawString(fr, Component.translatable((String)"gui.menu.status.strength").getString(), (int)strPosX, (int)posY, 15631875);
                    gui.drawString(fr, strengthStr, (int)strNumPosX, (int)posY, 0xFFFFFF);
                    gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width(strengthStr), (int)posY, 12541956);
                    gui.drawString(fr, "" + (totalStrength - oldStr), (int)strNumPosX + fr.width(strengthStr) + fr.width((String)openBracket), (int)posY, oldStr > strength ? 0xFF0000 : (oldStr == strength ? 0xFFFF00 : 43775));
                    gui.drawString(fr, "]", (int)strNumPosX + fr.width(strengthStr) + fr.width((String)openBracket) + fr.width(totalStrengthStr), (int)posY, 12541956);
                    posY += 10.0f;
                }
                if (showMag) {
                    gui.drawString(fr, Component.translatable((String)"gui.menu.status.magic").getString(), (int)strPosX, (int)posY, 15631875);
                    gui.drawString(fr, magicStr, (int)strNumPosX, (int)posY, 0xFFFFFF);
                    gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width(magicStr), (int)posY, 12541956);
                    gui.drawString(fr, "" + (totalMagic - oldMag), (int)strNumPosX + fr.width(magicStr) + fr.width((String)openBracket), (int)posY, oldMag > magic ? 0xFF0000 : (oldMag == magic ? 0xFFFF00 : 43775));
                    gui.drawString(fr, "]", (int)strNumPosX + fr.width(magicStr) + fr.width((String)openBracket) + fr.width(totalMagicStr), (int)posY, 12541956);
                    posY += 10.0f;
                }
                if (!abilities.isEmpty()) {
                    gui.drawString(fr, Component.translatable((String)"gui.menu.status.abilities").getString(), (int)abiPosX, (int)posY, 15631875);
                    for (int i = 0; i < abilities.size(); ++i) {
                        Ability ability = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)((String)abilities.get(i))));
                        gui.blit(this.texture, (int)strPosX - 2, (int)posY + (i + 1) * 12 - 4, 73, 102, 12, 12);
                        gui.drawString(fr, Utils.translateToLocal(ability.getTranslationKey(), new Object[0]), (int)strPosX + 14, (int)posY + (i + 1) * 12 - 1, 0xFFFFFF);
                    }
                }
            }
        }
    }

    public boolean isButtonRendered(double mouseY) {
        return mouseY >= (double)this.parent.scrollBar.getY() && mouseY <= (double)(this.parent.scrollBar.getBottom() + 2);
    }

    public void playDownSound(SoundManager soundHandler) {
        soundHandler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.menu_in.get()), (float)1.0f, (float)1.0f));
    }
}

