/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import online.kingdomkeys.kingdomkeys.api.event.EquipmentEvent;
import online.kingdomkeys.kingdomkeys.api.item.IKeychain;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButtonBase;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.equipment.MenuArmorSelectorScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.equipment.MenuEquipmentScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.KKAccessoryItem;
import online.kingdomkeys.kingdomkeys.item.KKArmorItem;
import online.kingdomkeys.kingdomkeys.item.KKPotionItem;
import online.kingdomkeys.kingdomkeys.item.KKResistanceType;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSEquipArmor;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MenuSelectArmorButton
extends MenuButtonBase {
    ItemStack stack;
    boolean selected;
    int colour;
    int labelColour;
    MenuArmorSelectorScreen parent;
    int slot;
    Minecraft minecraft;
    final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");

    public MenuSelectArmorButton(ItemStack stack, int slot, int x, int y, int widthIn, MenuArmorSelectorScreen parent, int colour) {
        super(x, y, widthIn, 20, "", b -> {
            if (b.visible && b.active) {
                if (slot != -1) {
                    LocalPlayer player = Minecraft.getInstance().player;
                    PlayerData playerData = PlayerData.get((Player)player);
                    if (!((EquipmentEvent.Armour)NeoForge.EVENT_BUS.post((Event)new EquipmentEvent.Armour((Player)player, playerData.getEquippedArmor(parent.slot), player.getInventory().getItem(slot), slot, parent.slot))).isCanceled()) {
                        PacketHandler.sendToServer(new CSEquipArmor(parent.slot, slot));
                        ItemStack stackToEquip = player.getInventory().getItem(slot);
                        ItemStack stackPreviouslyEquipped = playerData.equipArmor(parent.slot, stackToEquip);
                        player.getInventory().setItem(slot, stackPreviouslyEquipped);
                        b.visible = false;
                    }
                } else {
                    Minecraft.getInstance().setScreen((Screen)new MenuEquipmentScreen());
                }
            }
        });
        this.stack = stack;
        this.width = widthIn;
        this.height = 14;
        this.colour = colour;
        this.labelColour = 16771868;
        this.parent = parent;
        this.slot = slot;
        this.minecraft = Minecraft.getInstance();
    }

    public void setWidth(int width) {
        super.setWidth(width);
    }

    public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        KKArmorItem armor;
        PoseStack matrixStack = gui.pose();
        this.isHovered = mouseX > this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        Color col = Color.decode(String.valueOf(this.colour));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemCategory category = ItemCategory.EQUIPMENT;
        KKArmorItem kKArmorItem = armor = ItemStack.matches((ItemStack)this.stack, (ItemStack)ItemStack.EMPTY) || !(this.stack.getItem() instanceof KKArmorItem) ? null : (KKArmorItem)this.stack.getItem();
        if (this.visible) {
            String accessoryName;
            Lighting.setupForFlatItems();
            matrixStack.pushPose();
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)((float)col.getRed() / 255.0f), (float)((float)col.getGreen() / 255.0f), (float)((float)col.getBlue() / 255.0f), (float)1.0f);
            matrixStack.translate((float)this.getX() + 0.6f, (float)this.getY(), 0.0f);
            matrixStack.scale(0.5f, 0.5f, 1.0f);
            gui.blit(this.texture, 0, 0, 166, 34, 18, 28);
            gui.blit(this.texture, 16, 0, this.width * 2 - 34 + 2, 28, 186.0f, 34.0f, 2, 28, 256, 256);
            gui.blit(this.texture, this.width * 2 - 17, 0, 186, 34, 17, 28);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.blit(this.texture, 6, 4, category.getU(), category.getV(), 20, 20);
            matrixStack.popPose();
            if (armor == null) {
                accessoryName = "---";
            } else {
                accessoryName = this.stack.getHoverName().getString();
                String amount = "x" + String.valueOf(this.parent.addedArmorList.get(this.stack.getItem()));
                gui.drawString(this.minecraft.font, String.valueOf(ChatFormatting.YELLOW) + amount, this.getX() + this.width - this.minecraft.font.width(amount) - 3, this.getY() + 3, 0xFFFFFF);
            }
            gui.drawString(this.minecraft.font, accessoryName, this.getX() + 15, this.getY() + 3, 0xFFFFFF);
            if (this.isButtonRendered(mouseY) && (this.selected || this.isHovered)) {
                matrixStack.pushPose();
                RenderSystem.enableBlend();
                matrixStack.translate((float)this.getX() + 0.6f, (float)this.getY(), 0.0f);
                matrixStack.scale(0.5f, 0.5f, 1.0f);
                gui.blit(this.texture, 0, 0, 128, 34, 18, 28);
                gui.blit(this.texture, 16, 0, this.width * 2 - 34 + 2, 28, 148.0f, 34.0f, 2, 28, 256, 256);
                gui.blit(this.texture, this.width * 2 - 17, 0, 148, 34, 17, 28);
                RenderSystem.disableBlend();
                matrixStack.popPose();
            }
            Lighting.setupForFlatItems();
        }
    }

    public void renderData(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        Font fr = this.minecraft.font;
        KKArmorItem armor = ItemStack.matches((ItemStack)this.stack, (ItemStack)ItemStack.EMPTY) || !(this.stack.getItem() instanceof KKArmorItem) ? null : (KKArmorItem)this.stack.getItem();
        PoseStack matrixStack = gui.pose();
        if (this.isButtonRendered(mouseY) && (this.selected || this.isHovered) && armor != null) {
            float iconPosX = (float)this.parent.width * 0.565f;
            float iconPosY = (float)this.parent.height * 0.2f;
            float iconHeight = (float)this.parent.height * 0.3148f;
            Lighting.setupForFlatItems();
            matrixStack.pushPose();
            matrixStack.translate(iconPosX, iconPosY, 0.0f);
            matrixStack.scale(0.0625f * iconHeight, 0.0625f * iconHeight, 1.0f);
            ClientUtils.drawItemAsIcon(this.stack, matrixStack, 0, 0, 16);
            matrixStack.popPose();
            float strPosX = (float)this.parent.width * 0.57f;
            float posY = (float)this.parent.height * 0.55f;
            float strNumPosX = (float)this.parent.width * 0.67f;
            float abiPosX = (float)this.parent.width * 0.62f;
            int strength = 0;
            int magic = 0;
            int ap = 0;
            ImmutableMap<KKResistanceType, Integer> resistances = null;
            List<Object> abilities = new ArrayList();
            boolean showData = true;
            if (this.stack.getItem() instanceof IKeychain) {
                strength = ((IKeychain)this.stack.getItem()).toSummon().getStrength(this.stack);
                magic = ((IKeychain)this.stack.getItem()).toSummon().getMagic(this.stack);
                int level = ((IKeychain)this.stack.getItem()).toSummon().getKeybladeLevel(this.stack);
                abilities = Utils.getKeybladeAbilitiesAtLevel(this.stack.getItem(), level);
            } else if (this.stack.getItem() instanceof KeybladeItem) {
                strength = ((KeybladeItem)this.stack.getItem()).getStrength(this.stack);
                magic = ((KeybladeItem)this.stack.getItem()).getMagic(this.stack);
                int level = ((KeybladeItem)this.stack.getItem()).getKeybladeLevel(this.stack);
                abilities = Utils.getKeybladeAbilitiesAtLevel(this.stack.getItem(), level);
            } else {
                Item level = this.stack.getItem();
                if (level instanceof IOrgWeapon) {
                    IOrgWeapon orgWeapon = (IOrgWeapon)level;
                    strength = orgWeapon.getStrength();
                    magic = orgWeapon.getMagic();
                } else {
                    level = this.stack.getItem();
                    if (level instanceof KKArmorItem) {
                        KKArmorItem armorItem = (KKArmorItem)level;
                        resistances = armorItem.getResList();
                        showData = true;
                    } else if (this.stack.getItem() instanceof KKPotionItem) {
                        showData = false;
                    } else if (this.stack.getItem() instanceof KKAccessoryItem) {
                        ap = ((KKAccessoryItem)this.stack.getItem()).getAp();
                        strength = ((KKAccessoryItem)this.stack.getItem()).getStr();
                        magic = ((KKAccessoryItem)this.stack.getItem()).getMag();
                        abilities = ((KKAccessoryItem)this.stack.getItem()).getAbilities();
                    } else {
                        showData = false;
                    }
                }
            }
            if (showData) {
                Item item;
                Item item2;
                boolean showStr = true;
                boolean showMag = true;
                boolean showAP = true;
                boolean showResistances = false;
                abilities.remove(null);
                String strengthStr = String.valueOf(strength);
                String magicStr = String.valueOf(magic);
                String apStr = String.valueOf(ap);
                int oldAP = 0;
                int oldStr = 0;
                int oldMag = 0;
                PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
                ItemStack replacedAccessory = playerData.getEquippedAccessory(this.parent.slot);
                if (!ItemStack.matches((ItemStack)replacedAccessory, (ItemStack)ItemStack.EMPTY) && (item2 = replacedAccessory.getItem()) instanceof KKAccessoryItem) {
                    KKAccessoryItem oldAccessory = (KKAccessoryItem)item2;
                    oldAP = oldAccessory.getAp();
                    oldStr = oldAccessory.getStr();
                    oldMag = oldAccessory.getMag();
                }
                ImmutableMap<KKResistanceType, Integer> oldResistances = null;
                int oldDefense = 0;
                ItemStack replacedArmor = playerData.getEquippedArmor(this.parent.slot);
                if (!ItemStack.matches((ItemStack)replacedArmor, (ItemStack)ItemStack.EMPTY) && (item = replacedArmor.getItem()) instanceof KKArmorItem) {
                    KKArmorItem oldArmor = (KKArmorItem)item;
                    oldDefense = oldArmor.getDefense();
                    oldResistances = oldArmor.getResList();
                }
                int totalStrength = playerData.getStrength(true) + strength;
                int totalMagic = playerData.getMagic(true) + magic;
                int totalAP = playerData.getMaxAP(true) + ap;
                Object openBracket = " [ ";
                String totalStrengthStr = String.valueOf(totalStrength);
                String totalMagicStr = String.valueOf(totalMagic);
                String totalAPStr = String.valueOf(totalAP);
                String totalDefResStr = String.valueOf(playerData.getDefense(true) + armor.getDefense());
                String totalFireResStr = String.valueOf(resistances.get((Object)KKResistanceType.fire));
                String totalIceResStr = String.valueOf(resistances.get((Object)KKResistanceType.ice));
                String totalLightningResStr = String.valueOf(resistances.get((Object)KKResistanceType.lightning));
                String totalLightResStr = String.valueOf(resistances.get((Object)KKResistanceType.light));
                String totalDarknessResStr = String.valueOf(resistances.get((Object)KKResistanceType.darkness));
                if (totalStrengthStr.length() == 1) {
                    openBracket = (String)openBracket + " ";
                }
                if (totalMagicStr.length() == 1) {
                    openBracket = (String)openBracket + " ";
                }
                if (totalAPStr.length() == 1) {
                    openBracket = (String)openBracket + " ";
                }
                HashMap<Integer, ItemStack> equippedArmourWithSelected = new HashMap<Integer, ItemStack>(playerData.getEquippedArmors());
                if (this.stack.getItem() instanceof KKAccessoryItem) {
                    showAP = true;
                    showStr = strength != oldStr || strength != 0;
                    showMag = magic != oldMag || magic != 0;
                } else if (this.stack.getItem() instanceof KKArmorItem) {
                    showAP = false;
                    showStr = false;
                    showMag = false;
                    showResistances = true;
                    equippedArmourWithSelected.put(this.parent.slot, this.stack);
                } else {
                    showAP = false;
                    showStr = true;
                    showMag = true;
                }
                if (showAP) {
                    gui.drawString(fr, Component.translatable((String)"gui.menu.status.ap").getString(), (int)strPosX, (int)posY, 15631875);
                    gui.drawString(fr, apStr, (int)strNumPosX, (int)posY, 0xFFFFFF);
                    gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width(apStr), (int)posY, 12541956);
                    gui.drawString(fr, "" + (totalAP - oldAP), (int)strNumPosX + fr.width(apStr) + fr.width((String)openBracket), (int)posY, oldAP > ap ? 0xFF0000 : (oldAP == ap ? 0xFFFF00 : 43775));
                    gui.drawString(fr, "]", (int)strNumPosX + fr.width(apStr) + fr.width((String)openBracket) + fr.width(totalAPStr), (int)posY, 12541956);
                    posY += 10.0f;
                }
                if (showStr) {
                    gui.drawString(fr, Component.translatable((String)"gui.menu.status.strength").getString(), (int)strPosX, (int)posY, 15631875);
                    gui.drawString(fr, strengthStr, (int)strNumPosX, (int)posY, 0xFFFFFF);
                    gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width(strengthStr), (int)posY, 12541956);
                    gui.drawString(fr, "" + (totalStrength - oldStr), (int)strNumPosX + fr.width(strengthStr) + fr.width((String)openBracket), (int)posY, oldStr > strength ? 0xFF0000 : (oldStr == strength ? 0xFFFF00 : 43775));
                    gui.drawString(fr, "]", (int)strNumPosX + fr.width(strengthStr) + fr.width((String)openBracket) + fr.width(totalStrengthStr), (int)posY, 12541956);
                    posY += 10.0f;
                }
                if (showMag) {
                    gui.drawString(fr, Component.translatable((String)"gui.menu.status.magic").getString(), (int)strPosX, (int)posY, 15631875);
                    gui.drawString(fr, magicStr, (int)strNumPosX, (int)posY, 0xFFFFFF);
                    gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width(magicStr), (int)posY, 12541956);
                    gui.drawString(fr, "" + (totalMagic - oldMag), (int)strNumPosX + fr.width(magicStr) + fr.width((String)openBracket), (int)posY, oldMag > magic ? 0xFF0000 : (oldMag == magic ? 0xFFFF00 : 43775));
                    gui.drawString(fr, "]", (int)strNumPosX + fr.width(magicStr) + fr.width((String)openBracket) + fr.width(totalMagicStr), (int)posY, 12541956);
                    posY += 10.0f;
                }
                if (showResistances && resistances != null) {
                    String resVal;
                    int oldVal;
                    int pos = 0;
                    String resVal2 = "" + ((KKArmorItem)this.stack.getItem()).getDefense();
                    gui.drawString(fr, Component.translatable((String)"gui.menu.status.defense").getString(), (int)strPosX, (int)posY + 10 * pos, 15631875);
                    gui.drawString(fr, resVal2, (int)strNumPosX, (int)posY + 10 * pos, 0xFFFFFF);
                    gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width(resVal2), (int)posY + 10 * pos, 12541956);
                    gui.drawString(fr, "" + (playerData.getDefense(true) + ((KKArmorItem)this.stack.getItem()).getDefense() - oldDefense), (int)strNumPosX + fr.width(resVal2) + fr.width((String)openBracket), (int)posY + 10 * pos, 0xFFFF00);
                    gui.drawString(fr, "]", (int)strNumPosX + fr.width(resVal2) + fr.width((String)openBracket) + fr.width(totalDefResStr), (int)posY + 10 * pos++, 12541956);
                    KKResistanceType type = KKResistanceType.fire;
                    if (resistances.containsKey((Object)type)) {
                        oldVal = oldResistances == null || oldResistances.get((Object)type) == null ? 0 : (Integer)oldResistances.get((Object)type);
                        resVal = ((Integer)resistances.get((Object)type)).toString();
                        gui.drawString(fr, Component.translatable((String)"gui.menu.status.fireresshort").getString(), (int)strPosX, (int)posY + 10 * pos, 15631875);
                        gui.drawString(fr, resVal, (int)strNumPosX, (int)posY + 10 * pos, 0xFFFFFF);
                        gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width(resVal), (int)posY + 10 * pos, 12541956);
                        gui.drawString(fr, "" + (Utils.getArmorsStat(equippedArmourWithSelected, type.toString()) - oldVal), (int)strNumPosX + fr.width(resVal) + fr.width((String)openBracket), (int)posY + 10 * pos, 0xFFFF00);
                        gui.drawString(fr, "]", (int)strNumPosX + fr.width(resVal) + fr.width((String)openBracket) + fr.width(totalFireResStr), (int)posY + 10 * pos++, 12541956);
                    }
                    if (resistances.containsKey((Object)(type = KKResistanceType.ice))) {
                        oldVal = oldResistances == null || oldResistances.get((Object)type) == null ? 0 : (Integer)oldResistances.get((Object)type);
                        resVal = ((Integer)resistances.get((Object)type)).toString();
                        gui.drawString(fr, Component.translatable((String)"gui.menu.status.blizzardresshort").getString(), (int)strPosX, (int)posY + 10 * pos, 15631875);
                        gui.drawString(fr, resVal, (int)strNumPosX, (int)posY + 10 * pos, 0xFFFFFF);
                        gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width(resVal), (int)posY + 10 * pos, 12541956);
                        gui.drawString(fr, "" + (Utils.getArmorsStat(equippedArmourWithSelected, type.toString()) - oldVal), (int)strNumPosX + fr.width(resVal) + fr.width((String)openBracket), (int)posY + 10 * pos, 0xFFFF00);
                        gui.drawString(fr, "]", (int)strNumPosX + fr.width(resVal) + fr.width((String)openBracket) + fr.width(totalIceResStr), (int)posY + 10 * pos++, 12541956);
                    }
                    if (resistances.containsKey((Object)(type = KKResistanceType.lightning))) {
                        oldVal = oldResistances == null || oldResistances.get((Object)type) == null ? 0 : (Integer)oldResistances.get((Object)type);
                        resVal = ((Integer)resistances.get((Object)type)).toString();
                        gui.drawString(fr, Component.translatable((String)"gui.menu.status.thunderresshort").getString(), (int)strPosX, (int)posY + 10 * pos, 15631875);
                        gui.drawString(fr, resVal, (int)strNumPosX, (int)posY + 10 * pos, 0xFFFFFF);
                        gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width(resVal), (int)posY + 10 * pos, 12541956);
                        gui.drawString(fr, "" + (Utils.getArmorsStat(equippedArmourWithSelected, type.toString()) - oldVal), (int)strNumPosX + fr.width(resVal) + fr.width((String)openBracket), (int)posY + 10 * pos, 0xFFFF00);
                        gui.drawString(fr, "]", (int)strNumPosX + fr.width(resVal) + fr.width((String)openBracket) + fr.width(totalLightningResStr), (int)posY + 10 * pos++, 12541956);
                    }
                    if (resistances.containsKey((Object)(type = KKResistanceType.light))) {
                        oldVal = oldResistances == null || oldResistances.get((Object)type) == null ? 0 : (Integer)oldResistances.get((Object)type);
                        resVal = ((Integer)resistances.get((Object)type)).toString();
                        gui.drawString(fr, Component.translatable((String)"gui.menu.status.lightresshort").getString(), (int)strPosX, (int)posY + 10 * pos, 15631875);
                        gui.drawString(fr, resVal, (int)strNumPosX, (int)posY + 10 * pos, 0xFFFFFF);
                        gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width(resVal), (int)posY + 10 * pos, 12541956);
                        gui.drawString(fr, "" + (Utils.getArmorsStat(equippedArmourWithSelected, type.toString()) - oldVal), (int)strNumPosX + fr.width(resVal) + fr.width((String)openBracket), (int)posY + 10 * pos, 0xFFFF00);
                        gui.drawString(fr, "]", (int)strNumPosX + fr.width(resVal) + fr.width((String)openBracket) + fr.width(totalLightResStr), (int)posY + 10 * pos++, 12541956);
                    }
                    if (resistances.containsKey((Object)(type = KKResistanceType.darkness))) {
                        oldVal = oldResistances == null || oldResistances.get((Object)type) == null ? 0 : (Integer)oldResistances.get((Object)type);
                        resVal = ((Integer)resistances.get((Object)type)).toString();
                        gui.drawString(fr, Component.translatable((String)"gui.menu.status.darkresshort").getString(), (int)strPosX, (int)posY + 10 * pos, 15631875);
                        gui.drawString(fr, resVal, (int)strNumPosX, (int)posY + 10 * pos, 0xFFFFFF);
                        gui.drawString(fr, (String)openBracket, (int)strNumPosX + fr.width(resVal), (int)posY + 10 * pos, 12541956);
                        gui.drawString(fr, "" + (Utils.getArmorsStat(equippedArmourWithSelected, type.toString()) - oldVal), (int)strNumPosX + fr.width(resVal) + fr.width((String)openBracket), (int)posY + 10 * pos, 0xFFFF00);
                        gui.drawString(fr, "]", (int)strNumPosX + fr.width(resVal) + fr.width((String)openBracket) + fr.width(totalDarknessResStr), (int)posY + 10 * pos++, 12541956);
                    }
                }
            }
        }
    }

    public boolean isButtonRendered(double mouseY) {
        return mouseY >= (double)this.parent.scrollBar.getY() && mouseY <= (double)(this.parent.scrollBar.getBottom() + 2);
    }

    public void playDownSound(SoundManager soundHandler) {
        soundHandler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.menu_in.get()), (float)1.0f, (float)1.0f));
    }
}

