/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.api.event.EquipmentEvent;
import online.kingdomkeys.kingdomkeys.api.item.IKeychain;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButtonBase;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.equipment.MenuEquipmentScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.equipment.MenuEquipmentSelectorScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSEquipKeychain;
import online.kingdomkeys.kingdomkeys.network.cts.CSSummonKeyblade;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MenuSelectEquipmentButton
extends MenuButtonBase {
    ItemStack stack;
    boolean selected;
    int colour;
    int labelColour;
    MenuEquipmentSelectorScreen parent;
    int slot;
    Minecraft minecraft;
    final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");

    public MenuSelectEquipmentButton(ItemStack stack, int slot, int x, int y, int widthIn, MenuEquipmentSelectorScreen parent, int colour) {
        super(x, y, widthIn, 20, "", b -> {
            if (b.visible && b.active) {
                if (slot != -1) {
                    LocalPlayer player = Minecraft.getInstance().player;
                    PlayerData playerData = PlayerData.get((Player)player);
                    if (!((EquipmentEvent.Keychain)NeoForge.EVENT_BUS.post((Event)new EquipmentEvent.Keychain((Player)player, playerData.getEquippedKeychain(parent.form), player.getInventory().getItem(slot), slot, parent.form))).isCanceled()) {
                        if (Utils.findSummoned(player.getInventory(), playerData.getEquippedKeychain(DriveForm.NONE)) > -1) {
                            PacketHandler.sendToServer(new CSSummonKeyblade(true));
                        }
                        PacketHandler.sendToServer(new CSEquipKeychain(parent.form, slot));
                        ItemStack stackToEquip = player.getInventory().getItem(slot);
                        ItemStack stackPreviouslyEquipped = playerData.equipKeychain(parent.form, stackToEquip);
                        player.getInventory().setItem(slot, stackPreviouslyEquipped);
                    }
                } else {
                    Minecraft.getInstance().setScreen((Screen)new MenuEquipmentScreen());
                }
            }
        });
        this.stack = stack;
        this.width = widthIn;
        this.height = 14;
        this.colour = colour;
        this.labelColour = 16771868;
        this.parent = parent;
        this.slot = slot;
        this.minecraft = Minecraft.getInstance();
    }

    public void setWidth(int width) {
        super.setWidth(width);
    }

    public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = gui.pose();
        this.isHovered = mouseX > this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        Color col = Color.decode(String.valueOf(this.colour));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemCategory category = ItemCategory.TOOL;
        KeybladeItem keyblade = ItemStack.matches((ItemStack)this.stack, (ItemStack)ItemStack.EMPTY) || !(this.stack.getItem() instanceof IKeychain) ? null : ((IKeychain)this.stack.getItem()).toSummon();
        if (this.visible) {
            int level;
            List<String> abilities;
            Lighting.setupForFlatItems();
            float itemWidth = (float)this.width * 0.6f;
            matrixStack.pushPose();
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)((float)col.getRed() / 255.0f), (float)((float)col.getGreen() / 255.0f), (float)((float)col.getBlue() / 255.0f), (float)1.0f);
            matrixStack.translate((float)this.getX() + 0.6f, (float)this.getY(), 0.0f);
            matrixStack.scale(0.5f, 0.5f, 1.0f);
            gui.blit(this.texture, 0, 0, 166, 34, 18, 28);
            gui.blit(this.texture, 16, 0, (int)(itemWidth * 2.0f - 34.0f) + 2, 28, 186.0f, 34.0f, 2, 28, 256, 256);
            gui.blit(this.texture, (int)(itemWidth * 2.0f - 17.0f), 0, 186, 34, 17, 28);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.blit(this.texture, 6, 4, category.getU(), category.getV(), 20, 20);
            matrixStack.popPose();
            String itemName = keyblade == null ? "---" : new ItemStack((ItemLike)keyblade).getHoverName().getString();
            gui.drawString(this.minecraft.font, itemName, this.getX() + 15, this.getY() + 3, 0xFFFFFF);
            float labelWidth = (float)this.width * 0.39f;
            matrixStack.pushPose();
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)((float)col.getRed() / 255.0f), (float)((float)col.getGreen() / 255.0f), (float)((float)col.getBlue() / 255.0f), (float)1.0f);
            matrixStack.translate((float)this.getX() + itemWidth + 2.1f, (float)this.getY(), 0.0f);
            matrixStack.scale(0.5f, 0.5f, 1.0f);
            gui.blit(this.texture, 0, 0, 219, 34, 15, 28);
            gui.blit(this.texture, 13, 0, (int)(labelWidth * 2.0f - 31.0f) + 2, 28, 186.0f, 34.0f, 2, 28, 256, 256);
            gui.blit(this.texture, (int)(labelWidth * 2.0f - 17.0f), 0, 186, 34, 17, 28);
            matrixStack.popPose();
            Object ab = "N/A";
            if (keyblade != null && !(abilities = Utils.getKeybladeAbilitiesAtLevel((Item)keyblade, level = keyblade.getKeybladeLevel(this.stack))).isEmpty()) {
                Ability a = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)abilities.get(0)));
                ab = Utils.translateToLocal(a.getTranslationKey(), new Object[0]);
                if (abilities.size() > 1) {
                    ab = (String)ab + " [+" + (abilities.size() - 1) + "]";
                }
            }
            float centerX = labelWidth / 2.0f - (float)(this.minecraft.font.width((String)ab) / 2);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.drawString(this.minecraft.font, (String)ab, (int)((float)this.getX() + itemWidth + centerX + 3.0f), this.getY() + 3, this.labelColour);
            if (this.isButtonRendered(mouseY) && (this.selected || this.isHovered)) {
                matrixStack.pushPose();
                RenderSystem.enableBlend();
                matrixStack.translate((float)this.getX() + 0.6f, (float)this.getY(), 0.0f);
                matrixStack.scale(0.5f, 0.5f, 1.0f);
                gui.blit(this.texture, 0, 0, 128, 34, 18, 28);
                gui.blit(this.texture, 16, 0, (int)(itemWidth * 2.0f - 34.0f) + 2, 28, 148.0f, 34.0f, 2, 28, 256, 256);
                gui.blit(this.texture, (int)(itemWidth * 2.0f - 17.0f), 0, 148, 34, 17, 28);
                RenderSystem.disableBlend();
                matrixStack.popPose();
            }
        }
    }

    public void renderData(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        KeybladeItem keyblade = ItemStack.matches((ItemStack)this.stack, (ItemStack)ItemStack.EMPTY) || !(this.stack.getItem() instanceof IKeychain) ? null : ((IKeychain)this.stack.getItem()).toSummon();
        PoseStack matrixStack = gui.pose();
        Font fr = this.minecraft.font;
        if (this.isButtonRendered(mouseY) && (this.selected || this.isHovered) && keyblade != null) {
            float iconPosX = (float)this.parent.width * 0.69f;
            float iconPosY = (float)this.parent.height * 0.1833f;
            float iconHeight = (float)this.parent.height * 0.3148f;
            Lighting.setupForFlatItems();
            matrixStack.pushPose();
            matrixStack.translate(iconPosX, iconPosY, 0.0f);
            matrixStack.scale(0.0625f * iconHeight, 0.0625f * iconHeight, 1.0f);
            ClientUtils.drawItemAsIcon(new ItemStack((ItemLike)keyblade), matrixStack, 0, 0, 16);
            matrixStack.popPose();
            float strPosX = (float)this.parent.width * 0.685f;
            float strPosY = (float)this.parent.height * 0.5185f;
            float strNumPosX = (float)this.parent.width * 0.78f;
            float magPosY = (float)this.parent.height * 0.5657f;
            float abiPosX = (float)this.parent.width * 0.72f;
            float abiPosY = (float)this.parent.height * 0.62f;
            String strengthStr = String.valueOf(keyblade.getStrength(this.stack));
            String magicStr = String.valueOf(keyblade.getMagic(this.stack));
            PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
            int strength = playerData.getStrength(true) + keyblade.getStrength(this.stack);
            int magic = playerData.getMagic(true) + keyblade.getMagic(this.stack);
            String totalStrengthStr = String.valueOf(strength);
            String totalMagicStr = String.valueOf(magic);
            Object openBracketStr = " [ ";
            Object openBracketMag = " [ ";
            String totalStr = String.valueOf(strength);
            String totalMag = String.valueOf(magic);
            if (totalStr.length() == 1) {
                openBracketStr = (String)openBracketStr + " ";
            }
            if (totalMag.length() == 1) {
                openBracketMag = (String)openBracketMag + " ";
            }
            gui.drawString(fr, Component.translatable((String)"gui.menu.status.strength").getString(), (int)strPosX, (int)strPosY, 15631875);
            gui.drawString(fr, strengthStr, (int)strNumPosX, (int)strPosY, 0xFFFFFF);
            gui.drawString(fr, (String)openBracketStr, (int)strNumPosX + fr.width(strengthStr), (int)strPosY, 12541956);
            gui.drawString(fr, totalStrengthStr, (int)strNumPosX + fr.width(strengthStr) + fr.width((String)openBracketStr), (int)strPosY, 16509473);
            gui.drawString(fr, "]", (int)strNumPosX + fr.width(strengthStr) + fr.width((String)openBracketStr) + fr.width(totalStrengthStr), (int)strPosY, 12541956);
            gui.drawString(fr, Component.translatable((String)"gui.menu.status.magic").getString(), (int)strPosX, (int)magPosY, 15631875);
            gui.drawString(fr, magicStr, (int)strNumPosX, (int)magPosY, 0xFFFFFF);
            gui.drawString(fr, (String)openBracketMag, (int)strNumPosX + fr.width(magicStr), (int)magPosY, 12541956);
            gui.drawString(fr, totalMagicStr, (int)strNumPosX + fr.width(magicStr) + fr.width((String)openBracketMag), (int)magPosY, 16509473);
            gui.drawString(fr, "]", (int)strNumPosX + fr.width(magicStr) + fr.width((String)openBracketMag) + fr.width(totalMagicStr), (int)magPosY, 12541956);
            int level = keyblade.getKeybladeLevel(this.stack);
            List<String> abilities = Utils.getKeybladeAbilitiesAtLevel((Item)keyblade, level);
            if (!abilities.isEmpty()) {
                gui.drawString(fr, String.valueOf(ChatFormatting.UNDERLINE) + Component.translatable((String)"gui.menu.status.abilities").getString(), (int)abiPosX, (int)abiPosY, 15631875);
                for (int i = 0; i < abilities.size(); ++i) {
                    Ability ability = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)abilities.get(i)));
                    gui.blit(this.texture, (int)strPosX - 2, (int)abiPosY + (i + 1) * 12 - 4, 73, 102, 12, 12);
                    gui.drawString(fr, Utils.translateToLocal(ability.getTranslationKey(), new Object[0]), (int)strPosX + 14, (int)abiPosY + (i + 1) * 12 - 1, 0xFFFFFF);
                }
            }
            ClientUtils.drawSplitString(gui, keyblade.getDesc(), (int)MenuBackground.tooltipPosX, (int)MenuBackground.tooltipPosY, (int)((float)this.parent.width * 0.46875f), 4437481);
        }
        Lighting.setupForFlatItems();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isButtonRendered(mouseY)) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean isButtonRendered(double mouseY) {
        return mouseY >= (double)this.parent.scrollBar.getY() && mouseY <= (double)(this.parent.scrollBar.getBottom() + 2);
    }

    public void playDownSound(SoundManager soundHandler) {
        soundHandler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.menu_in.get()), (float)1.0f, (float)1.0f));
    }
}

