/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import online.kingdomkeys.kingdomkeys.api.event.EquipmentEvent;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButtonBase;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.equipment.MenuEquipmentScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.equipment.MenuPotionSelectorScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.KKPotionItem;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSEquipItems;

public class MenuSelectPotionButton
extends MenuButtonBase {
    ItemStack stack;
    boolean selected;
    int colour;
    int labelColour;
    MenuPotionSelectorScreen parent;
    int slot;
    Minecraft minecraft;
    final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");

    public MenuSelectPotionButton(ItemStack stack, int slot, int x, int y, int widthIn, MenuPotionSelectorScreen parent, int colour) {
        super(x, y, widthIn, 20, "", b -> {
            if (b.visible && b.active) {
                if (slot != -1) {
                    LocalPlayer player = Minecraft.getInstance().player;
                    PlayerData playerData = PlayerData.get((Player)player);
                    if (!((EquipmentEvent.Item)NeoForge.EVENT_BUS.post((Event)new EquipmentEvent.Item((Player)player, playerData.getEquippedItem(parent.slot), player.getInventory().getItem(slot), slot, parent.slot))).isCanceled()) {
                        PacketHandler.sendToServer(new CSEquipItems(parent.slot, slot));
                        ItemStack stackToEquip = player.getInventory().getItem(slot);
                        ItemStack stackPreviouslyEquipped = playerData.equipItem(parent.slot, stackToEquip);
                        player.getInventory().setItem(slot, stackPreviouslyEquipped);
                    }
                } else {
                    Minecraft.getInstance().setScreen((Screen)new MenuEquipmentScreen());
                }
            }
        });
        this.stack = stack;
        this.width = widthIn;
        this.height = 14;
        this.colour = colour;
        this.labelColour = 16771868;
        this.parent = parent;
        this.slot = slot;
        this.minecraft = Minecraft.getInstance();
    }

    public void setWidth(int width) {
        super.setWidth(width);
    }

    public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        KKPotionItem potion;
        PoseStack matrixStack = gui.pose();
        Font fr = this.minecraft.font;
        this.isHovered = mouseX > this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        Color col = Color.decode(String.valueOf(this.colour));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemCategory category = ItemCategory.CONSUMABLE;
        KKPotionItem kKPotionItem = potion = ItemStack.matches((ItemStack)this.stack, (ItemStack)ItemStack.EMPTY) || !(this.stack.getItem() instanceof KKPotionItem) ? null : (KKPotionItem)this.stack.getItem();
        if (this.visible) {
            String itemName;
            Lighting.setupForFlatItems();
            matrixStack.pushPose();
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)((float)col.getRed() / 255.0f), (float)((float)col.getGreen() / 255.0f), (float)((float)col.getBlue() / 255.0f), (float)1.0f);
            matrixStack.translate((float)this.getX() + 0.6f, (float)this.getY(), 0.0f);
            matrixStack.scale(0.5f, 0.5f, 1.0f);
            gui.blit(this.texture, 0, 0, 166, 34, 18, 28);
            gui.blit(this.texture, 16, 0, this.width * 2 - 34 + 2, 28, 186.0f, 34.0f, 2, 28, 256, 256);
            gui.blit(this.texture, this.width * 2 - 17, 0, 186, 34, 17, 28);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.blit(this.texture, 6, 4, category.getU(), category.getV(), 20, 20);
            matrixStack.popPose();
            if (potion == null) {
                itemName = "---";
            } else {
                itemName = this.stack.getHoverName().getString();
                String amount = "x" + String.valueOf(this.parent.addedItemsList.get(this.stack.getItem()));
                gui.drawString(this.minecraft.font, String.valueOf(ChatFormatting.YELLOW) + amount, this.getX() + this.width - this.minecraft.font.width(amount) - 3, this.getY() + 3, 0xFFFFFF);
            }
            gui.drawString(this.minecraft.font, itemName, this.getX() + 15, this.getY() + 3, 0xFFFFFF);
            if (this.isButtonRendered(mouseY) && (this.selected || this.isHovered)) {
                matrixStack.pushPose();
                RenderSystem.enableBlend();
                matrixStack.translate((float)this.getX() + 0.6f, (float)this.getY(), 0.0f);
                matrixStack.scale(0.5f, 0.5f, 1.0f);
                gui.blit(this.texture, 0, 0, 128, 34, 18, 28);
                gui.blit(this.texture, 16, 0, this.width * 2 - 34 + 2, 28, 148.0f, 34.0f, 2, 28, 256, 256);
                gui.blit(this.texture, this.width * 2 - 17, 0, 148, 34, 17, 28);
                matrixStack.popPose();
                if (potion != null) {
                    float iconPosX = (float)this.parent.width * 0.565f;
                    float iconPosY = (float)this.parent.height * 0.2f;
                    float iconHeight = (float)this.parent.height * 0.3148f;
                    Lighting.setupForFlatItems();
                    matrixStack.pushPose();
                    matrixStack.translate(iconPosX, iconPosY, 0.0f);
                    matrixStack.scale(0.0625f * iconHeight, 0.0625f * iconHeight, 1.0f);
                    ClientUtils.drawItemAsIcon(this.stack, matrixStack, 0, 0, 16);
                    matrixStack.popPose();
                    ClientUtils.drawSplitString(gui, ((Component)this.stack.getTooltipLines(Item.TooltipContext.of((Level)this.minecraft.level), (Player)this.minecraft.player, (TooltipFlag)TooltipFlag.Default.NORMAL).get(1)).getString(), (int)MenuBackground.tooltipPosX, (int)MenuBackground.tooltipPosY, (int)((float)this.parent.width * 0.46875f), 4437481);
                }
            }
            Lighting.setupForFlatItems();
        }
    }

    public void renderData(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        KKPotionItem potion = ItemStack.matches((ItemStack)this.stack, (ItemStack)ItemStack.EMPTY) || !(this.stack.getItem() instanceof KKPotionItem) ? null : (KKPotionItem)this.stack.getItem();
        PoseStack matrixStack = gui.pose();
        if (this.isButtonRendered(mouseY) && (this.selected || this.isHovered) && potion != null) {
            float iconPosX = (float)this.parent.width * 0.565f;
            float iconPosY = (float)this.parent.height * 0.2f;
            float iconHeight = (float)this.parent.height * 0.3148f;
            Lighting.setupForFlatItems();
            matrixStack.pushPose();
            matrixStack.translate(iconPosX, iconPosY, 0.0f);
            matrixStack.scale(0.0625f * iconHeight, 0.0625f * iconHeight, 1.0f);
            ClientUtils.drawItemAsIcon(this.stack, matrixStack, 0, 0, 16);
            matrixStack.popPose();
            ClientUtils.drawSplitString(gui, ((Component)this.stack.getTooltipLines(Item.TooltipContext.of((Level)this.minecraft.level), (Player)this.minecraft.player, (TooltipFlag)TooltipFlag.Default.NORMAL).get(1)).getString(), (int)MenuBackground.tooltipPosX, (int)MenuBackground.tooltipPosY, (int)((float)this.parent.width * 0.46875f), 4437481);
        }
    }

    public boolean isButtonRendered(double mouseY) {
        return mouseY >= (double)this.parent.scrollBar.getY() && mouseY <= (double)(this.parent.scrollBar.getBottom() + 2);
    }

    public void playDownSound(SoundManager soundHandler) {
        soundHandler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.menu_in.get()), (float)1.0f, (float)1.0f));
    }
}

