/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterable;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.ShopScreen;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisCreateScreen;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisForgeScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopItem;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopList;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MenuStockItem
extends Button {
    MenuFilterable parent;
    ResourceLocation rl;
    ItemStack stack;
    boolean selected;
    boolean showAmount;
    String customName = null;
    public int offsetY;
    public Color backgroundColor;
    final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");

    public MenuStockItem(MenuFilterable parent, ResourceLocation rl, ItemStack displayStack, int x, int y, int width, boolean showAmount) {
        super(new Button.Builder((Component)Component.literal((String)""), b -> parent.action(rl, displayStack)).bounds(x, y, width, 14));
        this.parent = parent;
        this.rl = rl;
        this.showAmount = showAmount;
        this.stack = displayStack;
    }

    public MenuStockItem(MenuFilterable parent, ItemStack stack, int x, int y, int width, boolean showAmount) {
        super(new Button.Builder((Component)Component.literal((String)""), b -> parent.action(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()), stack)).bounds(x, y, width, 14));
        this.parent = parent;
        this.rl = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        this.stack = stack;
        this.showAmount = showAmount;
    }

    public MenuStockItem(MenuFilterable parent, ResourceLocation rl, ItemStack displayStack, int x, int y, int width, boolean showAmount, String customName) {
        this(parent, rl, displayStack, x, y, width, showAmount);
        this.customName = customName;
    }

    public MenuStockItem(MenuFilterable parent, ItemStack stack, int x, int y, int width, boolean showAmount, String customName) {
        this(parent, stack, x, y, width, showAmount);
        this.customName = customName;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getY() {
        return super.getY() - this.offsetY;
    }

    public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = gui.pose();
        this.isHovered = mouseX > this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.visible) {
            Set<String> recipeList;
            Object item;
            Minecraft mc = Minecraft.getInstance();
            if (this.parent.selectedItemStack == null) {
                this.parent.selectedItemStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(this.parent.selectedRL));
            }
            if (this.isHovered || this.parent.selectedItemStack == this.stack) {
                matrixStack.pushPose();
                RenderSystem.enableBlend();
                matrixStack.translate((float)this.getX() + 0.6f, (float)this.getY(), 0.0f);
                scale = 0.5f;
                matrixStack.scale(scale, scale, 1.0f);
                gui.blit(this.texture, 0, 0, 27, 0, 18, 28);
                gui.blit(this.texture, 16, 0, (int)((float)this.width * (1.0f / scale) - 17.0f * (1.0f / scale)) + 1, 28, 47.0f, 0.0f, 2, 28, 256, 256);
                gui.blit(this.texture, (int)((float)this.width * (1.0f / scale)) - 18, 0, 49, 0, 17, 28);
                matrixStack.popPose();
            } else if (this.getBackgroundColor() != null) {
                matrixStack.pushPose();
                RenderSystem.enableBlend();
                matrixStack.translate((float)this.getX() + 0.6f, (float)this.getY(), 0.0f);
                scale = 0.5f;
                matrixStack.scale(scale, scale, 1.0f);
                RenderSystem.setShaderColor((float)((float)this.getBackgroundColor().getRed() / 255.0f), (float)((float)this.getBackgroundColor().getGreen() / 255.0f), (float)((float)this.getBackgroundColor().getBlue() / 255.0f), (float)1.0f);
                gui.blit(this.texture, 0, 0, 219, 0, 18, 28);
                gui.blit(this.texture, 16, 0, (int)((float)this.width * (1.0f / scale) - 17.0f * (1.0f / scale)) + 1, 28, 239.0f, 0.0f, 2, 28, 256, 256);
                gui.blit(this.texture, (int)((float)this.width * (1.0f / scale)) - 18, 0, 239, 0, 17, 28);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                matrixStack.popPose();
            }
            ItemCategory category = Utils.getCategoryForStack(this.stack);
            matrixStack.pushPose();
            matrixStack.translate((float)(this.getX() + 3), (float)(this.getY() + 2), 0.0f);
            float scale = 0.5f;
            int categorySize = 20;
            matrixStack.scale(scale, scale, 1.0f);
            gui.blit(this.texture, 0, 0, category.getU(), category.getV(), categorySize, categorySize);
            matrixStack.popPose();
            ChatFormatting color = ChatFormatting.WHITE;
            PlayerData playerData = PlayerData.get((Player)mc.player);
            boolean displayTick = false;
            if (this.parent instanceof SynthesisCreateScreen) {
                Recipe recipe;
                displayTick = true;
                color = ChatFormatting.DARK_GRAY;
                if (RecipeRegistry.getInstance().containsKey(this.rl) && ((recipe = RecipeRegistry.getInstance().getValue(this.rl)).getTier() <= playerData.getSynthLevel() || !((Boolean)ModConfigs.SERVER.requireSynthTier.get()).booleanValue()) && playerData.getMunny() >= recipe.getCost()) {
                    color = ChatFormatting.WHITE;
                    for (Map.Entry entry : recipe.getMaterials().entrySet()) {
                        if (playerData.getMaterialAmount((Item)entry.getKey()) >= (Integer)entry.getValue()) continue;
                        color = ChatFormatting.DARK_GRAY;
                    }
                }
            }
            if (this.parent instanceof SynthesisForgeScreen) {
                displayTick = true;
                color = ChatFormatting.DARK_GRAY;
                Item item2 = this.stack.getItem();
                if (item2 instanceof KeychainItem) {
                    KeychainItem kcItem = (KeychainItem)item2;
                    item = kcItem.getKeyblade();
                    if (((KeybladeItem)item).getKeybladeLevel(this.stack) >= ((KeybladeItem)item).getMaxLevel()) {
                        color = ChatFormatting.GOLD;
                    } else {
                        Iterator<Map.Entry<Item, Integer>> iterator = ((KeybladeItem)item).data.getLevelData(((KeybladeItem)item).getKeybladeLevel(this.stack)).getMaterialList().entrySet().iterator();
                        color = ChatFormatting.WHITE;
                        while (iterator.hasNext()) {
                            Map.Entry<Item, Integer> m = iterator.next();
                            if (playerData.getMaterialAmount(m.getKey()) >= m.getValue()) continue;
                            color = ChatFormatting.DARK_GRAY;
                        }
                    }
                }
            }
            if ((item = this.parent) instanceof ShopScreen) {
                ShopScreen shop = (ShopScreen)((Object)item);
                displayTick = true;
                ShopList shopList = shop.getShopList();
                for (ShopItem item3 : shopList.getList()) {
                    if (!this.rl.equals((Object)Utils.getItemRegistryName(item3.getResult()))) continue;
                    color = item3.getCost() > playerData.getMunny() ? ChatFormatting.DARK_GRAY : ChatFormatting.WHITE;
                    break;
                }
            }
            int rightMargin = 5;
            if (this.showAmount) {
                String count = Component.translatable((String)"x%s ", (Object[])new Object[]{this.stack.getCount()}).getString();
                gui.drawString(mc.font, count, this.getX() + this.width - mc.font.width(count), this.getY() + 3, 16316177);
                rightMargin += mc.font.width(count);
            }
            ClientUtils.drawScrollingString(gui, mc.font, (Component)Component.literal((String)(String.valueOf(color) + (this.customName == null ? this.stack.getHoverName().getString() : this.customName))), this.getX() + 15, this.getX() + this.width - rightMargin, this.getY() + 3, 0xFFFFFF, false);
            if (displayTick && (recipeList = PlayerData.get((Player)mc.player).getSynthesisedRecipes()).contains(this.rl.toString())) {
                gui.drawString(mc.font, "\u2714", (int)((double)this.getWidth() * 1.49), this.getY() + 3, 65280);
            }
        }
    }

    public void playDownSound(SoundManager soundHandler) {
        soundHandler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.menu_select.get()), (float)1.0f, (float)1.0f));
    }
}

