/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import java.awt.Color;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import online.kingdomkeys.kingdomkeys.client.gui.SavePointScreen;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.ScrollableButtonBase;
import online.kingdomkeys.kingdomkeys.entity.block.SavepointTileEntity;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.SavePointStorage;

public class SavePointButton
extends ScrollableButtonBase {
    SavePointScreen parent;
    UUID destination;

    public SavePointButton(SavePointScreen parent, int pX, int pY, int pWidth, int pHeight, Component pMessage, UUID destination) {
        super(new Button.Builder(pMessage, pButton -> parent.clickSavePoint(destination)).bounds(pX, pY, pWidth, pHeight));
        this.parent = parent;
        this.destination = destination;
    }

    public UUID getDestination() {
        return this.destination;
    }

    protected void renderWidget(GuiGraphics gui, int pMouseX, int pMouseY, float pPartialTick) {
        this.isHovered = this.isMouseOver(pMouseX, pMouseY);
        Objects.requireNonNull(Minecraft.getInstance().font);
        int labelHeight = 9 + 2;
        if (this.visible) {
            SavePointScreen.Screenshot screenshot;
            if (!this.active || this.isHovered) {
                gui.fill(this.getX() - 1, this.getY() - 1, this.getX() + this.getWidth() + 1, this.getY() + this.getHeight() + 1, Color.GREEN.getRGB());
            } else {
                gui.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), Color.GREEN.getRGB());
            }
            if (!this.parent.savePointScreenshots.isEmpty() && (screenshot = this.parent.savePointScreenshots.get(this.destination)) != null && screenshot.textureLocation() != null) {
                gui.blit(screenshot.textureLocation(), this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
            }
            if (this.isHovered) {
                SavePointStorage.SavePoint sPoint = (SavePointStorage.SavePoint)this.parent.savePoints.get(this.destination).getFirst();
                if (sPoint == null) {
                    return;
                }
                BlockEntity blockEntity = Minecraft.getInstance().level.getBlockEntity(sPoint.pos());
                if (blockEntity instanceof SavepointTileEntity) {
                    SavepointTileEntity savepoint = (SavepointTileEntity)blockEntity;
                    Tooltip tooltip = Tooltip.create((Component)Component.literal((String)("UUID: " + String.valueOf(savepoint.getID()) + "\nDimension: " + String.valueOf(sPoint.dimension().location()) + "\nOwner: " + (String)sPoint.owner().getSecond() + "\nHealing: " + Utils.getSavepointPercent(savepoint.getHeal()) + "%\nFood: " + Utils.getSavepointPercent(savepoint.getHunger()) + "%\nMagic: " + Utils.getSavepointPercent(savepoint.getMagic()) + "%\nFocus: " + Utils.getSavepointPercent(savepoint.getFocus()) + "%\nDrive: " + Utils.getSavepointPercent(savepoint.getDrive()) + "%")));
                    this.setTooltip(tooltip);
                }
                this.drawLabel(this.getMessage(), gui, labelHeight);
            }
            if (this.parent.hovered == null || !this.parent.hovered.equals(this.destination)) {
                this.drawDark(gui, Color.BLACK);
            }
        }
        if (!this.active) {
            this.drawLabel((Component)Component.translatable((String)"gui.save.main.here"), gui, labelHeight);
        }
    }

    public void drawDark(GuiGraphics gui, Color colour) {
        gui.setColor(1.0f, 1.0f, 1.0f, 0.4f);
        gui.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), colour.getRGB());
        gui.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void drawLabel(Component text, GuiGraphics gui, int labelHeight) {
        gui.setColor(1.0f, 1.0f, 1.0f, 0.5f);
        gui.fill(this.getX(), this.getY() + (this.getHeight() - labelHeight), this.getX() + this.getWidth(), this.getY() + this.getHeight(), Color.BLACK.getRGB());
        gui.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (Minecraft.getInstance().font.width(this.getMessage().getVisualOrderText()) > this.getWidth()) {
            gui.enableScissor(this.getX(), this.getY() + (this.getHeight() - labelHeight), this.getX() + this.getWidth(), this.getY() + this.getHeight());
            gui.drawString(Minecraft.getInstance().font, text, this.getX() + 1, this.getY() + (this.getHeight() - labelHeight) + 1, Color.WHITE.getRGB());
            gui.disableScissor();
        } else {
            gui.drawCenteredString(Minecraft.getInstance().font, text, this.getX() + this.getWidth() / 2, this.getY() + (this.getHeight() - labelHeight) + 1, Color.WHITE.getRGB());
        }
    }

    public boolean isMouseOverInactive(double pMouseX, double pMouseY) {
        return !this.active && this.visible && pMouseX >= (double)this.getX() && pMouseY >= (double)this.getY() && pMouseX < (double)(this.getX() + this.width) && pMouseY < (double)(this.getY() + this.height);
    }

    public boolean isMouseOver(double pMouseX, double pMouseY) {
        boolean hovered = super.isMouseOver(pMouseX, pMouseY);
        if (hovered) {
            this.parent.hovered = this.destination;
        } else if (this.parent.hovered != null && this.parent.hovered.equals(this.destination)) {
            this.parent.hovered = null;
        }
        return hovered;
    }
}

