/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.ScrollableButtonBase;

public class SavePointExtrasButton
extends ScrollableButtonBase {
    public SavePointExtrasButton(int pX, int pY, int pWidth, Component pMessage, Button.OnPress pOnPress) {
        Button.Builder builder = new Button.Builder(pMessage, pOnPress);
        Objects.requireNonNull(Minecraft.getInstance().font);
        super(builder.bounds(pX, pY, pWidth, 9 + 2));
    }

    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.isHovered = this.isMouseOver(pMouseX, pMouseY);
        this.drawLabel(this.getMessage(), pGuiGraphics);
    }

    public void drawLabel(Component text, GuiGraphics gui) {
        gui.pose().pushPose();
        gui.pose().translate(0.0f, 0.0f, 1.0f);
        gui.setColor(1.0f, 1.0f, 1.0f, 0.25f);
        int colour = Color.BLACK.getRGB();
        if (this.isHovered) {
            colour = Color.LIGHT_GRAY.getRGB();
        }
        gui.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), colour);
        gui.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (Minecraft.getInstance().font.width(this.getMessage().getVisualOrderText()) > this.getWidth()) {
            gui.enableScissor(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight());
            gui.drawString(Minecraft.getInstance().font, text, this.getX() + 1, this.getY() + 1, Color.WHITE.getRGB());
            gui.disableScissor();
        } else {
            gui.drawCenteredString(Minecraft.getInstance().font, text, this.getX() + this.getWidth() / 2, this.getY() + 1, Color.WHITE.getRGB());
        }
        gui.pose().popPose();
    }
}

