/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.menu.abilities.MenuAbilitiesScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.config.MenuConfigScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.customize.MenuCustomizeScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.MenuItemsScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.journal.MenuJournalScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Leader;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Member;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_None;
import online.kingdomkeys.kingdomkeys.client.gui.menu.status.MenuStatusScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.styles.StylesMenu;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class MenuScreen
extends MenuBackground {
    PlayerData playerData;
    MenuButton items;
    MenuButton abilities;
    MenuButton customize;
    MenuButton party;
    MenuButton status;
    MenuButton journal;
    MenuButton config;
    MenuButton style;
    final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");

    public MenuScreen(PlayerData playerData) {
        super("gui.menu.main.title", new Color(0, 0, 255));
        this.minecraft = Minecraft.getInstance();
        this.playerData = playerData;
    }

    protected void action(buttons buttonID) {
        switch (buttonID.ordinal()) {
            case 0: {
                this.minecraft.setScreen((Screen)new MenuItemsScreen());
                break;
            }
            case 1: {
                this.minecraft.setScreen((Screen)new MenuAbilitiesScreen());
                break;
            }
            case 3: {
                Party p = WorldData.getClient().getPartyFromMember(this.minecraft.player.getUUID());
                if (p == null) {
                    this.minecraft.setScreen((Screen)new GuiMenu_Party_None());
                    break;
                }
                boolean isLeader = false;
                for (Party.Member leader : p.getLeaders()) {
                    if (!leader.getUUID().equals(this.minecraft.player.getUUID())) continue;
                    isLeader = true;
                    break;
                }
                if (isLeader) {
                    this.minecraft.setScreen((Screen)new GuiMenu_Party_Leader());
                    break;
                }
                this.minecraft.setScreen((Screen)new GuiMenu_Party_Member());
                break;
            }
            case 4: {
                this.minecraft.setScreen((Screen)new MenuStatusScreen());
                break;
            }
            case 2: {
                this.minecraft.setScreen((Screen)new MenuCustomizeScreen());
                break;
            }
            case 5: {
                this.minecraft.setScreen((Screen)new MenuJournalScreen());
                break;
            }
            case 6: {
                this.minecraft.setScreen((Screen)new MenuConfigScreen());
                break;
            }
            case 7: {
                this.minecraft.setScreen((Screen)new StylesMenu());
            }
        }
        this.updateButtons();
    }

    @Override
    public void init() {
        this.width = this.width;
        this.height = this.height;
        super.init();
        float topBarHeight = (float)this.height * 0.17f;
        int start = (int)topBarHeight + 5;
        int pos = 0;
        float buttonPosX = (float)this.width * 0.03f;
        float buttonWidth = (float)this.width * 0.1744f - 22.0f;
        this.items = new MenuButton((int)buttonPosX, start, (int)buttonWidth, "gui.menu.main.button.items", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.ITEMS));
        this.addRenderableWidget((GuiEventListener)this.items);
        this.abilities = new MenuButton((int)buttonPosX, start + 18 * ++pos, (int)buttonWidth, "gui.menu.main.button.abilities", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.ABILITIES));
        this.addRenderableWidget((GuiEventListener)this.abilities);
        this.customize = new MenuButton((int)buttonPosX, start + 18 * ++pos, (int)buttonWidth, "gui.menu.main.button.customize", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.CUSTOMIZE));
        this.addRenderableWidget((GuiEventListener)this.customize);
        this.party = new MenuButton((int)buttonPosX, start + 18 * ++pos, (int)buttonWidth, "gui.menu.main.button.party", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.PARTY));
        this.addRenderableWidget((GuiEventListener)this.party);
        this.status = new MenuButton((int)buttonPosX, start + 18 * ++pos, (int)buttonWidth, "gui.menu.main.button.status", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.STATUS));
        this.addRenderableWidget((GuiEventListener)this.status);
        this.journal = new MenuButton((int)buttonPosX, start + 18 * ++pos, (int)buttonWidth, "gui.menu.main.button.journal", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.JOURNAL));
        this.addRenderableWidget((GuiEventListener)this.journal);
        if (KingdomKeys.efmLoaded) {
            this.style = new MenuButton((int)buttonPosX, start + 18 * ++pos, (int)buttonWidth, "gui.menu.main.button.style", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.STYLES));
            this.addRenderableWidget((GuiEventListener)this.style);
        }
        this.config = new MenuButton((int)buttonPosX, start + 18 * ++pos, (int)buttonWidth, "gui.menu.main.button.config", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.CONFIG));
        this.addRenderableWidget((GuiEventListener)this.config);
        this.updateButtons();
    }

    private void updateButtons() {
        this.items.visible = true;
        this.abilities.visible = true;
        this.customize.visible = true;
        this.party.visible = true;
        this.status.visible = true;
        this.journal.visible = true;
        this.config.visible = true;
        if (KingdomKeys.efmLoaded) {
            this.style.visible = true;
        }
        this.customize.active = true;
        this.journal.active = true;
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.render(gui, mouseX, mouseY, partialTicks);
        this.drawPlayer(gui);
    }

    public void drawPlayer(GuiGraphics gui) {
        PoseStack matrixStack = gui.pose();
        float playerHeight = (float)this.height * 0.45f;
        float playerPosX = (float)this.width * 0.5229f;
        float playerPosY = (float)this.height * 0.7f;
        if (this.playerData != null) {
            int i;
            matrixStack.pushPose();
            LocalPlayer player = this.minecraft.player;
            ClientUtils.renderPlayerNoAnims(matrixStack, (int)playerPosX, (int)playerPosY, (int)playerHeight / 2, 0.0f, 0.0f, (LivingEntity)player);
            matrixStack.popPose();
            matrixStack.pushPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.translate(1.0f, 1.0f, 100.0f);
            RenderSystem.enableBlend();
            int infoBoxWidth = (int)((float)this.width * 0.1385f - 14.0f);
            int infoBoxPosX = (int)((float)this.width * 0.4354f);
            int infoBoxPosY = (int)((float)this.height * 0.54f);
            gui.blit(this.texture, infoBoxPosX, infoBoxPosY, 123, 67, 11, 22);
            for (i = 0; i < infoBoxWidth; ++i) {
                gui.blit(this.texture, infoBoxPosX + 11 + i, infoBoxPosY, 135, 67, 1, 22);
            }
            gui.blit(this.texture, infoBoxPosX + 11 + infoBoxWidth, infoBoxPosY, 137, 67, 3, 22);
            gui.blit(this.texture, infoBoxPosX, infoBoxPosY + 22, 123, 90, 3, 35);
            for (i = 0; i < infoBoxWidth + 8; ++i) {
                gui.blit(this.texture, infoBoxPosX + 3 + i, infoBoxPosY + 22, 127, 90, 1, 35);
            }
            gui.blit(this.texture, infoBoxPosX + 3 + infoBoxWidth + 8, infoBoxPosY + 22, 129, 90, 3, 35);
            RenderSystem.disableBlend();
            matrixStack.popPose();
            matrixStack.pushPose();
            matrixStack.translate(2.0f, 2.0f, 100.0f);
            matrixStack.pushPose();
            float f = infoBoxPosX + 8;
            Objects.requireNonNull(this.minecraft.font);
            matrixStack.translate(f, (float)(infoBoxPosY + (11 - 9 / 2)), 1.0f);
            gui.drawString(this.minecraft.font, this.minecraft.player.getDisplayName().getString(), 0, 0, 0xFFFFFF);
            matrixStack.popPose();
            gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.status.level", new Object[0]) + ": " + this.playerData.getLevel(), infoBoxPosX + 4, infoBoxPosY + 26, 16767232);
            Font font = this.minecraft.font;
            String string = Utils.translateToLocal("gui.menu.status.hp", new Object[0]) + ": " + (int)this.minecraft.player.getHealth() + "/" + (int)this.minecraft.player.getMaxHealth();
            Objects.requireNonNull(this.minecraft.font);
            gui.drawString(font, string, infoBoxPosX + 4, infoBoxPosY + 26 + 9, 65280);
            Font font2 = this.minecraft.font;
            String string2 = Utils.translateToLocal("gui.menu.status.mp", new Object[0]) + ": " + (int)this.playerData.getMP() + "/" + (int)this.playerData.getMaxMP();
            Objects.requireNonNull(this.minecraft.font);
            gui.drawString(font2, string2, infoBoxPosX + 4, infoBoxPosY + 26 + 9 * 2, 0x4444FF);
            matrixStack.popPose();
        }
    }

    public static enum buttons {
        ITEMS,
        ABILITIES,
        CUSTOMIZE,
        PARTY,
        STATUS,
        JOURNAL,
        CONFIG,
        STYLES;

    }
}

