/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.abilities;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.api.event.AbilityEvent;
import online.kingdomkeys.kingdomkeys.api.item.IKeychain;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuAbilitiesButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.client.gui.menu.MenuScreen;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSOpenMenu;
import online.kingdomkeys.kingdomkeys.network.cts.CSSetEquippedAbilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class MenuAbilitiesScreen
extends MenuBackground {
    String form = DriveForm.NONE.toString();
    PlayerData playerData;
    LinkedHashMap<String, int[]> abilitiesMap;
    List<MenuAbilitiesButton> abilities;
    MenuBox box;
    MenuButton back;
    MenuButton playerButton;
    List<MenuButton> driveSelector;
    int page;
    int itemsPerPage;
    Ability hoveredAbility;
    int hoveredIndex;
    Ability.AbilityType hoveredType;
    MenuScrollBar scrollBar;
    final ResourceLocation texture;
    int scrollTop;
    int scrollBot;

    public MenuAbilitiesScreen() {
        super("gui.menu.main.button.abilities", new Color(0, 0, 255));
        this.playerData = PlayerData.get((Player)this.minecraft.player);
        this.abilities = new ArrayList<MenuAbilitiesButton>();
        this.driveSelector = new ArrayList<MenuButton>();
        this.page = 0;
        this.texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.scrollBar.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        return false;
    }

    protected void action(String string) {
        switch (string) {
            case "back": {
                Minecraft.getInstance().setScreen((Screen)new MenuScreen(this.playerData));
                break;
            }
            default: {
                this.form = string;
                this.init();
            }
        }
        this.updateButtons();
    }

    private void action(Ability ability, int index) {
        String abilityName = ability.getRegistryName().toString();
        int apCost = ((Ability)ModAbilities.registry.get(ResourceLocation.parse((String)abilityName))).getAPCost();
        if (!this.playerData.isAbilityEquipped(abilityName, index) && Utils.getConsumedAP(this.playerData) + apCost > this.playerData.getMaxAP(true)) {
            return;
        }
        boolean cancelled = this.playerData.isAbilityEquipped(abilityName, index) ? ((AbilityEvent.Unequip)NeoForge.EVENT_BUS.post((Event)new AbilityEvent.Unequip((Ability)ModAbilities.registry.get(ResourceLocation.parse((String)abilityName)), index, (Player)Minecraft.getInstance().player, true))).isCanceled() : ((AbilityEvent.Equip)NeoForge.EVENT_BUS.post((Event)new AbilityEvent.Equip((Ability)ModAbilities.registry.get(ResourceLocation.parse((String)abilityName)), index, (Player)Minecraft.getInstance().player, true))).isCanceled();
        if (!cancelled) {
            this.playerData.equipAbilityToggle(abilityName, index);
            PacketHandler.sendToServer(new CSSetEquippedAbilityPacket(abilityName, index));
        }
        this.updateButtons();
    }

    private void updateButtons() {
        for (MenuAbilitiesButton button : this.abilities) {
            button.active = true;
        }
        this.playerButton.active = !this.form.equals(DriveForm.NONE.toString());
        for (MenuButton menuButton : this.driveSelector) {
            menuButton.active = !this.form.equals(menuButton.getData()) && this.playerData.getDriveFormMap().containsKey(menuButton.getData());
            menuButton.setSelected(!menuButton.active);
        }
    }

    @Override
    public void init() {
        this.width = this.width;
        this.height = this.height;
        super.init();
        this.renderables.clear();
        this.children().clear();
        this.abilities.clear();
        float boxPosX = (float)this.width * 0.2f;
        float boxWidth = (float)this.width * 0.5f;
        this.box = new MenuBox((int)boxPosX, (int)this.topBarHeight, (int)boxWidth, (int)this.middleHeight, 0.6f, new Color(4, 4, 68));
        int buttonPosX = (int)(boxPosX * 1.3f);
        int buttonPosY = (int)this.topBarHeight + 5;
        int buttonWidth = (int)(boxWidth * 0.46f);
        this.scrollTop = (int)this.topBarHeight;
        this.scrollBot = (int)((float)this.scrollTop + this.middleHeight);
        this.abilitiesMap = Utils.getSortedAbilities(this.playerData.getAbilityMap());
        if (this.form.equals(DriveForm.NONE.toString())) {
            List<String> abilitiesList;
            int i = 0;
            for (i = 0; i < this.abilitiesMap.size(); ++i) {
                String abilityName = (String)this.abilitiesMap.keySet().toArray()[i];
                Ability ability = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)abilityName));
                int n = this.abilitiesMap.get(abilityName)[0];
                if (n == 0 || ability.getType() == Ability.AbilityType.GROWTH) {
                    this.abilities.add(new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, abilityName, ability.getType(), e -> this.action((Ability)((Object)ability), 0)));
                } else {
                    int j = 0;
                    while (j < n) {
                        int finalJ = j++;
                        this.abilities.add(new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, abilityName, finalJ, ability.getType(), e -> this.action((Ability)((Object)ability), finalJ)));
                    }
                }
                this.abilities.get((int)i).visible = false;
            }
            if (this.playerData.getAlignment() == Utils.OrgMember.NONE) {
                if (!ItemStack.matches((ItemStack)this.playerData.getEquippedKeychain(DriveForm.NONE), (ItemStack)ItemStack.EMPTY)) {
                    abilitiesList = Utils.getKeybladeAbilitiesAtLevel(this.playerData.getEquippedKeychain(DriveForm.NONE).getItem(), ((IKeychain)this.playerData.getEquippedKeychain(DriveForm.NONE).getItem()).toSummon().getKeybladeLevel(this.playerData.getEquippedKeychain(DriveForm.NONE)));
                    for (String string : abilitiesList) {
                        Ability ability = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)string));
                        if (ability == null) continue;
                        MenuAbilitiesButton aa = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, ability.getRegistryName().toString(), Ability.AbilityType.WEAPON, e -> {});
                        this.abilities.add(aa);
                        aa.visible = false;
                    }
                }
            } else if (!ItemStack.matches((ItemStack)this.playerData.getEquippedWeapon(), (ItemStack)ItemStack.EMPTY)) {
                abilitiesList = this.playerData.getAlignment() == Utils.OrgMember.ROXAS ? Utils.getKeybladeAbilitiesAtLevel(this.playerData.getEquippedWeapon().getItem(), 0) : Utils.getOrgWeaponAbilities(this.playerData.getEquippedWeapon().getItem());
                for (String string : abilitiesList) {
                    Ability ability = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)string));
                    if (ability == null) continue;
                    MenuAbilitiesButton aa = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, ability.getRegistryName().toString(), Ability.AbilityType.WEAPON, e -> {});
                    this.abilities.add(aa);
                    aa.visible = false;
                    if (!this.playerData.getAbilityMap().containsKey("kingdomkeys:ability_synch_blade") || this.playerData.getAbilityMap().get("kingdomkeys:ability_synch_blade")[1] <= 0) continue;
                    MenuAbilitiesButton aaa = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, ability.getRegistryName().toString(), Ability.AbilityType.WEAPON, e -> {});
                    this.abilities.add(aaa);
                    aaa.visible = false;
                }
            }
            if (this.playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                if (this.playerData.getAbilityMap().containsKey("kingdomkeys:ability_synch_blade") && this.playerData.getAbilityMap().get("kingdomkeys:ability_synch_blade")[1] > 0 && !ItemStack.matches((ItemStack)this.playerData.getEquippedKeychain(DriveForm.SYNCH_BLADE), (ItemStack)ItemStack.EMPTY)) {
                    abilitiesList = Utils.getKeybladeAbilitiesAtLevel(this.playerData.getEquippedKeychain(DriveForm.SYNCH_BLADE).getItem(), ((IKeychain)this.playerData.getEquippedKeychain(DriveForm.SYNCH_BLADE).getItem()).toSummon().getKeybladeLevel(this.playerData.getEquippedKeychain(DriveForm.SYNCH_BLADE)));
                    for (String string : abilitiesList) {
                        Ability ability = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)string));
                        if (ability == null) continue;
                        MenuAbilitiesButton aa = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, ability.getRegistryName().toString(), Ability.AbilityType.WEAPON, e -> {});
                        this.abilities.add(aa);
                        aa.visible = false;
                    }
                }
            } else if (ModDriveForms.registry.containsKey(ResourceLocation.parse((String)this.playerData.getActiveDriveForm())) && ((DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)this.playerData.getActiveDriveForm()))).hasKeychain() && this.playerData.getDriveFormMap().containsKey(this.playerData.getActiveDriveForm()) && this.playerData.getEquippedKeychains().containsKey(ResourceLocation.parse((String)this.playerData.getActiveDriveForm())) && !ItemStack.matches((ItemStack)this.playerData.getEquippedKeychain(ResourceLocation.parse((String)this.playerData.getActiveDriveForm())), (ItemStack)ItemStack.EMPTY)) {
                ItemStack itemStack = this.playerData.getEquippedKeychain(ResourceLocation.parse((String)this.playerData.getActiveDriveForm()));
                List<String> list = Utils.getKeybladeAbilitiesAtLevel(itemStack.getItem(), ((IKeychain)itemStack.getItem()).toSummon().getKeybladeLevel(itemStack));
                for (String a : list) {
                    Ability ability = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)a));
                    if (ability == null) continue;
                    aa = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, ability.getRegistryName().toString(), Ability.AbilityType.WEAPON, e -> {});
                    this.abilities.add(aa);
                    aa.visible = false;
                }
            }
            abilitiesList = Utils.getAccessoriesAbilities(this.playerData);
            for (String string : abilitiesList) {
                Ability ability = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)string));
                if (ability == null) continue;
                MenuAbilitiesButton aa = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, ability.getRegistryName().toString(), Ability.AbilityType.ACCESSORY, e -> {});
                this.abilities.add(aa);
                aa.visible = false;
            }
        } else {
            ItemStack itemStack;
            String growth;
            Ability ability;
            MenuAbilitiesButton aa;
            DriveForm driveForm = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)this.form));
            if (driveForm.getBaseGrowthAbilities()) {
                for (int i = 0; i < this.abilitiesMap.size(); ++i) {
                    String string = (String)this.abilitiesMap.keySet().toArray()[i];
                    Ability ability2 = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)string));
                    int level = this.abilitiesMap.get(string)[0];
                    if (level != 0 && ability2.getType() != Ability.AbilityType.GROWTH) continue;
                    aa = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, string, ability2.getType(), e -> {});
                    this.abilities.add(aa);
                    aa.visible = false;
                    aa.isVisual = true;
                }
            } else if (driveForm.getDriveFormData().getDFLevelUpAbilities() != null && (ability = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)(growth = driveForm.getDFAbilityForLevel(1))))) != null) {
                MenuAbilitiesButton menuAbilitiesButton = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, growth, ability.getType(), e -> {});
                this.abilities.add(menuAbilitiesButton);
                menuAbilitiesButton.visible = false;
                menuAbilitiesButton.isVisual = true;
            }
            if (driveForm.getDriveFormData().getAbilities() != null) {
                for (String string : driveForm.getDriveFormData().getAbilities()) {
                    Ability ability3 = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)string));
                    if (ability3 == null) continue;
                    MenuAbilitiesButton aa3 = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, ability3.getRegistryName().toString(), ability3.getType(), e -> {});
                    this.abilities.add(aa3);
                    aa3.visible = false;
                    aa3.isVisual = true;
                }
            }
            if (!ItemStack.matches((ItemStack)this.playerData.getEquippedKeychain(DriveForm.NONE), (ItemStack)ItemStack.EMPTY)) {
                List<String> abilitiesList = Utils.getKeybladeAbilitiesAtLevel(this.playerData.getEquippedKeychain(DriveForm.NONE).getItem(), ((IKeychain)this.playerData.getEquippedKeychain(DriveForm.NONE).getItem()).toSummon().getKeybladeLevel(this.playerData.getEquippedKeychain(DriveForm.NONE)));
                for (String string : abilitiesList) {
                    Ability ability2 = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)string));
                    if (ability2 == null) continue;
                    aa = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, ability2.getRegistryName().toString(), Ability.AbilityType.WEAPON, e -> {});
                    this.abilities.add(aa);
                    aa.visible = false;
                }
            }
            if (ModDriveForms.registry.containsKey(ResourceLocation.parse((String)this.form)) && ((DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)this.form))).hasKeychain() && this.playerData.getDriveFormMap().containsKey(this.form) && this.playerData.getEquippedKeychains().containsKey(ResourceLocation.parse((String)this.form)) && !ItemStack.matches((ItemStack)(itemStack = this.playerData.getEquippedKeychain(ResourceLocation.parse((String)this.form))), (ItemStack)ItemStack.EMPTY)) {
                List<String> list = Utils.getKeybladeAbilitiesAtLevel(itemStack.getItem(), ((IKeychain)itemStack.getItem()).toSummon().getKeybladeLevel(itemStack));
                for (String a : list) {
                    Ability ability3 = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)a));
                    if (ability3 == null) continue;
                    aa = new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, ability3.getRegistryName().toString(), Ability.AbilityType.WEAPON, e -> {});
                    this.abilities.add(aa);
                    aa.visible = false;
                }
            }
        }
        this.abilities.forEach(x$0 -> {
            MenuAbilitiesButton cfr_ignored_0 = (MenuAbilitiesButton)this.addWidget((GuiEventListener)x$0);
        });
        this.itemsPerPage = (int)(this.middleHeight / 19.0f);
        this.playerButton = new MenuButton((int)this.buttonPosX, this.buttonPosY, (int)this.buttonWidth, this.minecraft.player.getDisplayName().getString(), MenuButton.ButtonType.BUTTON, b -> this.action(DriveForm.NONE.toString()));
        this.addRenderableWidget((GuiEventListener)this.playerButton);
        ArrayList<String> forms = new ArrayList<String>(Utils.getSortedDriveForms(this.playerData.getDriveFormMap(), Utils.getVisibleDriveForms((Player)this.minecraft.player)).keySet());
        forms.remove(DriveForm.NONE.toString());
        forms.remove(DriveForm.SYNCH_BLADE.toString());
        forms.remove("kingdomkeys:form_anti");
        int k = 0;
        for (k = 0; k < forms.size(); ++k) {
            String string = (String)forms.get(k);
            String string2 = ((DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)string))).getTranslationKey();
            MenuButton b2 = new MenuButton((int)this.buttonPosX + 10, this.buttonPosY + (1 + k) * 18, (int)this.buttonWidth - 10, Utils.translateToLocal(string2, new Object[0]), MenuButton.ButtonType.SUBBUTTON, e -> this.action(formName));
            b2.setData(string);
            this.driveSelector.add(b2);
            this.addRenderableWidget((GuiEventListener)b2);
        }
        this.back = new MenuButton((int)this.buttonPosX, this.buttonPosY + (1 + k) * 18, (int)this.buttonWidth, Component.translatable((String)"gui.menu.back").getString(), MenuButton.ButtonType.BUTTON, b -> this.action("back"));
        this.addRenderableWidget((GuiEventListener)this.back);
        this.scrollBar = new MenuScrollBar((int)(boxPosX + boxWidth - 17.0f), this.scrollTop, this.scrollBot, (int)this.middleHeight, 0);
        this.addRenderableWidget((GuiEventListener)this.scrollBar);
        this.updateButtons();
    }

    @Override
    public void render(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.box.renderWidget(gui, mouseX, mouseY, partialTicks);
        super.render(gui, mouseX, mouseY, partialTicks);
        this.drawAP(gui);
        for (i = 0; i < this.abilities.size(); ++i) {
            if (this.abilities.get(i) == null) continue;
            this.abilities.get((int)i).visible = true;
            this.abilities.get((int)i).active = false;
            this.abilities.get(i).setY((int)this.topBarHeight + i * 19 + 2);
        }
        if (!this.abilities.isEmpty()) {
            int listHeight = this.abilities.get(this.abilities.size() - 1).getY() + 20 - this.abilities.get(0).getY() + 3;
            this.scrollBar.setContentHeight(listHeight);
        }
        gui.enableScissor(0, (int)this.topBarHeight, this.width, (int)(this.topBarHeight + this.middleHeight));
        for (i = 0; i < this.abilities.size(); ++i) {
            if (this.abilities.get(i) == null) continue;
            this.abilities.get(i).setY((int)((float)this.abilities.get(i).getY() - this.scrollBar.scrollOffset));
            if (this.abilities.get(i).getY() >= this.scrollBot || this.abilities.get(i).getY() < this.scrollTop - 20) continue;
            this.abilities.get((int)i).active = true;
            String abilityName = this.abilities.get(i).getText();
            Ability ability = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)abilityName));
            if (ability.getAPCost() > this.playerData.getMaxAP(true) - Utils.getConsumedAP(this.playerData)) {
                this.abilities.get((int)i).active = this.abilities.get((int)i).equipped;
            }
            if (this.abilities.get((int)i).abilityType == Ability.AbilityType.WEAPON || this.abilities.get((int)i).abilityType == Ability.AbilityType.ACCESSORY || this.form.equals(DriveForm.NONE.toString()) && this.playerData.isAbilityEquipped(this.abilities.get(i).getText(), this.abilitiesMap.get(this.abilities.get(i).getText())[0])) {
                this.abilities.get((int)i).active = true;
            }
            this.abilities.get(i).render(gui, mouseX, mouseY, partialTicks);
        }
        gui.disableScissor();
        this.playerButton.render(gui, mouseX, mouseY, partialTicks);
        this.back.render(gui, mouseX, mouseY, partialTicks);
        if (this.hoveredAbility != null) {
            this.renderSelectedData(gui, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderSelectedData(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        ClientUtils.drawSplitString(gui, Component.translatable((String)this.hoveredAbility.getTranslationKey().replace(".name", ".desc")).getString(), (int)tooltipPosX, (int)tooltipPosY, (int)((float)this.width * 0.6f), 65535);
    }

    private void drawAP(GuiGraphics gui) {
        int j;
        int percent;
        int requiredAP;
        int j2;
        PoseStack matrixStack = gui.pose();
        int consumedAP = Utils.getConsumedAP(this.playerData);
        int maxAP = this.playerData.getMaxAP(true);
        this.hoveredAbility = null;
        for (int i = 0; i < this.abilities.size(); ++i) {
            MenuAbilitiesButton button;
            String abilityName = this.abilities.get(i).getText();
            Ability ability = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)abilityName));
            Object lvl = "";
            if (ability.getType() == Ability.AbilityType.GROWTH) {
                DriveForm df = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)this.playerData.getActiveDriveForm()));
                int level = this.form.equals(DriveForm.NONE.toString()) || df.getBaseGrowthAbilities() ? this.playerData.getEquippedAbilityLevel(abilityName)[0] : this.playerData.getEquippedAbilityLevel(abilityName)[0] + 1;
                lvl = (String)lvl + "_" + level;
            }
            abilityName = ability.getTranslationKey();
            String text = Utils.translateToLocal(new StringBuilder(abilityName).insert(abilityName.lastIndexOf(46), (String)lvl).toString(), new Object[0]);
            if (!(this.abilities.get(i) instanceof MenuAbilitiesButton) || !(button = this.getMenuAbilitiesButton(i, text, ability)).isHovered()) continue;
            this.hoveredAbility = ability;
            this.hoveredIndex = button.index;
            this.hoveredType = button.abilityType;
        }
        int screenWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int screenHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        int barWidth = (int)((float)this.width * 0.2f);
        int posX = screenWidth - barWidth;
        int posY = screenHeight - 100;
        float scale = 1.0f;
        matrixStack.pushPose();
        matrixStack.translate((float)(posX - 2) * scale - 20.0f, (float)posY * scale - 10.0f, 0.0f);
        matrixStack.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.blit(this.texture, 0, 0, 143, 67, 7, 25);
        matrixStack.popPose();
        matrixStack.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (j2 = 0; j2 < barWidth; ++j2) {
            gui.blit(this.texture, 7 + j2, 0, 151, 67, 1, 25);
        }
        matrixStack.popPose();
        matrixStack.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.blit(this.texture, 7 + barWidth, 0, 153, 67, 7, 25);
        matrixStack.popPose();
        matrixStack.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (j2 = 0; j2 < barWidth; ++j2) {
            gui.blit(this.texture, j2 + 7, 17, 161, 67, 1, 25);
        }
        matrixStack.popPose();
        int n = requiredAP = this.hoveredAbility != null ? this.hoveredAbility.getAPCost() : 0;
        if (this.hoveredType != Ability.AbilityType.WEAPON && this.hoveredType != Ability.AbilityType.ACCESSORY) {
            if (this.hoveredAbility != null && this.playerData.isAbilityEquipped(this.hoveredAbility.getRegistryName().toString(), this.hoveredIndex)) {
                requiredAP *= -1;
                matrixStack.pushPose();
                percent = consumedAP * barWidth / maxAP;
                matrixStack.pushPose();
                for (j = 0; j < percent; ++j) {
                    gui.blit(this.texture, j + 7, 17, 165, 67, 1, 5);
                }
                matrixStack.popPose();
                matrixStack.popPose();
            } else if (consumedAP + requiredAP <= this.playerData.getMaxAP(true)) {
                matrixStack.pushPose();
                percent = (consumedAP + requiredAP) * barWidth / maxAP;
                matrixStack.pushPose();
                for (j = 0; j < percent; ++j) {
                    gui.blit(this.texture, j + 7, 17, 167, 67, 1, 5);
                }
                matrixStack.popPose();
                matrixStack.popPose();
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.pushPose();
        percent = consumedAP * barWidth / maxAP;
        if (requiredAP < 0) {
            percent = (consumedAP + requiredAP) * barWidth / maxAP;
        }
        for (j = 0; j < percent; ++j) {
            gui.blit(this.texture, j + 7, 17, 163, 67, 1, 5);
        }
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.scale(scale * 1.3f, scale * 1.1f, 0.0f);
        gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.status.ap", new Object[0]) + ": " + consumedAP + "/" + maxAP, 16, 5, 0xFFFFFF);
        matrixStack.popPose();
        matrixStack.popPose();
    }

    @NotNull
    private MenuAbilitiesButton getMenuAbilitiesButton(int i, String text, Ability ability) {
        MenuAbilitiesButton button = this.abilities.get(i);
        button.setMessage((Component)Component.translatable((String)text));
        button.setAP(ability.getAPCost());
        return button;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.scrollBar.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 1) {
            PacketHandler.sendToServer(new CSOpenMenu());
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.scrollBar.mouseReleased(pMouseX, pMouseY, pButton);
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.scrollBar.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }
}

