/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.customize;

import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.client.gui.menu.customize.MenuCustomizeScreen;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.CommandMenuGui;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MenuCustomizeMagicScreen
extends MenuBackground {
    MenuBox boxLeft;
    MenuBox boxRight;
    LinkedHashMap<ResourceLocation, MagicButton> displayedMagic;
    LinkedHashMap<ResourceLocation, MagicButton> allMagic;
    MenuButton back;
    MenuScrollBar leftScroll;
    MenuScrollBar rightScroll;
    int buttonsX = 0;
    float boxLeftPosX;
    float boxRightPosX;
    float topBarHeight;
    float boxWidth;
    int rightListHeight = 0;
    int leftListHeight = 0;

    public MenuCustomizeMagicScreen(LinkedHashMap<String, int[]> knownMagic) {
        super("gui.menu.customize.magic", new Color(0, 0, 255));
        this.drawPlayerInfo = false;
        this.displayedMagic = new LinkedHashMap();
        this.allMagic = new LinkedHashMap();
        knownMagic.forEach((s, ints) -> {
            if (ModMagic.registry.containsKey(ResourceLocation.parse((String)s))) {
                this.allMagic.put(ResourceLocation.parse((String)s), new MagicButton(new MenuButton(0, 0, 100, ((Magic)ModMagic.registry.get(ResourceLocation.parse((String)s))).getTranslationKey(ints[0]), MenuButton.ButtonType.BUTTON, pButton -> this.magicAction(ResourceLocation.parse((String)s))), ints[0], false));
            }
        });
        ModConfigs.magicDisplayedInCommandMenu.forEach(magic -> {
            ResourceLocation magicKey = ResourceLocation.parse((String)magic);
            if (this.allMagic.containsKey(magicKey)) {
                MagicButton magicButton = this.allMagic.get(magicKey);
                magicButton.setDisplay(true);
                this.displayedMagic.put(magicKey, magicButton);
                this.allMagic.remove(magicKey);
            }
        });
    }

    protected void magicAction(ResourceLocation magic) {
        MagicButton magicButton = this.allMagic.containsKey(magic) ? this.allMagic.get(magic) : this.displayedMagic.get(magic);
        if (!magicButton.display) {
            magicButton.setDisplay(true);
            this.displayedMagic.put(magic, magicButton);
            this.allMagic.remove(magic);
        } else {
            magicButton.setDisplay(false);
            this.allMagic.put(magic, magicButton);
            this.displayedMagic.remove(magic);
        }
        this.updateMagicButtons(false);
        ModConfigs.setMagicDisplayedInCommandMenu(this.displayedMagic.keySet().stream().map(ResourceLocation::toString).toList());
        if (this.displayedMagic.isEmpty() && CommandMenuGui.INSTANCE.currentSubmenu == CommandMenuGui.INSTANCE.magic) {
            CommandMenuGui.INSTANCE.changeSubmenu(CommandMenuGui.INSTANCE.root, true);
        }
    }

    protected void action(String string) {
        switch (string) {
            case "back": {
                Minecraft.getInstance().setScreen((Screen)new MenuCustomizeScreen());
            }
        }
    }

    @Override
    public void init() {
        this.boxLeftPosX = (float)this.width * 0.25f;
        this.boxRightPosX = (float)this.width * 0.5f;
        this.topBarHeight = (float)this.height * 0.17f;
        this.boxWidth = (float)this.width * 0.25f;
        float middleHeight = (float)this.height * 0.6f;
        this.boxLeft = new MenuBox((int)this.boxLeftPosX, (int)this.topBarHeight, (int)this.boxWidth, (int)middleHeight, 0.6f, new Color(4, 4, 68));
        this.boxRight = new MenuBox((int)this.boxRightPosX, (int)this.topBarHeight, (int)this.boxWidth, (int)middleHeight, 0.6f, new Color(4, 4, 68));
        this.buttonsX = this.boxLeft.getX() + 10;
        this.buttonPosY = (int)(this.topBarHeight + 5.0f);
        super.init();
        int n = (int)(this.boxRightPosX + this.boxWidth - 14.0f);
        int n2 = (int)this.topBarHeight;
        int n3 = (int)(this.topBarHeight + middleHeight);
        int n4 = (int)middleHeight - 3;
        Objects.requireNonNull(this.font);
        this.rightScroll = new MenuScrollBar(n, n2, n3, n4 - 9, 0);
        this.addRenderableWidget((GuiEventListener)this.rightScroll);
        int n5 = (int)(this.boxLeftPosX + this.boxWidth - 14.0f);
        int n6 = (int)this.topBarHeight;
        int n7 = (int)(this.topBarHeight + middleHeight);
        int n8 = (int)middleHeight - 3;
        Objects.requireNonNull(this.font);
        this.leftScroll = new MenuScrollBar(n5, n6, n7, n8 - 9, 0);
        this.addRenderableWidget((GuiEventListener)this.leftScroll);
        this.updateMagicButtons(true);
        this.back = new MenuButton((int)this.buttonPosX, this.buttonPosY, (int)this.buttonWidth, Utils.translateToLocal("gui.menu.back", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("back"));
        this.addRenderableWidget((GuiEventListener)this.back);
    }

    public void updateMagicButtons(boolean init) {
        MenuButton button;
        ResourceLocation key;
        int i;
        this.renderables.clear();
        this.children().clear();
        for (i = 0; i < this.displayedMagic.size(); ++i) {
            key = (ResourceLocation)this.displayedMagic.keySet().stream().toList().get(i);
            button = this.displayedMagic.get((Object)key).button;
            button.setX((int)this.boxRightPosX);
            button.setY((int)(this.topBarHeight - this.rightScroll.scrollOffset + 15.0f + (float)(i * 20)));
            button.setWidth((int)this.boxWidth - 22 - 14);
            this.addRenderableWidget((GuiEventListener)button);
        }
        for (i = 0; i < this.allMagic.size(); ++i) {
            key = (ResourceLocation)this.allMagic.keySet().stream().toList().get(i);
            button = this.allMagic.get((Object)key).button;
            button.setX((int)this.boxLeftPosX);
            button.setY((int)(this.topBarHeight - this.leftScroll.scrollOffset + 15.0f + (float)(i * 20)));
            button.setWidth((int)this.boxWidth - 22 - 14);
            this.addRenderableWidget((GuiEventListener)button);
        }
        if (!init) {
            this.addRenderableWidget((GuiEventListener)this.rightScroll);
            this.addRenderableWidget((GuiEventListener)this.leftScroll);
            this.addRenderableWidget((GuiEventListener)this.back);
        }
        if (!this.displayedMagic.isEmpty()) {
            this.rightListHeight = this.displayedMagic.get((Object)((ResourceLocation)this.displayedMagic.keySet().toArray()[this.displayedMagic.size() - 1])).button.getY() + 20 - this.displayedMagic.get((Object)((ResourceLocation)this.displayedMagic.keySet().toArray()[0])).button.getY() + 5;
        }
        if (!this.allMagic.isEmpty()) {
            this.leftListHeight = this.allMagic.get((Object)((ResourceLocation)this.allMagic.keySet().toArray()[this.allMagic.size() - 1])).button.getY() + 20 - this.allMagic.get((Object)((ResourceLocation)this.allMagic.keySet().toArray()[0])).button.getY() + 5;
        }
        this.rightScroll.setContentHeight(this.rightListHeight);
        this.leftScroll.setContentHeight(this.leftListHeight);
    }

    @Override
    public void render(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.drawMenuBackground(gui, mouseX, mouseY, partialTicks);
        this.boxLeft.renderWidget(gui, mouseX, mouseY, partialTicks);
        this.boxRight.renderWidget(gui, mouseX, mouseY, partialTicks);
        this.updateMagicButtons(false);
        this.drawSeparately = true;
        gui.drawCenteredString(Minecraft.getInstance().font, "Hidden", (int)(this.boxLeftPosX + this.boxWidth / 2.0f), (int)this.topBarHeight + 3, 0xFFFFFF);
        gui.drawCenteredString(Minecraft.getInstance().font, "Command Menu", (int)(this.boxRightPosX + this.boxWidth / 2.0f), (int)this.topBarHeight + 3, 0xFFFFFF);
        int n = (int)this.boxLeftPosX;
        int n2 = (int)this.topBarHeight + 3;
        Objects.requireNonNull(this.font);
        gui.enableScissor(n, n2 + 9, this.boxLeft.getWidth() * 4, (int)(this.topBarHeight + this.middleHeight));
        for (Renderable renderable : this.renderables) {
            Button button;
            if (!(renderable instanceof Button) || !((float)(button = (Button)renderable).getX() >= this.boxLeftPosX - 1.0f)) continue;
            renderable.render(gui, mouseX, mouseY, partialTicks);
        }
        gui.disableScissor();
        this.back.render(gui, mouseX, mouseY, partialTicks);
        this.rightScroll.render(gui, mouseX, mouseY, partialTicks);
        this.leftScroll.render(gui, mouseX, mouseY, partialTicks);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        this.rightScroll.mouseClicked(pMouseX, pMouseY, pButton);
        this.leftScroll.mouseClicked(pMouseX, pMouseY, pButton);
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.rightScroll.mouseReleased(pMouseX, pMouseY, pButton);
        this.leftScroll.mouseReleased(pMouseX, pMouseY, pButton);
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.rightScroll.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        this.leftScroll.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double deltaX, double deltaY) {
        if (pMouseX >= (double)((float)Minecraft.getInstance().screen.width / 2.0f)) {
            this.rightScroll.mouseScrolled(pMouseX, pMouseY, deltaX, deltaY);
        } else {
            this.leftScroll.mouseScrolled(pMouseX, pMouseY, deltaX, deltaY);
        }
        return super.mouseScrolled(pMouseX, pMouseY, deltaX, deltaY);
    }

    static class MagicButton {
        MenuButton button;
        int level;
        boolean display;

        public MagicButton(MenuButton button, int level, boolean display) {
            this.button = button;
            this.level = level;
            this.display = display;
        }

        public MenuButton getButton() {
            return this.button;
        }

        public void setButton(MenuButton button) {
            this.button = button;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isDisplay() {
            return this.display;
        }

        public void setDisplay(boolean display) {
            this.display = display;
        }
    }
}

